/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.GetVillagerRequest;
import net.conczin.mca.network.s2c.PlayerDataMessage;
import net.conczin.mca.resources.ClothingList;
import net.conczin.mca.resources.HairList;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record VillagerEditorSyncRequest(String command, UUID uuid, class_2487 data) implements HandleablePayload
{
    public static final class_8710.class_9154<VillagerEditorSyncRequest> TYPE = new class_8710.class_9154(MCA.locate("villager_editor_sync_request"));
    public static final class_9139<class_2540, VillagerEditorSyncRequest> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, VillagerEditorSyncRequest::command, (class_9139)class_4844.field_48453, VillagerEditorSyncRequest::uuid, (class_9139)class_9135.field_48556, VillagerEditorSyncRequest::data, VillagerEditorSyncRequest::new);

    @Override
    public void handleServer(class_3222 player) {
        class_1297 entity = player.method_51469().method_14190(this.uuid);
        switch (this.command) {
            case "hair": {
                this.setHair(player, entity);
                break;
            }
            case "clothing": {
                this.setClothing(player, entity);
                break;
            }
            case "gender": {
                this.setHair(player, entity);
                this.setClothing(player, entity);
                break;
            }
            case "sync": {
                this.saveEntity(player, entity, this.data());
                break;
            }
            case "profession": {
                if (!(entity instanceof VillagerEntityMCA)) break;
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                class_3852 profession = (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)this.data.method_10558("profession")));
                villager.setProfession(profession);
            }
        }
    }

    private void setHair(class_3222 player, class_1297 entity) {
        class_2487 villagerData = GetVillagerRequest.getVillagerData(entity);
        if (villagerData != null) {
            String hair = this.data.method_10545("offset") ? HairList.getInstance().getPool(this.getGender(villagerData)).pickNext(villagerData.method_10558("Hair"), this.data.method_10550("offset")) : HairList.getInstance().getPool(this.getGender(villagerData)).pickOne();
            villagerData.method_10582("Hair", hair);
            this.saveEntity(player, entity, villagerData);
        }
    }

    private void setClothing(class_3222 player, class_1297 entity) {
        class_2487 villagerData = GetVillagerRequest.getVillagerData(entity);
        if (villagerData != null) {
            String clothes = "mca:missing";
            if (entity instanceof class_1657) {
                clothes = this.data.method_10545("offset") ? ClothingList.getInstance().getPool(this.getGender(villagerData), class_3852.field_17051).pickNext(villagerData.method_10558("Clothes"), this.data.method_10550("offset")) : ClothingList.getInstance().getPool(this.getGender(villagerData), class_3852.field_17051).pickOne();
            } else if (entity instanceof VillagerLike) {
                VillagerLike villager = (VillagerLike)entity;
                clothes = this.data.method_10545("offset") ? ClothingList.getInstance().getPool(villager).pickNext(villager.getClothes(), this.data.method_10550("offset")) : ClothingList.getInstance().getPool(villager).pickOne();
            }
            villagerData.method_10582("Clothes", clothes);
            this.saveEntity(player, entity, villagerData);
        }
    }

    private void saveEntity(class_3222 player, class_1297 entity, class_2487 villagerData) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            PlayerSaveData data = PlayerSaveData.get(serverPlayer);
            data.setEntityData(villagerData);
            data.setEntityDataSet(true);
            this.syncFamilyTree(player, entity, villagerData);
            serverPlayer.method_51469().method_18456().forEach(p -> Network.sendToPlayer(new PlayerDataMessage(player.method_5667(), villagerData), p));
        } else if (entity instanceof VillagerLike) {
            VillagerLike villagerLike = (VillagerLike)entity;
            villagerLike.syncFromEditor(villagerData);
            entity.method_18382();
            this.syncFamilyTree(player, entity, villagerData);
            if (entity instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.getResidency().getHomeVillage().ifPresent(b -> b.updateResident(villager));
            }
        }
    }

    private Gender getGender(class_2487 villagerData) {
        return Gender.byId(villagerData.method_10550("gender"));
    }

    private Optional<FamilyTreeNode> getFamilyNode(class_3222 player, FamilyTree tree, String name, Gender gender) {
        try {
            UUID uuid = UUID.fromString(name);
            Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
            if (node.isPresent()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"gui.villager_editor.uuid_known", (Object[])new Object[]{name, node.get().getName()}), true);
                return node;
            }
            player.method_7353((class_2561)class_2561.method_43469((String)"gui.villager_editor.uuid_unknown", (Object[])new Object[]{name}).method_27692(class_124.field_1061), true);
            return Optional.empty();
        }
        catch (IllegalArgumentException exception) {
            List<FamilyTreeNode> nodes = tree.getAllWithName(name).toList();
            if (nodes.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"gui.villager_editor.name_created", (Object[])new Object[]{name}).method_27692(class_124.field_1054), true);
                return Optional.of(tree.getOrCreate(UUID.randomUUID(), name, gender));
            }
            if (nodes.size() > 1) {
                player.method_7353((class_2561)class_2561.method_43469((String)"gui.villager_editor.name_not_unique", (Object[])new Object[]{name}).method_27692(class_124.field_1061), true);
                String uuids = nodes.stream().map(FamilyTreeNode::id).map(UUID::toString).collect(Collectors.joining(", "));
                player.method_7353((class_2561)class_2561.method_43469((String)"gui.villager_editor.list_of_ids", (Object[])new Object[]{uuids}), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"gui.villager_editor.name_unique", (Object[])new Object[]{name}), true);
            }
            return Optional.ofNullable(nodes.getFirst());
        }
    }

    private void syncFamilyTree(class_3222 player, class_1297 entity, class_2487 villagerData) {
        String name;
        FamilyTree tree = FamilyTree.get((class_3218)entity.method_37908());
        FamilyTreeNode entry = tree.getOrCreate(entity);
        entry.setGender(this.getGender(this.data));
        String s = villagerData.method_10558("CustomName");
        if (!s.isEmpty()) {
            try {
                entry.setName(Objects.requireNonNull(class_2561.class_2562.method_10877((String)s, (class_7225.class_7874)entity.method_56673())).getString());
            }
            catch (Exception e) {
                MCA.LOGGER.error("Failed to parse custom name for villager: {}", (Object)s, (Object)e);
            }
        }
        if (villagerData.method_10545("FamilyTreeNewFatherName")) {
            name = villagerData.method_10558("FamilyTreeNewFatherName");
            if (MCA.isBlankString(name)) {
                entry.removeFather();
            } else {
                this.getFamilyNode(player, tree, name, Gender.MALE).ifPresent(entry::setFather);
            }
        }
        if (villagerData.method_10545("FamilyTreeNewMotherName")) {
            name = villagerData.method_10558("FamilyTreeNewMotherName");
            if (MCA.isBlankString(name)) {
                entry.removeMother();
            } else {
                this.getFamilyNode(player, tree, name, Gender.FEMALE).ifPresent(entry::setMother);
            }
        }
        if (villagerData.method_10545("FamilyTreeNewSpouseName")) {
            name = villagerData.method_10558("FamilyTreeNewSpouseName");
            if (MCA.isBlankString(name)) {
                Optional.of(entry.partner()).flatMap(tree::getOrEmpty).ifPresent(node -> node.updatePartner(null, null));
                entry.updatePartner(null, null);
            } else {
                this.getFamilyNode(player, tree, name, entry.gender().opposite()).ifPresent(node -> {
                    entry.updatePartner((FamilyTreeNode)node);
                    node.updatePartner(entry);
                });
            }
        }
    }

    public class_8710.class_9154<VillagerEditorSyncRequest> method_56479() {
        return TYPE;
    }
}

