/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data.villageComponents;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.conczin.mca.Config;
import net.conczin.mca.resources.Rank;
import net.conczin.mca.resources.Tasks;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class VillageTaxesManager {
    private static final int MAX_STORAGE_SIZE = 1024;
    private final Village village;

    public VillageTaxesManager(Village village) {
        this.village = village;
    }

    public void taxes(class_3218 world) {
        class_5250 msg;
        double taxes = (double)(Config.getInstance().taxesFactor * (float)this.village.getPopulation() * this.village.getTaxes()) + world.field_9229.method_43058();
        int moodImpact = 0;
        float r = this.village.getTaxes() + (world.field_9229.method_43057() - 0.5f) * world.field_9229.method_43057();
        if (this.village.getTaxes() == 0.0f) {
            msg = class_2561.method_43469((String)"gui.village.taxes.no", (Object[])new Object[]{this.village.getName()}).method_27692(class_124.field_1060);
            moodImpact = 5;
            taxes = 0.0;
        } else if ((double)r < 0.1) {
            msg = class_2561.method_43469((String)"gui.village.taxes.more", (Object[])new Object[]{this.village.getName()}).method_27692(class_124.field_1060);
            taxes += (double)this.village.getPopulation() * 0.25;
        } else if ((double)r < 0.3) {
            msg = class_2561.method_43469((String)"gui.village.taxes.happy", (Object[])new Object[]{this.village.getName()}).method_27692(class_124.field_1077);
            moodImpact = 5;
        } else if ((double)r < 0.7) {
            msg = class_2561.method_43469((String)"gui.village.taxes", (Object[])new Object[]{this.village.getName()});
        } else if ((double)r < 0.8) {
            msg = class_2561.method_43469((String)"gui.village.taxes.sad", (Object[])new Object[]{this.village.getName()}).method_27692(class_124.field_1065);
            moodImpact = -5;
        } else if ((double)r < 0.9) {
            msg = class_2561.method_43469((String)"gui.village.taxes.angry", (Object[])new Object[]{this.village.getName()}).method_27692(class_124.field_1061);
            moodImpact = -10;
        } else {
            msg = class_2561.method_43469((String)"gui.village.taxes.riot", (Object[])new Object[]{this.village.getName()}).method_27692(class_124.field_1079);
            taxes = 0.0;
        }
        world.method_18456().stream().filter(v -> Tasks.getRank(this.village, v).isAtLeast(Rank.MERCHANT)).forEach(arg_0 -> VillageTaxesManager.lambda$taxes$1((class_2561)msg, arg_0));
        if (this.village.hasBuilding("library")) {
            taxes *= 1.5;
        }
        while (taxes > 0.0) {
            double finalTaxes = taxes;
            List<String> valids = Config.getInstance().taxesMap.entrySet().stream().filter(e -> (double)(((Float)e.getValue()).floatValue() * world.field_9229.method_43057()) < finalTaxes).map(Map.Entry::getKey).toList();
            if (valids.isEmpty()) break;
            String itemName = valids.get(world.field_9229.method_43048(valids.size()));
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)itemName));
            if (item == class_1802.field_8162) {
                throw new RuntimeException("The taxes map contains an invalid item %s!".formatted(itemName));
            }
            taxes -= (double)Config.getInstance().taxesMap.get(itemName).floatValue();
            Optional<class_1799> stack = this.village.storageBuffer.stream().filter(i -> i.method_31574(item) && i.method_7947() < i.method_7914()).findAny();
            if (stack.isPresent()) {
                stack.get().method_7933(1);
                continue;
            }
            if (this.village.storageBuffer.size() >= 1024) continue;
            this.village.storageBuffer.add(new class_1799((class_1935)item, 1));
        }
        if (moodImpact != 0) {
            this.village.pushMood(moodImpact);
        }
        this.deliverTaxes(world);
    }

    public void deliverTaxes(class_3218 world) {
        if (this.village.hasStoredResource() && WorldUtils.isChunkLoaded(world, this.village.getCenter())) {
            this.village.getBuildingsOfType("storage").forEach(building -> building.getBlocks().values().stream().flatMap(Collection::stream).forEach(p -> {
                if (this.village.hasStoredResource()) {
                    this.tryToPutIntoInventory(world, (class_2338)p);
                }
            }));
        }
    }

    private void tryToPutIntoInventory(class_3218 world, class_2338 p) {
        class_2586 blockEntity;
        class_2680 state = world.method_8320(p);
        if (state.method_31709() && (blockEntity = world.method_8321(p)) instanceof class_1263) {
            class_2281 chest;
            class_1263 inventory = (class_1263)blockEntity;
            class_2248 block = state.method_26204();
            if (inventory instanceof class_2595 && block instanceof class_2281 && (inventory = class_2281.method_17458((class_2281)(chest = (class_2281)block), (class_2680)state, (class_1937)world, (class_2338)p, (boolean)true)) != null) {
                this.putIntoInventory(inventory);
            }
        }
    }

    private void putIntoInventory(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            boolean changes = true;
            while (changes) {
                changes = false;
                class_1799 stack = inventory.method_5438(i);
                class_1799 tax = this.village.storageBuffer.getFirst();
                if (stack.method_7909() == tax.method_7909()) {
                    int diff = Math.min(tax.method_7947(), stack.method_7914() - stack.method_7947());
                    if (diff > 0) {
                        stack.method_7933(diff);
                        tax.method_7934(diff);
                        if (tax.method_7960()) {
                            this.village.storageBuffer.removeFirst();
                            changes = true;
                        }
                        inventory.method_5431();
                    }
                } else if (stack.method_7960()) {
                    inventory.method_5447(i, tax);
                    inventory.method_5431();
                    this.village.storageBuffer.removeFirst();
                    changes = true;
                }
                if (this.village.hasStoredResource()) continue;
                return;
            }
        }
    }

    private static /* synthetic */ void lambda$taxes$1(class_2561 msg, class_3222 player) {
        player.method_7353(msg, true);
    }
}

