/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.util;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1829;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5134;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public interface InventoryUtils {
    public static Stream<class_1799> stream(class_1263 inventory) {
        return IntStream.range(0, inventory.method_5439()).mapToObj(arg_0 -> ((class_1263)inventory).method_5438(arg_0));
    }

    public static int getFirstSlotContainingItem(class_1263 inv, Predicate<class_1799> predicate) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (!predicate.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(class_1263 inv, Class<?> clazz) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            class_1792 item = stack.method_7909();
            if (item.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public static class_1799 getBestItemOfType(class_1263 inv, @Nullable Class<?> type) {
        return type == null ? class_1799.field_8037 : inv.method_5438(InventoryUtils.getBestItemOfTypeSlot(inv, type));
    }

    public static int getBestItemOfTypeSlot(class_1263 inv, Class<?> type) {
        int highestMaxDamage = 0;
        int best = -1;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stackInInventory = inv.method_5438(i);
            String itemClassName = stackInInventory.method_7909().getClass().getName();
            if (!itemClassName.equals(type.getName()) || highestMaxDamage >= stackInInventory.method_7936()) continue;
            highestMaxDamage = stackInInventory.method_7936();
            best = i;
        }
        return best;
    }

    public static Optional<class_1799> getBestArmor(class_1263 inv, class_1304 slot) {
        return InventoryUtils.stream(inv).filter(s -> s.method_7909() instanceof class_1738).filter(s -> ((class_1738)s.method_7909()).method_7685() == slot).max(Comparator.comparingDouble(s -> ((class_1738)s.method_7909()).method_7687()));
    }

    public static Optional<class_1799> getBestSword(class_1263 inv) {
        return InventoryUtils.stream(inv).filter(s -> s.method_7909() instanceof class_1829).max(Comparator.comparingDouble(class_1799::method_7936));
    }

    public static Optional<class_1799> getBestRanged(class_1263 inv) {
        return InventoryUtils.stream(inv).filter(s -> s.method_7909() instanceof class_1811).max(Comparator.comparingDouble(class_1799::method_7936));
    }

    public static void dropAllItems(class_1297 entity, class_1263 inv) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            entity.method_5699(stack, 1.0f);
        }
        inv.method_5448();
    }

    public static void saveToNBT(class_5455 registryAccess, class_1277 inv, class_2487 nbt) {
        nbt.method_10566("Inventory", (class_2520)inv.method_7660((class_7225.class_7874)registryAccess));
    }

    public static void readFromNBT(class_5455 registryAccess, class_1277 inv, class_2487 nbt) {
        inv.method_7659(nbt.method_10554("Inventory", 10), (class_7225.class_7874)registryAccess);
    }

    public static double approximateDamage(class_1799 stack, class_1309 entity) {
        double base = entity.method_45326(class_5134.field_23721);
        class_9285 comp = (class_9285)stack.method_57824(class_9334.field_49636);
        return comp == null ? base : comp.method_57481(base, class_1304.field_6173);
    }
}

