/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server;

import forge.net.mca.Config;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.ai.relationship.EntityRelationship;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.item.BabyItem;
import forge.net.mca.network.s2c.OpenDestinyGuiRequest;
import forge.net.mca.network.s2c.ShowToastRequest;
import forge.net.mca.server.world.data.PlayerSaveData;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ServerInteractionManager {
    private static final ServerInteractionManager INSTANCE = new ServerInteractionManager();
    private final Map<UUID, List<UUID>> proposals = new HashMap<UUID, List<UUID>>();
    private final Object2LongArrayMap<UUID> procreateMap = new Object2LongArrayMap();

    private ServerInteractionManager() {
    }

    public static ServerInteractionManager getInstance() {
        return INSTANCE;
    }

    public static void launchDestiny(ServerPlayer player) {
        NetworkHandler.sendToPlayer(new OpenDestinyGuiRequest(player), player);
    }

    public void tick() {
        ArrayList removals = new ArrayList();
        this.procreateMap.keySet().stream().filter(k -> this.procreateMap.getLong(k) < System.currentTimeMillis()).forEach(removals::add);
        removals.forEach(arg_0 -> this.procreateMap.removeLong(arg_0));
    }

    public void onPlayerJoin(ServerPlayer player) {
        PlayerSaveData playerData = PlayerSaveData.get(player);
        if (!playerData.isEntityDataSet()) {
            if (Config.getInstance().launchIntoDestiny) {
                ServerInteractionManager.launchDestiny(player);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 3600));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 3600));
            } else if (Config.getInstance().allowDestinyCommandOnce) {
                NetworkHandler.sendToPlayer(new ShowToastRequest("server.destinyNotSet.title", "server.destinyNotSet.description"), player);
            } else if (Config.getInstance().allowFullPlayerEditor) {
                NetworkHandler.sendToPlayer(new ShowToastRequest("server.playerNotCustomized.title", "server.playerNotCustomized.description"), player);
            }
        }
        if (playerData.hasMail()) {
            PlayerSaveData.showMailNotification(player);
        }
    }

    private boolean hasProposalFrom(ServerPlayer sender, ServerPlayer receiver) {
        return this.getProposalsFor(receiver).contains(sender.m_20148_());
    }

    private List<UUID> getProposalsFor(ServerPlayer player) {
        return this.proposals.getOrDefault(player.m_20148_(), new ArrayList());
    }

    private void removeProposalFor(ServerPlayer target, ServerPlayer proposer) {
        List<UUID> list = this.getProposalsFor(target);
        list.remove(proposer.m_20148_());
        this.proposals.put(target.m_20148_(), list);
    }

    public void listProposals(ServerPlayer sender) {
        List<UUID> proposals = this.getProposalsFor(sender);
        if (proposals.size() == 0) {
            this.infoMessage((Player)sender, Component.m_237115_((String)"server.noProposals"));
        } else {
            this.infoMessage((Player)sender, Component.m_237115_((String)"server.proposals"));
        }
        proposals.forEach(uuid -> {
            Player player = sender.m_9236_().m_46003_(uuid);
            if (player != null) {
                this.infoMessage((Player)sender, Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237113_((String)player.m_6302_())));
            }
        });
    }

    public void sendProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!Config.getInstance().allowPlayerMarriage) {
            this.failMessage((Player)sender, Component.m_237115_((String)"notify.playerMarriage.disabled"));
            return;
        }
        if (PlayerSaveData.get(sender).isMarried()) {
            this.failMessage((Player)sender, Component.m_237115_((String)"server.alreadyMarried"));
            return;
        }
        if (sender == receiver) {
            this.failMessage((Player)sender, Component.m_237115_((String)"server.proposedToYourself"));
            return;
        }
        if (this.hasProposalFrom(sender, receiver)) {
            this.failMessage((Player)sender, Component.m_237110_((String)"server.sentProposal", (Object[])new Object[]{receiver.m_6302_()}));
        } else {
            this.successMessage((Player)sender, Component.m_237110_((String)"server.proposalSent", (Object[])new Object[]{receiver.m_6302_()}));
            this.infoMessage((Player)receiver, Component.m_237110_((String)"server.proposedMarriage", (Object[])new Object[]{sender.m_6302_()}));
            List<UUID> list = this.getProposalsFor(receiver);
            list.add(sender.m_20148_());
            this.proposals.put(receiver.m_20148_(), list);
        }
    }

    public void rejectProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((Player)sender, Component.m_237110_((String)"server.noProposal", (Object[])new Object[]{receiver.m_5446_()}));
        } else {
            this.successMessage((Player)sender, Component.m_237115_((String)"server.proposalRejectionSent"));
            this.failMessage((Player)receiver, Component.m_237110_((String)"server.proposalRejected", (Object[])new Object[]{sender.m_6302_()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void acceptProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((Player)sender, Component.m_237110_((String)"server.noProposal", (Object[])new Object[]{receiver.m_5446_()}));
        } else {
            this.successMessage((Player)receiver, Component.m_237110_((String)"server.proposalAccepted", (Object[])new Object[]{sender.m_5446_()}));
            PlayerSaveData.get(sender).marry((Entity)receiver);
            PlayerSaveData.get(receiver).marry((Entity)sender);
            this.successMessage((Player)sender, Component.m_237110_((String)"server.married", (Object[])new Object[]{receiver.m_5446_()}));
            this.successMessage((Player)receiver, Component.m_237110_((String)"server.married", (Object[])new Object[]{sender.m_5446_()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void endMarriage(ServerPlayer sender) {
        EntityRelationship.of((Entity)sender).ifPresent(senderData -> {
            if (!senderData.isMarried()) {
                this.failMessage((Player)sender, Component.m_237115_((String)"server.endMarriageNotMarried"));
                return;
            }
            if (senderData.getRelationshipState() != RelationshipState.MARRIED_TO_PLAYER) {
                this.failMessage((Player)sender, Component.m_237115_((String)"server.marriedToVillager"));
                return;
            }
            senderData.getPartnerName().ifPresent(name -> this.successMessage((Player)sender, Component.m_237110_((String)"server.endMarriage", (Object[])new Object[]{name.getString()})));
            senderData.getPartner().ifPresent(spouse -> {
                if (spouse instanceof Player) {
                    Player player = (Player)spouse;
                    this.failMessage(player, Component.m_237110_((String)"server.marriageEnded", (Object[])new Object[]{sender.m_6302_()}));
                }
            });
            senderData.endRelationShip(RelationshipState.SINGLE);
            senderData.getPartnerUUID().map(id -> PlayerSaveData.get(sender)).ifPresent(r -> r.endRelationShip(RelationshipState.SINGLE));
        });
    }

    public void procreate(ServerPlayer sender) {
        PlayerSaveData senderData = PlayerSaveData.get(sender);
        if (!senderData.isMarried()) {
            this.failMessage((Player)sender, Component.m_237115_((String)"server.notMarried"));
            return;
        }
        if (senderData.getRelationshipState() != RelationshipState.MARRIED_TO_PLAYER) {
            this.failMessage((Player)sender, Component.m_237115_((String)"server.marriedToVillager"));
            return;
        }
        senderData.getPartner().filter(e -> e instanceof Player).map(Player.class::cast).ifPresentOrElse(spouse -> {
            if (!this.procreateMap.containsKey((Object)spouse.m_20148_())) {
                this.procreateMap.put((Object)sender.m_20148_(), System.currentTimeMillis() + 10000L);
                this.infoMessage((Player)spouse, Component.m_237110_((String)"server.procreationRequest", (Object[])new Object[]{sender.m_6302_()}));
            } else {
                this.successMessage((Player)sender, Component.m_237115_((String)"server.procreationSuccessful"));
                this.successMessage((Player)spouse, Component.m_237115_((String)"server.procreationSuccessful"));
                spouse.m_36356_(BabyItem.createItem((Entity)spouse, (Entity)sender, spouse.m_217043_().m_188505_()));
            }
        }, () -> this.failMessage((Player)sender, Component.m_237115_((String)"server.spouseNotPresent")));
    }

    private void successMessage(Player player, MutableComponent message) {
        player.m_213846_((Component)message.m_130940_(ChatFormatting.GREEN));
    }

    private void failMessage(Player player, MutableComponent message) {
        player.m_213846_((Component)message.m_130940_(ChatFormatting.RED));
    }

    private void infoMessage(Player player, MutableComponent message) {
        player.m_213846_((Component)message.m_130940_(ChatFormatting.YELLOW));
    }
}

