/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.conczin.mca.MCA;
import net.conczin.mca.registry.CriterionMCA;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class HeartsCriterion
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, int hearts, int increase, String source) {
        this.trigger(player, conditions -> conditions.test(hearts, increase, source));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints hearts, MinMaxBounds.Ints increase, String source) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("hearts", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::hearts), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("increase", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::increase), (App)Codec.STRING.optionalFieldOf("source", (Object)"").forGetter(TriggerInstance::source)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> hearts(MinMaxBounds.Ints hearts, MinMaxBounds.Ints increase, String source) {
            return CriterionMCA.HEARTS.createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), hearts, increase, source));
        }

        public boolean test(int hearts, int increase, String source) {
            return this.hearts.matches(hearts) && this.increase.matches(increase) && (MCA.isBlankString(this.source) || this.source.equals(source));
        }
    }
}

