/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.book.pages;

import java.util.List;
import net.conczin.mca.client.book.pages.Page;
import net.conczin.mca.client.gui.ExtendedBookScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class TextPage
extends Page {
    protected final Component content;
    private Style style = Style.EMPTY;
    private List<FormattedCharSequence> cachedPage;

    public TextPage(String name, int page) {
        this.content = Component.translatable((String)("mca.books." + name + "." + page));
    }

    public TextPage(Component content) {
        this.content = content;
    }

    protected List<FormattedCharSequence> getCachedPage(ExtendedBookScreen screen) {
        if (this.cachedPage == null) {
            this.cachedPage = screen.getTextRenderer().split((FormattedText)this.content.copy().withStyle(this.style), 114);
        }
        return this.cachedPage;
    }

    @Override
    public void render(ExtendedBookScreen screen, GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.content != null) {
            int l = Math.min(14, this.getCachedPage(screen).size());
            int i = (screen.width - 192) / 2;
            for (int m = 0; m < l; ++m) {
                FormattedCharSequence orderedText = this.getCachedPage(screen).get(m);
                int x = i + 36;
                context.drawString(screen.getTextRenderer(), orderedText, x, 32 + m * 9, 0, screen.getBook().hasTextShadow());
            }
        }
    }

    public TextPage setStyle(Style style) {
        this.style = style;
        return this;
    }
}

