/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.client.gui.ColorSelector;
import net.conczin.mca.client.gui.CombScreen;
import net.conczin.mca.client.gui.DestinyScreen;
import net.conczin.mca.client.gui.NeedleScreen;
import net.conczin.mca.client.gui.SkinListUpdateListener;
import net.conczin.mca.client.gui.VillagerEditorScreen;
import net.conczin.mca.client.gui.immersive_library.Api;
import net.conczin.mca.client.gui.immersive_library.Auth;
import net.conczin.mca.client.gui.immersive_library.SkinCache;
import net.conczin.mca.client.gui.immersive_library.Utils;
import net.conczin.mca.client.gui.immersive_library.Workspace;
import net.conczin.mca.client.gui.immersive_library.responses.ContentIdResponse;
import net.conczin.mca.client.gui.immersive_library.responses.ContentListResponse;
import net.conczin.mca.client.gui.immersive_library.responses.ErrorResponse;
import net.conczin.mca.client.gui.immersive_library.responses.IsAuthResponse;
import net.conczin.mca.client.gui.immersive_library.responses.Response;
import net.conczin.mca.client.gui.immersive_library.responses.SuccessResponse;
import net.conczin.mca.client.gui.immersive_library.responses.UserResponse;
import net.conczin.mca.client.gui.immersive_library.types.LiteContent;
import net.conczin.mca.client.gui.immersive_library.types.User;
import net.conczin.mca.client.gui.widget.ColorPickerWidget;
import net.conczin.mca.client.gui.widget.HorizontalColorPickerWidget;
import net.conczin.mca.client.gui.widget.HorizontalGradientWidget;
import net.conczin.mca.client.gui.widget.IntegerSliderWidget;
import net.conczin.mca.client.gui.widget.ItemButtonWidget;
import net.conczin.mca.client.gui.widget.ToggleableTooltipButtonWidget;
import net.conczin.mca.client.gui.widget.ToggleableTooltipIconButtonWidget;
import net.conczin.mca.client.gui.widget.TooltipButtonWidget;
import net.conczin.mca.client.gui.widget.WidgetUtils;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.client.resources.ClientUtils;
import net.conczin.mca.client.resources.ProfessionIcons;
import net.conczin.mca.client.resources.SkinLocations;
import net.conczin.mca.client.resources.SkinMeta;
import net.conczin.mca.client.resources.SkinPorter;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.AddCustomClothingMessage;
import net.conczin.mca.network.c2s.RemoveCustomClothingMessage;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.resources.data.skin.Clothing;
import net.conczin.mca.resources.data.skin.Hair;
import net.conczin.mca.resources.data.skin.SkinListEntry;
import net.conczin.mca.util.compat.ButtonWidget;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class SkinLibraryScreen
extends Screen
implements SkinListUpdateListener {
    static final int CLOTHES_H = 7;
    static final int CLOTHES_V = 2;
    static final int CLOTHES_PER_PAGE = 15;
    private static final ResourceLocation TEMPLATE_IDENTIFIER = MCA.locate("textures/skin_template.png");
    private static final ResourceLocation EMPTY_IDENTIFIER = MCA.locate("skins/empty.png");
    private static final ResourceLocation CANVAS_IDENTIFIER = MCA.locate("temp");
    private static final float CANVAS_SCALE = 2.35f;
    protected final VillagerEntityMCA villagerVisualization;
    private final List<LiteContent> serverContent;
    private final ColorSelector color;
    private final VillagerEditorScreen previousScreen;
    private final List<LiteContent> contents;
    private String filteredString;
    private SortingMode sortingMode;
    private boolean filterInvalidSkins;
    private boolean moderatorMode;
    private boolean filterHair;
    private boolean filterClothing;
    private SubscriptionFilter subscriptionFilter;
    private User currentUser;
    private int selectionPage;
    private LiteContent focusedContent;
    private LiteContent hoveredContent;
    private LiteContent deleteConfirmationContent;
    private LiteContent reportConfirmationContent;
    private Page page;
    private String lastFilteredString;
    private int lastLoadedPage;
    private ButtonWidget pageWidget;
    private Workspace workspace;
    private int activeMouseButton;
    private int lastPixelMouseX;
    private int lastPixelMouseY;
    private float x0;
    private float x1;
    private float y0;
    private float y1;
    private boolean isPanning;
    private boolean hasPanned;
    private double lastMouseX;
    private double lastMouseY;
    private int timeSinceLastRebuild;
    private Component error;
    private boolean authenticated;
    private boolean awaitingAuthentication;
    private boolean isBrowserOpen;
    private boolean uploading;
    private Thread thread;
    private EditBox textFieldWidget;
    private boolean skipHairWarning;
    private List<LiteContent> libraryContents;

    public SkinLibraryScreen() {
        this(null, null);
    }

    public SkinLibraryScreen(VillagerEditorScreen screen, VillagerEntityMCA villagerVisualization) {
        super((Component)Component.translatable((String)"gui.skin_library.title"));
        this.villagerVisualization = Objects.requireNonNull((VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.create((Level)Objects.requireNonNull(Minecraft.getInstance().level)));
        this.serverContent = new ArrayList<LiteContent>();
        this.color = new ColorSelector();
        this.contents = new LinkedList<LiteContent>();
        this.filteredString = "";
        this.sortingMode = SortingMode.RECOMMENDATIONS;
        this.filterInvalidSkins = true;
        this.moderatorMode = false;
        this.filterHair = false;
        this.filterClothing = false;
        this.subscriptionFilter = SubscriptionFilter.LIBRARY;
        this.lastFilteredString = "";
        this.lastLoadedPage = -1;
        this.authenticated = false;
        this.awaitingAuthentication = false;
        this.isBrowserOpen = false;
        this.uploading = false;
        this.libraryContents = new LinkedList<LiteContent>();
        this.previousScreen = screen;
        if (this.previousScreen instanceof NeedleScreen) {
            this.filterHair = true;
        }
        if (this.previousScreen instanceof CombScreen) {
            this.filterClothing = true;
        }
        if (villagerVisualization != null) {
            CompoundTag nbt = new CompoundTag();
            villagerVisualization.addAdditionalSaveData(nbt);
            this.villagerVisualization.readAdditionalSaveData(nbt);
        } else {
            assert (Minecraft.getInstance().player != null);
            VillagerLike<?> villagerLike = CommonVillagerModel.getVillager((Level)Minecraft.getInstance().level, Minecraft.getInstance().player.getUUID());
            if (villagerLike instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)villagerLike;
                CompoundTag nbt = new CompoundTag();
                villager.addAdditionalSaveData(nbt);
                this.villagerVisualization.readAdditionalSaveData(nbt);
            }
        }
    }

    public void onClose() {
        if (this.previousScreen == null) {
            super.onClose();
        } else {
            Minecraft.getInstance().setScreen((Screen)this.previousScreen);
        }
    }

    protected void init() {
        super.init();
        this.refreshServerContent();
        this.thread = Thread.currentThread();
        if (this.page == null) {
            if (Auth.loadToken() == null) {
                this.setPage(Page.LOADING);
            } else {
                this.setPage(Page.LOGIN);
            }
            this.reloadDatabase();
        } else {
            this.refreshPage();
        }
    }

    private void reloadDatabase() {
        this.reloadDatabase(() -> {
            if (this.page == Page.LOADING) {
                this.setPage(Page.LIBRARY);
            }
        });
    }

    private void reloadDatabase(Runnable callback) {
        CompletableFuture.runAsync(() -> {
            if (!Auth.hasToken()) return;
            if (!this.authenticated) return;
            Response response = Api.request(Api.HttpMethod.GET, UserResponse.class, "user/mca/me");
            if (!(response instanceof UserResponse)) {
                this.setError((Component)Component.translatable((String)"gui.skin_library.list_fetch_failed"));
                return;
            }
            UserResponse $b$0 = (UserResponse)response;
            try {
                User patt1$temp;
                User user;
                this.currentUser = user = (patt1$temp = $b$0.user());
                this.refreshContentList();
                return;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }).thenRunAsync(callback);
    }

    private void loadPage() {
        this.loadPage(false);
    }

    private void loadPage(boolean force) {
        if (this.lastLoadedPage == this.selectionPage && this.lastFilteredString.equals(this.filteredString) && !force) {
            return;
        }
        this.lastFilteredString = this.filteredString;
        this.lastLoadedPage = this.selectionPage;
        CompletableFuture.runAsync(() -> {
            Response response = Api.request(Api.HttpMethod.GET, ContentListResponse.class, "v2/content/mca", Map.of("whitelist", this.filteredString, "blacklist", (this.filterInvalidSkins ? "invalid" : "") + (this.filterHair ? ",hair" : "") + (this.filterClothing ? ",clothing" : ""), "order", this.sortingMode.order, "descending", "true", "offset", String.valueOf(this.selectionPage * 15), "limit", String.valueOf(15), "moderator", String.valueOf(this.moderatorMode)));
            if (!(response instanceof ContentListResponse)) {
                this.setError((Component)Component.translatable((String)"gui.skin_library.list_fetch_failed"));
                return;
            }
            ContentListResponse $b$0 = (ContentListResponse)response;
            try {
                LiteContent[] patt1$temp;
                LiteContent[] contents1 = patt1$temp = $b$0.contents();
                this.libraryContents = new ArrayList<LiteContent>(Arrays.asList(contents1));
                this.refreshContentList();
                return;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        PoseStack matrices = context.pose();
        this.hoveredContent = null;
        this.villagerVisualization.setAge(0);
        this.villagerVisualization.refreshDimensions();
        List<Component> tooltip = null;
        switch (this.page.ordinal()) {
            case 0: {
                int i = 0;
                for (int y = 0; y < 2; ++y) {
                    for (int x = 0; x < 7 + y && this.contents.size() > i; ++i, ++x) {
                        LiteContent c = this.contents.get(i);
                        this.setDummyTexture(c);
                        int cx = this.width / 2 + (int)(((double)x - 3.5 + 0.5 - 0.5 * (double)(y % 2)) * 55.0);
                        int cy = this.height / 2 + (int)(((double)y - 1.0 + 0.5) * 80.0);
                        if (Math.abs(cx - mouseX) <= 15 && Math.abs(cy - mouseY - 10) <= 25) {
                            this.hoveredContent = c;
                            tooltip = this.getMetaDataText(c);
                        }
                        this.villagerVisualization.getGenetics().setGender(SkinCache.getMeta(c).map(SkinMeta::getGender).orElse(Gender.MALE).binary());
                        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)(cx - 25), (int)(cy - 50), (int)(cx + 25), (int)(cy + 30), (int)(this.hoveredContent == c ? 30 : 28), (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.villagerVisualization);
                    }
                }
                if (this.authenticated || this.subscriptionFilter != SubscriptionFilter.LIKED && this.subscriptionFilter != SubscriptionFilter.SUBMISSIONS) break;
                this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.like_locked"));
                break;
            }
            case 1: {
                this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.locked"));
                break;
            }
            case 2: {
                this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.drop"));
                break;
            }
            case 3: {
                this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.prepare"));
                break;
            }
            case 9: {
                this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.delete_confirm"));
                break;
            }
            case 11: {
                this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.report_confirm"));
                break;
            }
            case 4: {
                SkinLocations.Part part;
                if (this.workspace.isDirty()) {
                    this.workspace.backendTexture.upload();
                    Minecraft.getInstance().getTextureManager().register(CANVAS_IDENTIFIER, (AbstractTexture)this.workspace.backendTexture);
                    this.workspace.setDirty(false);
                }
                int tw = 64;
                int th = 64;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                matrices.pushPose();
                matrices.translate((float)this.width / 2.0f - (float)tw * 2.35f / 2.0f, (float)this.height / 2.0f - (float)th * 2.35f / 2.0f, 0.0f);
                matrices.scale(2.35f, 2.35f, 1.0f);
                float vx0 = Mth.clamp((float)0.0f, (float)this.x0, (float)this.x1);
                float vx1 = Mth.clamp((float)1.0f, (float)this.x0, (float)this.x1);
                float vy0 = Mth.clamp((float)0.0f, (float)this.y0, (float)this.y1);
                float vy1 = Mth.clamp((float)1.0f, (float)this.y0, (float)this.y1);
                float uvx0 = (vx0 - this.x0) / (this.x1 - this.x0);
                float uvx1 = (vx1 - this.x0) / (this.x1 - this.x0);
                float uvy0 = (vy0 - this.y0) / (this.y1 - this.y0);
                float uvy1 = (vy1 - this.y0) / (this.y1 - this.y0);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEMPLATE_IDENTIFIER);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                WidgetUtils.drawTexturedQuad(matrices.last().pose(), vx0 * 64.0f, vx1 * 64.0f, vy0 * 64.0f, vy1 * 64.0f, 0.0f, uvx0, uvx1, uvy0, uvy1);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)CANVAS_IDENTIFIER);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                WidgetUtils.drawTexturedQuad(matrices.last().pose(), vx0 * 64.0f, vx1 * 64.0f, vy0 * 64.0f, vy1 * 64.0f, 0.0f, uvx0, uvx1, uvy0, uvy1);
                WidgetUtils.drawRectangle(context, -1, -1, tw + 1, th + 1, -1426063361);
                matrices.popPose();
                if (this.workspace.skinType == SkinType.CLOTHING) {
                    this.villagerVisualization.setHair(EMPTY_IDENTIFIER);
                    this.villagerVisualization.setClothes(CANVAS_IDENTIFIER);
                } else {
                    this.villagerVisualization.setHair(CANVAS_IDENTIFIER);
                    this.villagerVisualization.setClothes(EMPTY_IDENTIFIER);
                }
                int cx = this.width / 2 + 150;
                int cy = this.height / 2 - 10;
                this.villagerVisualization.getGenetics().setGender(this.workspace.gender.binary());
                WidgetUtils.drawBackgroundEntity(cx, cy, 50, (float)(-(mouseX - cx)) / 2.0f, (float)(-(mouseY - cy + 32)) / 2.0f, (LivingEntity)this.villagerVisualization);
                if (this.workspace.skinType == SkinType.HAIR) {
                    context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.skin_library.hair_color"), this.width / 2 - 150, this.height / 2 - 40, -1426063361);
                }
                int x = (int)this.getPixelX();
                int y = (int)this.getPixelY();
                if (x < 0 || x >= 64 || y < 0 || y >= 64 || (part = SkinLocations.LOOKUP[x][y]) == null) break;
                Component text = part.getTranslation();
                int textWidth = this.font.width((FormattedText)text);
                context.renderTooltip(this.font, text, this.width / 2 - textWidth / 2 - 12, this.height / 2 - 68);
                break;
            }
            case 6: {
                if (!this.awaitingAuthentication) {
                    this.awaitingAuthentication = true;
                    CompletableFuture.runAsync(() -> {
                        try {
                            block8: {
                                block7: {
                                    block5: {
                                        Response response22;
                                        Response response = response22 = Auth.hasToken() ? Api.request(Api.HttpMethod.GET, IsAuthResponse.class, "auth") : null;
                                        if (!(response22 instanceof IsAuthResponse)) break block7;
                                        IsAuthResponse $b$0 = (IsAuthResponse)response22;
                                        try {
                                            boolean patt1$temp;
                                            boolean success = patt1$temp = $b$0.authenticated();
                                            if (!success) break block5;
                                            this.authenticated = true;
                                            this.clearError();
                                            this.reloadDatabase();
                                        }
                                        catch (Throwable response22) {
                                            throw new MatchException(response22.toString(), response22);
                                        }
                                        Auth.saveToken();
                                        this.setPage(Page.LIBRARY);
                                        break block8;
                                    }
                                    Auth.clearToken();
                                    if (!this.isBrowserOpen) {
                                        this.setPage(Page.LIBRARY);
                                        this.setError((Component)Component.translatable((String)"gui.skin_library.is_auth_failed"));
                                    }
                                    break block8;
                                }
                                this.setError((Component)Component.translatable((String)"gui.skin_library.is_auth_failed"));
                            }
                            Thread.sleep(2000L);
                        }
                        catch (Exception e) {
                            MCA.LOGGER.error((Object)e);
                        }
                        this.awaitingAuthentication = false;
                    });
                }
                if (this.isBrowserOpen) {
                    this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.authenticating_browser"));
                    break;
                }
                if (this.error != null) {
                    this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.authenticating"));
                    break;
                }
                this.drawTextBox(context, (Component)Component.translatable((String)"gui.skin_library.authenticating").append((Component)Component.literal((String)(" " + ".".repeat((int)(System.currentTimeMillis() / 500L % 4L))))));
                break;
            }
            case 8: {
                this.setDummyTexture(this.focusedContent);
                int cx = this.width / 2;
                int cy = this.height / 2;
                this.villagerVisualization.getGenetics().setGender(SkinCache.getMeta(this.focusedContent).map(SkinMeta::getGender).orElse(Gender.MALE).binary());
                InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)(cx - 30), (int)(cy - 60), (int)(cx + 30), (int)(cy + 60), (int)60, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.villagerVisualization);
                context.renderComponentTooltip(this.font, this.getMetaDataText(this.focusedContent), this.width / 2 + 200, this.height / 2 - 50);
                break;
            }
            case 10: {
                context.drawString(this.font, (Component)Component.translatable((String)"gui.loading"), this.width / 2, this.height / 2, -1);
            }
        }
        if (tooltip != null) {
            context.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
        if (this.error != null) {
            context.drawCenteredString(this.font, this.error, this.width / 2, this.height / 2, -65536);
        }
    }

    private void setDummyTexture(LiteContent content) {
        if (content.hasTag("clothing")) {
            this.villagerVisualization.setHair(EMPTY_IDENTIFIER);
            this.villagerVisualization.setClothes(SkinCache.getTextureIdentifier(content));
        } else {
            this.villagerVisualization.setHair(SkinCache.getTextureIdentifier(content));
            this.villagerVisualization.setClothes(EMPTY_IDENTIFIER);
        }
    }

    private List<Component> getMetaDataText(LiteContent content) {
        Optional<SkinMeta> meta = SkinCache.getMeta(content);
        if (meta.isEmpty()) {
            return List.of(Component.literal((String)content.title()));
        }
        List<Component> wrap = FlowingText.wrap((Component)Component.literal((String)String.join((CharSequence)", ", content.tags())).withStyle(ChatFormatting.YELLOW), 160);
        ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>(List.of(Component.literal((String)content.title()), Component.translatable((String)"gui.skin_library.meta.by", (Object[])new Object[]{content.username()}).withStyle(ChatFormatting.ITALIC), Component.translatable((String)"gui.skin_library.meta.likes", (Object[])new Object[]{content.likes()}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"gui.skin_library.gender", (Object[])new Object[]{meta.get().getGender() == Gender.MALE ? Component.translatable((String)"gui.villager_editor.masculine") : (meta.get().getGender() == Gender.FEMALE ? Component.translatable((String)"gui.villager_editor.feminine") : Component.translatable((String)"gui.villager_editor.neutral"))}), Component.translatable((String)"gui.skin_library.profession", (Object[])new Object[]{meta.get().getProfession() == null ? Component.translatable((String)"entity.minecraft.villager") : Component.translatable((String)("entity.minecraft.villager." + meta.get().getProfession()))}), Component.translatable((String)"gui.skin_library.temperature", (Object[])new Object[]{Component.translatable((String)("gui.skin_library.temperature." + (meta.get().getTemperature() + 2)))}), Component.translatable((String)"gui.skin_library.chance_val", (Object[])new Object[]{(int)(meta.get().getChance() * 100.0f)}).withStyle(ChatFormatting.GRAY)));
        texts.addAll(wrap);
        if (content.tags().contains("invalid")) {
            texts.add(Component.translatable((String)"gui.skin_library.probably_not_valids").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED));
        }
        return texts;
    }

    private double getScreenScaleX() {
        assert (this.minecraft != null);
        return (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
    }

    private double getScreenScaleY() {
        assert (this.minecraft != null);
        return (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
    }

    private double getCanvasX() {
        assert (this.minecraft != null);
        double x = this.minecraft.mouseHandler.xpos() * this.getScreenScaleX();
        return (x - (double)this.width / 2.0 + (double)75.2f) / (double)2.35f / 64.0;
    }

    private double getCanvasY() {
        assert (this.minecraft != null);
        double y = this.minecraft.mouseHandler.ypos() * this.getScreenScaleY();
        return (y - (double)this.height / 2.0 + (double)75.2f) / (double)2.35f / 64.0;
    }

    private float getPixelX() {
        double cx = this.getCanvasX();
        return (int)((cx - (double)this.x0) / (double)(this.x1 - this.x0) * 64.0);
    }

    private float getPixelY() {
        double cy = this.getCanvasY();
        return (int)((cy - (double)this.y0) / (double)(this.y1 - this.y0) * 64.0);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.mouseDeltaMoved(this.lastMouseX - mouseX, this.lastMouseY - mouseY);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        super.mouseMoved(mouseX, mouseY);
    }

    protected void mouseDeltaMoved(double deltaX, double deltaY) {
        if (this.isPanning) {
            float ox = (float)(deltaX / 64.0 / (double)2.35f);
            this.x0 -= ox;
            this.x1 -= ox;
            float oy = (float)(deltaY / 64.0 / (double)2.35f);
            this.y0 -= oy;
            this.y1 -= oy;
            this.hasPanned = true;
        } else {
            this.hasPanned = false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!(keyCode != 32 || this.textFieldWidget != null && this.textFieldWidget.isFocused())) {
            this.isPanning = true;
            return true;
        }
        if (!(this.page != Page.EDITOR || this.textFieldWidget != null && this.textFieldWidget.isFocused())) {
            if (keyCode == 82) {
                this.x0 = 0.0f;
                this.x1 = 1.0f;
                this.y0 = 0.0f;
                this.y1 = 1.0f;
                return true;
            }
            if (keyCode == 70) {
                this.workspace.fillDelete((int)this.getPixelX(), (int)this.getPixelY());
                return true;
            }
            if (keyCode == 89 || keyCode == 90) {
                this.workspace.undo();
                return true;
            }
            if (keyCode == 80) {
                this.pickColor();
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.isPanning = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isPanning && this.activeMouseButton >= 0 && this.page == Page.EDITOR) {
            int x = (int)this.getPixelX();
            int y = (int)this.getPixelY();
            ClientUtils.bethlehemLine(this.lastPixelMouseX, this.lastPixelMouseY, x, y, this::paint);
            this.lastPixelMouseX = x;
            this.lastPixelMouseY = y;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.page == Page.EDITOR) {
            float zoom = (float)(scrollY * (double)0.2f) * (this.x1 - this.x0);
            float ox = this.getPixelX() / 64.0f;
            this.x0 -= zoom * ox;
            this.x1 += zoom * (1.0f - ox);
            float oy = this.getPixelY() / 64.0f;
            this.y0 -= zoom * oy;
            this.y1 += zoom * (1.0f - oy);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void tick() {
        super.tick();
        ++this.timeSinceLastRebuild;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.timeSinceLastRebuild < 2) {
            return false;
        }
        if (this.page == Page.EDITOR) {
            if (button == 0 || button == 1) {
                int y;
                this.activeMouseButton = button;
                int x = (int)this.getPixelX();
                if (this.workspace.validPixel(x, y = (int)this.getPixelY())) {
                    this.workspace.saveSnapshot(true);
                }
                if (!this.isPanning) {
                    this.paint(x, y);
                }
                this.lastPixelMouseX = x;
                this.lastPixelMouseY = y;
            } else if (button == 2) {
                this.isPanning = true;
            }
        } else if (this.hoveredContent != null) {
            if (this.previousScreen == null) {
                this.focusedContent = this.hoveredContent;
                this.setPage(Page.DETAIL);
            } else if (this.hoveredContent.hasTag("clothing")) {
                this.previousScreen.getVillager().setClothes("immersive_library:" + this.hoveredContent.contentid());
                this.returnToPreviousScreen();
            } else if (this.hoveredContent.hasTag("hair")) {
                this.previousScreen.getVillager().setHair("immersive_library:" + this.hoveredContent.contentid());
                this.returnToPreviousScreen();
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void returnToPreviousScreen() {
        this.previousScreen.syncVillagerData();
        if (this.previousScreen instanceof DestinyScreen) {
            this.onClose();
        } else {
            this.previousScreen.onClose();
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.activeMouseButton = -1;
        if (button == 2) {
            this.isPanning = false;
            if (!this.hasPanned && this.page == Page.EDITOR) {
                this.pickColor();
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void drawTextBox(GuiGraphics context, Component text) {
        List<Component> wrap = FlowingText.wrap(text, 220);
        int y = this.height / 2 - 20 - wrap.size() * 12;
        context.fill(this.width / 2 - 115, y - 5, this.width / 2 + 115, y + 12 * wrap.size(), 0x50000000);
        for (Component t : wrap) {
            context.drawCenteredString(this.font, t, this.width / 2, y, -1);
            y += 12;
        }
    }

    private void paint(int x, int y) {
        if (this.page == Page.EDITOR && this.workspace.validPixel(x, y)) {
            if (this.activeMouseButton == 0) {
                this.workspace.currentImage.setPixelRGBA(x, y, this.color.getColor());
                this.workspace.setDirty(true);
            } else if (this.activeMouseButton == 1) {
                this.workspace.currentImage.setPixelRGBA(x, y, 0);
                this.workspace.setDirty(true);
            }
        }
    }

    private void pickColor() {
        int y;
        int x = (int)this.getPixelX();
        if (this.workspace.validPixel(x, y = (int)this.getPixelY())) {
            this.color.setRGB((double)(this.workspace.currentImage.getRedOrLuminance(x, y) & 0xFF) / 255.0, (double)(this.workspace.currentImage.getGreenOrLuminance(x, y) & 0xFF) / 255.0, (double)(this.workspace.currentImage.getBlueOrLuminance(x, y) & 0xFF) / 255.0);
            if (this.workspace.skinType == SkinType.HAIR) {
                this.color.setHSV(0.0, 0.0, this.color.brightness);
            }
        }
    }

    private void rebuild() {
        this.clearWidgets();
        this.timeSinceLastRebuild = 0;
        if (this.page == Page.LIBRARY || this.page == Page.EDITOR_LOCKED || this.page == Page.EDITOR_PREPARE || this.page == Page.EDITOR_TYPE) {
            LinkedList<Page> b = new LinkedList<Page>();
            b.add(Page.LIBRARY);
            b.add(Page.EDITOR_PREPARE);
            b.add(Page.HELP);
            if (this.authenticated) {
                b.add(Page.LOGOUT);
            } else {
                b.add(Page.LOGIN);
            }
            int x = this.page == Page.LIBRARY ? this.width / 2 - 20 : this.width / 2 - 110;
            int w = 220 / b.size();
            for (Page page : b) {
                ((ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget((int)x, (int)(this.height / 2 - 110), (int)w, (int)20, (Component)Component.translatable((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"gui.skin_library.page.\u0001"}, (String)page.name().toLowerCase((Locale)Locale.ROOT)))), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$rebuild$4(net.conczin.mca.client.gui.SkinLibraryScreen$Page net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((SkinLibraryScreen)this, (Page)page)))).active = page != this.page;
                x += w;
            }
        }
        switch (this.page.ordinal()) {
            case 0: {
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 30 - 30, this.height / 2 + 80, 30, 20, (Component)Component.literal((String)"<<"), sender -> {
                    this.setSelectionPage(this.selectionPage - 1);
                    this.refreshContentList();
                }));
                this.pageWidget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 30, this.height / 2 + 80, 60, 20, (Component)Component.literal((String)""), sender -> {}));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 30, this.height / 2 + 80, 30, 20, (Component)Component.literal((String)">>"), sender -> {
                    this.setSelectionPage(this.selectionPage + 1);
                    this.refreshContentList();
                }));
                this.setSelectionPage(this.selectionPage);
                int iconX = this.width / 2 - 170;
                this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(iconX, this.height / 2 + 82, 96, 48, this.sortingMode == SortingMode.LIKES, Component.translatable((String)"gui.skin_library.sort_likes"), v -> {
                    this.sortingMode = SortingMode.LIKES;
                    this.loadPage(true);
                }));
                this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(iconX + 22, this.height / 2 + 82, 112, 48, this.sortingMode == SortingMode.NEWEST, Component.translatable((String)"gui.skin_library.sort_newest"), v -> {
                    this.sortingMode = SortingMode.NEWEST;
                    this.loadPage(true);
                }));
                this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(iconX + 44, this.height / 2 + 82, 224, 48, this.sortingMode == SortingMode.RECOMMENDATIONS, Component.translatable((String)"gui.skin_library.sort_recommendations"), v -> {
                    this.sortingMode = SortingMode.RECOMMENDATIONS;
                    this.loadPage(true);
                }));
                iconX = this.width / 2 + 50;
                if (this.subscriptionFilter == SubscriptionFilter.LIBRARY) {
                    this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(iconX + 44, this.height / 2 + 82, 144, 48, this.filterInvalidSkins, Component.translatable((String)"gui.skin_library.filter_invalid"), v -> {
                        this.filterInvalidSkins = !this.filterInvalidSkins;
                        this.loadPage(true);
                    }));
                    this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(iconX + 66, this.height / 2 + 82, 192, 48, this.filterClothing, Component.translatable((String)"gui.skin_library.filter_clothing"), v -> {
                        this.filterClothing = !this.filterClothing;
                        this.loadPage(true);
                    }));
                    this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(iconX + 88, this.height / 2 + 82, 208, 48, this.filterHair, Component.translatable((String)"gui.skin_library.filter_hair"), v -> {
                        this.filterHair = !this.filterHair;
                        this.loadPage(true);
                    }));
                    if (this.isModerator()) {
                        this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(iconX + 110, this.height / 2 + 82, 176, 48, this.moderatorMode, Component.translatable((String)"gui.skin_library.filter_moderator"), v -> {
                            this.moderatorMode = !this.moderatorMode;
                            this.loadPage(true);
                        }));
                    }
                }
                if (this.subscriptionFilter == SubscriptionFilter.LIBRARY) {
                    EditBox textFieldWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 200 + 65, this.height / 2 - 110 + 2, 110, 16, (Component)Component.translatable((String)"gui.skin_library.search")));
                    textFieldWidget.setMaxLength(64);
                    textFieldWidget.setValue(this.filteredString);
                    if (this.filteredString.isEmpty()) {
                        textFieldWidget.setSuggestion("Search");
                    }
                    textFieldWidget.setResponder(s -> {
                        this.filteredString = s;
                        this.refreshContentList();
                        textFieldWidget.setSuggestion(null);
                    });
                }
                this.addRenderableWidget((GuiEventListener)CycleButton.builder(SubscriptionFilter::getText).withValues((Object[])SubscriptionFilter.values()).withInitialValue((Object)this.subscriptionFilter).displayOnlyValue().create(this.width / 2 - 200, this.height / 2 - 110, 60, 20, (Component)Component.literal((String)""), (button, filter) -> {
                    this.subscriptionFilter = filter;
                    this.refreshContentList();
                }));
                int i = 0;
                for (int y = 0; y < 2; ++y) {
                    for (int x = 0; x < 7 + y && this.contents.size() > i; ++i, ++x) {
                        LiteContent c = this.contents.get(i);
                        int cx = this.width / 2 + (int)(((double)x - 3.5 + 0.5 - 0.5 * (double)(y % 2)) * 55.0);
                        int cy = this.height / 2 + 15 + (int)(((double)y - 1.0 + 0.5) * 80.0);
                        this.drawControls(c, false, cx, cy);
                        if (this.isModerator()) {
                            this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(cx + 16, cy - 48, 160, 48, false, Component.literal((String)"Toggle invalid"), v -> this.setTag(c.contentid(), "invalid", !c.hasTag("invalid"))));
                        }
                        if (!c.tags().contains("invalid")) continue;
                        this.addRenderableWidget((GuiEventListener)new ToggleableTooltipIconButtonWidget(cx + 12, cy - 16, 144, 48, true, Component.translatable((String)"gui.skin_library.probably_not_valids"), v -> {}));
                    }
                }
                break;
            }
            case 2: {
                EditBox textFieldWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 90, this.height / 2 - 18, 180, 16, (Component)Component.literal((String)"URL")));
                textFieldWidget.setMaxLength(1024);
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 50, this.height / 2 + 5, 100, 20, (Component)Component.translatable((String)"gui.skin_library.load_image"), sender -> this.loadImage(textFieldWidget.getValue())));
                break;
            }
            case 3: {
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 100, this.height / 2, 95, 20, (Component)Component.translatable((String)"gui.skin_library.prepare.hair"), v -> {
                    this.workspace.skinType = SkinType.HAIR;
                    this.color.setHSV(0.0, 0.0, 0.5);
                    this.setPage(Page.EDITOR);
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 5, this.height / 2, 95, 20, (Component)Component.translatable((String)"gui.skin_library.prepare.clothing"), v -> {
                    this.workspace.skinType = SkinType.CLOTHING;
                    this.setPage(Page.EDITOR);
                }));
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 - 10, this.height / 2 + 30, 20, 20, Component.literal((String)"?"), Component.translatable((String)"gui.skin_library.help"), v -> this.openHelp()));
                break;
            }
            case 6: {
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 50, this.height / 2 + 25, 100, 20, (Component)Component.translatable((String)"gui.skin_library.cancel"), v -> this.setPage(Page.LIBRARY)));
                break;
            }
            case 8: {
                if (this.canModifyFocusedContent()) {
                    EditBox tagNameWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 200, this.height / 2 - 100 + 2, 95, 16, (Component)Component.literal((String)"")));
                    tagNameWidget.setMaxLength(20);
                    tagNameWidget.setSuggestion("New Tag Name");
                    tagNameWidget.setResponder(v -> tagNameWidget.setSuggestion(null));
                    this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 - 100, this.height / 2 - 100, 40, 20, "gui.skin_library.add", sender -> {
                        String tag = tagNameWidget.getValue().trim().toLowerCase(Locale.ROOT);
                        if (!tag.isEmpty()) {
                            this.setTag(this.focusedContent.contentid(), tag, true);
                            tagNameWidget.setValue("");
                            this.rebuild();
                        }
                    }));
                }
                this.drawControls(this.focusedContent, true, this.width / 2 + 130, this.height / 2 + 60);
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 40, this.height / 2 + 60, 80, 20, (Component)Component.translatable((String)"gui.skin_library.close"), v -> this.setPage(Page.LIBRARY)));
                int ty = this.height / 2 - 70;
                for (String tag : this.focusedContent.tags()) {
                    if ((tag.equals("clothing") || tag.equals("hair") || tag.equals("invalid")) && !this.isModerator()) continue;
                    int w = this.font.width(tag) + 10;
                    if (this.canModifyFocusedContent()) {
                        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 200, ty, 20, 20, (Component)Component.literal((String)"X"), v -> {
                            this.setTag(this.focusedContent.contentid(), tag, false);
                            this.rebuild();
                        }));
                    }
                    this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 200 + 20, ty, w, 20, (Component)Component.literal((String)tag), v -> {}));
                    ty += 20;
                }
                break;
            }
            case 9: {
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 65, this.height / 2, 60, 20, (Component)Component.translatable((String)"gui.skin_library.cancel"), v -> this.setPage(Page.DETAIL)));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 5, this.height / 2, 60, 20, (Component)Component.translatable((String)"gui.skin_library.delete"), v -> {
                    this.removeContent(this.deleteConfirmationContent.contentid());
                    this.setPage(Page.LIBRARY);
                }));
                break;
            }
            case 11: {
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 - 105, this.height / 2, 100, 20, Component.translatable((String)"gui.skin_library.report_invalid"), Component.translatable((String)"gui.skin_library.report_invalid_tooltip"), v -> {
                    this.reportContent(this.reportConfirmationContent.contentid(), "INVALID");
                    this.setPage(Page.DETAIL);
                }));
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 + 5, this.height / 2, 100, 20, Component.translatable((String)"gui.skin_library.report_default"), Component.translatable((String)"gui.skin_library.report_default_tooltip"), v -> {
                    this.reportContent(this.reportConfirmationContent.contentid(), "DEFAULT");
                    this.setPage(Page.DETAIL);
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 50, this.height / 2 + 22, 100, 20, (Component)Component.translatable((String)"gui.skin_library.cancel"), v -> this.setPage(Page.DETAIL)));
                break;
            }
            case 4: {
                this.textFieldWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 60, this.height / 2 - 105, 120, 20, (Component)Component.translatable((String)"gui.skin_library.name")));
                this.textFieldWidget.setMaxLength(1024);
                this.textFieldWidget.setValue(this.workspace.title);
                if (this.workspace.title.isEmpty()) {
                    this.textFieldWidget.setSuggestion(this.workspace.title);
                }
                this.textFieldWidget.setFocused(false);
                this.textFieldWidget.setResponder(v -> {
                    this.workspace.title = v;
                    this.textFieldWidget.setSuggestion(null);
                });
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 + 65, this.height / 2 - 105, 20, 20, Component.literal((String)"?"), Component.translatable((String)"gui.skin_library.tool_help"), v -> this.openHelp()));
                this.addRenderableWidget((GuiEventListener)CycleButton.builder(Gender::getText).withValues((Object[])new Gender[]{Gender.MALE, Gender.NEUTRAL, Gender.FEMALE}).withInitialValue((Object)this.workspace.gender).displayOnlyValue().create(this.width / 2 - 200, this.height / 2 - 80, 105, 20, (Component)Component.literal((String)""), (button, gender) -> {
                    this.workspace.gender = gender;
                }));
                if (this.workspace.skinType == SkinType.CLOTHING) {
                    this.addRenderableWidget((GuiEventListener)new IntegerSliderWidget(this.width / 2 - 200, this.height / 2 - 60, 105, 20, this.workspace.temperature, -2, 2, v -> {
                        this.workspace.temperature = v;
                    }, v -> Component.translatable((String)("gui.skin_library.temperature." + (v + 2))), () -> Component.translatable((String)"gui.skin_library.temperature.tooltip")));
                }
                if (this.workspace.skinType == SkinType.CLOTHING) {
                    int ox = 0;
                    int oy = 0;
                    LinkedList<ItemButtonWidget> widgets = new LinkedList<ItemButtonWidget>();
                    for (VillagerProfession profession : BuiltInRegistries.VILLAGER_PROFESSION) {
                        MutableComponent text = Component.translatable((String)("entity.minecraft.villager." + profession.name()));
                        ItemButtonWidget widget = (ItemButtonWidget)this.addRenderableWidget((GuiEventListener)new ItemButtonWidget(this.width / 2 - 200 + ox * 21, this.height / 2 - 30 + oy * 21, 20, text, ProfessionIcons.ICONS.getOrDefault(profession.name(), Items.OAK_SAPLING.getDefaultInstance()), v -> {
                            this.workspace.profession = profession == VillagerProfession.NONE ? null : profession.name();
                            widgets.forEach(b -> {
                                b.active = true;
                            });
                            v.active = false;
                        }));
                        widget.active = !Objects.equals(this.workspace.profession, profession == VillagerProfession.NONE ? null : profession.name());
                        widgets.add(widget);
                        if (++ox < 5) continue;
                        ox = 0;
                        ++oy;
                    }
                }
                int y = this.height / 2 - 5;
                if (this.workspace.skinType == SkinType.CLOTHING) {
                    this.color.hueWidget = (HorizontalColorPickerWidget)this.addRenderableWidget((GuiEventListener)new HorizontalColorPickerWidget(this.width / 2 + 100, y, 100, 15, this.color.hue / 360.0, MCA.locate("textures/colormap/hue.png"), (vx, vy) -> this.color.setHSV(vx * 360.0, this.color.saturation, this.color.brightness)));
                    this.color.saturationWidget = (HorizontalColorPickerWidget)this.addRenderableWidget((GuiEventListener)new HorizontalGradientWidget(this.width / 2 + 100, y + 20, 100, 15, this.color.saturation, () -> {
                        double[] doubles = ClientUtils.HSV2RGB(this.color.hue, 0.0, 1.0);
                        return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                    }, () -> {
                        double[] doubles = ClientUtils.HSV2RGB(this.color.hue, 1.0, 1.0);
                        return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                    }, (vx, vy) -> this.color.setHSV(this.color.hue, (double)vx, this.color.brightness)));
                }
                this.color.brightnessWidget = (HorizontalColorPickerWidget)this.addRenderableWidget((GuiEventListener)new HorizontalGradientWidget(this.width / 2 + 100, y + 40, 100, 15, this.color.brightness, () -> {
                    double[] doubles = ClientUtils.HSV2RGB(this.color.hue, this.color.saturation, 0.0);
                    return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                }, () -> {
                    double[] doubles = ClientUtils.HSV2RGB(this.color.hue, this.color.saturation, 1.0);
                    return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                }, (vx, vy) -> this.color.setHSV(this.color.hue, this.color.saturation, (double)vx)));
                this.addRenderableWidget((GuiEventListener)new IntegerSliderWidget(this.width / 2 + 100, y + 60, 100, 20, this.workspace.fillToolThreshold, 0, 128, v -> {
                    this.workspace.fillToolThreshold = v;
                }, v -> Component.translatable((String)"gui.skin_library.fillToolThreshold"), () -> Component.translatable((String)"gui.skin_library.fillToolThreshold.tooltip")));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 100, y + 85, 100, 20, (Component)Component.translatable((String)"gui.skin_library.undo"), v -> this.workspace.undo()));
                if (this.workspace.skinType == SkinType.HAIR) {
                    this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 100, y - 20, 100, 20, (Component)Component.translatable((String)"gui.skin_library.remove_saturation"), v -> this.workspace.removeSaturation()));
                    this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 + 100, y, 50, 20, Component.literal((String)"C -"), Component.translatable((String)"gui.skin_library.less_contrast"), v -> this.workspace.addContrast(-0.15f)));
                    this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 + 150, y, 50, 20, Component.literal((String)"C +"), Component.translatable((String)"gui.skin_library.more_contrast"), v -> this.workspace.addContrast(0.15f)));
                    this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 + 100, y + 20, 50, 20, Component.literal((String)"B -"), Component.translatable((String)"gui.skin_library.less_brightness"), v -> this.workspace.addBrightness(-8)));
                    this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 + 150, y + 20, 50, 20, Component.literal((String)"B +"), Component.translatable((String)"gui.skin_library.more_brightness"), v -> this.workspace.addBrightness(8)));
                    Genetics genetics = this.villagerVisualization.getGenetics();
                    this.addRenderableWidget((GuiEventListener)new ColorPickerWidget(this.width / 2 - 200, this.height / 2 - 30, 100, 100, genetics.getGene(Genetics.PHEOMELANIN), genetics.getGene(Genetics.EUMELANIN), MCA.locate("textures/colormap/villager_hair.png"), (vx, vy) -> {
                        genetics.setGene(Genetics.PHEOMELANIN, vx.floatValue());
                        genetics.setGene(Genetics.EUMELANIN, vy.floatValue());
                    }));
                }
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 80, this.height / 2 + 80, 75, 20, (Component)Component.translatable((String)"gui.skin_library.cancel"), v -> this.setPage(Page.LIBRARY)));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 5, this.height / 2 + 80, 75, 20, (Component)Component.translatable((String)"gui.skin_library.publish"), v -> this.publish()));
            }
        }
    }

    private void drawControls(LiteContent content, boolean advanced, int cx, int cy) {
        int w = advanced ? 20 : 16;
        LinkedList<ToggleableTooltipIconButtonWidget> widgets = new LinkedList<ToggleableTooltipIconButtonWidget>();
        if (this.isOp() || Config.getServerConfig().allowEveryoneToAddContentGlobally) {
            widgets.add(new ToggleableTooltipIconButtonWidget(0, 0, 0, 48, this.getServerContentById(content.contentid()).isPresent(), Component.translatable((String)"gui.skin_library.subscribe"), v -> {
                if (((ToggleableTooltipButtonWidget)v).toggle) {
                    Network.sendToServer(new RemoveCustomClothingMessage(content.hasTag("clothing") ? RemoveCustomClothingMessage.Type.CLOTHING : RemoveCustomClothingMessage.Type.HAIR, ResourceLocation.fromNamespaceAndPath((String)"immersive_library", (String)String.valueOf(content.contentid()))));
                } else {
                    this.toListEntry(content).ifPresent(e -> Network.sendToServer(AddCustomClothingMessage.fromEntry(e)));
                }
                ((ToggleableTooltipButtonWidget)v).toggle = !((ToggleableTooltipButtonWidget)v).toggle;
            }));
        }
        if (this.authenticated) {
            widgets.add(new ToggleableTooltipIconButtonWidget(0, 0, 16, 48, this.isLiked(content), Component.translatable((String)"gui.skin_library.like"), v -> {
                ((ToggleableTooltipButtonWidget)v).toggle = !((ToggleableTooltipButtonWidget)v).toggle;
                this.setLike(content.contentid(), ((ToggleableTooltipButtonWidget)v).toggle);
            }));
        }
        if (advanced && this.canModifyContent(content)) {
            widgets.add(new ToggleableTooltipIconButtonWidget(0, 0, 32, 48, false, Component.translatable((String)"gui.skin_library.edit"), v -> SkinCache.getImage(content).ifPresent(image -> SkinCache.getMeta(content).ifPresent(meta -> {
                this.workspace = new Workspace((NativeImage)image, (SkinMeta)meta, content);
                this.setPage(Page.EDITOR);
                if (this.workspace.skinType == SkinType.HAIR) {
                    this.color.setHSV(0.0, 0.0, 0.5);
                }
            }))));
        }
        if (advanced && this.authenticated) {
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 160, 48, true, Component.translatable((String)"gui.skin_library.report"), v -> {
                this.reportConfirmationContent = content;
                this.setPage(Page.REPORT);
            }));
        }
        if (advanced && this.canModifyContent(content)) {
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 48, 48, true, Component.translatable((String)"gui.skin_library.delete"), v -> {
                this.deleteConfirmationContent = content;
                this.setPage(Page.DELETE);
            }));
        }
        if (!advanced) {
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 64, 64, true, Component.translatable((String)"gui.skin_library.details"), v -> {
                if (this.isPanning && this.isModerator()) {
                    this.reportContent(content.contentid(), "DEFAULT");
                    this.refreshContentList();
                } else {
                    this.focusedContent = content;
                    this.setPage(Page.DETAIL);
                }
            }));
        }
        if (advanced && this.isModerator()) {
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 80, 48, false, Component.translatable((String)"gui.skin_library.ban"), v -> {
                this.setBan(content.userid(), true);
                this.refreshContentList();
            }));
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 176, 48, false, Component.translatable((String)"gui.skin_library.unban"), v -> {
                this.setBan(content.userid(), false);
                this.refreshContentList();
            }));
        }
        int wx = cx - widgets.size() * w / 2;
        for (TooltipButtonWidget tooltipButtonWidget : widgets) {
            this.addRenderableWidget((GuiEventListener)tooltipButtonWidget);
            tooltipButtonWidget.setX(wx);
            tooltipButtonWidget.setY(cy);
            wx += w;
        }
    }

    private Optional<SkinListEntry> toListEntry(LiteContent content) {
        return SkinCache.getMeta(content).map(meta -> {
            if (content.hasTag("clothing")) {
                return new Clothing("immersive_library:" + content.contentid(), meta.getProfession(), meta.getTemperature(), false, meta.getGender());
            }
            return new Hair("immersive_library:" + content.contentid());
        });
    }

    private boolean canModifyFocusedContent() {
        return this.canModifyContent(this.focusedContent);
    }

    private boolean canModifyContent(LiteContent content) {
        return this.currentUser != null && (this.currentUser.moderator() || this.currentUser.userid() == content.userid());
    }

    private boolean isModerator() {
        return this.currentUser != null && this.currentUser.moderator();
    }

    private boolean isLiked(LiteContent content) {
        return this.currentUser != null && this.currentUser.likes().stream().anyMatch(c -> c.contentid() == content.contentid());
    }

    public void setPage(Page page) {
        if (Thread.currentThread() != this.thread) {
            assert (this.minecraft != null);
            this.minecraft.executeIfPossible(() -> this.setPage(page));
            return;
        }
        this.clearError();
        if (!(page != Page.EDITOR_TYPE && page != Page.EDITOR_PREPARE || this.authenticated)) {
            this.setPage(Page.EDITOR_LOCKED);
            return;
        }
        if (page == Page.HELP) {
            this.openHelp();
            return;
        }
        if (page == Page.LOGIN) {
            if (Auth.loadToken() == null) {
                this.isBrowserOpen = true;
                Auth.authenticate(this.getPlayerName());
            } else {
                this.isBrowserOpen = false;
            }
        }
        if (page == Page.LOGOUT) {
            this.authenticated = false;
            this.currentUser = null;
            Auth.clearToken();
            this.refreshPage();
            return;
        }
        this.page = page;
        if (page == Page.EDITOR) {
            this.x0 = 0.0f;
            this.x1 = 1.0f;
            this.y0 = 0.0f;
            this.y1 = 1.0f;
            this.uploading = false;
        }
        if (page == Page.LIBRARY) {
            this.refreshContentList();
        } else {
            this.rebuild();
        }
    }

    private void openHelp() {
        try {
            Util.getPlatform().openUri(URI.create("https://github.com/Luke100000/minecraft-comes-alive/wiki/Skin-Editor"));
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
        }
    }

    private void refreshContentList() {
        if (Thread.currentThread() != this.thread) {
            assert (this.minecraft != null);
            this.minecraft.executeIfPossible(this::refreshContentList);
            return;
        }
        this.refreshServerContent();
        List<LiteContent> newList = switch (this.subscriptionFilter.ordinal()) {
            case 0 -> {
                this.loadPage();
                yield this.libraryContents;
            }
            case 1 -> this.serverContent;
            case 2 -> this.currentUser != null ? this.currentUser.likes() : Collections.emptyList();
            case 3 -> this.currentUser != null ? this.currentUser.submissions() : Collections.emptyList();
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.subscriptionFilter));
        };
        if (this.subscriptionFilter != SubscriptionFilter.LIBRARY && !newList.isEmpty()) {
            newList = this.selectionPage * 15 >= newList.size() ? new LinkedList() : newList.subList(this.selectionPage * 15, Math.min(newList.size(), (this.selectionPage + 1) * 15));
        }
        this.contents.clear();
        this.contents.addAll(newList);
        if (this.contents.isEmpty() && this.selectionPage > 0) {
            --this.selectionPage;
            if (this.subscriptionFilter == SubscriptionFilter.LIBRARY) {
                this.loadPage();
            } else {
                this.refreshContentList();
            }
            return;
        }
        this.rebuild();
        this.setSelectionPage(this.selectionPage);
    }

    private String getPlayerName() {
        return Minecraft.getInstance().player == null ? "Unknown" : Minecraft.getInstance().player.getGameProfile().getName();
    }

    private boolean isOp() {
        return Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasPermissions(4);
    }

    private void setSelectionPage(int p) {
        if (this.pageWidget != null) {
            this.selectionPage = Math.max(0, p);
            this.pageWidget.setMessage((Component)Component.translatable((String)"gui.villager_editor.page", (Object[])new Object[]{this.selectionPage + 1}));
        }
    }

    public void onFilesDrop(List<Path> paths) {
        Path path = paths.getFirst();
        this.loadImage(path.toString());
    }

    private void loadImage(String path) {
        InputStream stream = null;
        try {
            stream = new URL(path).openStream();
        }
        catch (Exception exception) {
            try {
                stream = new FileInputStream(path);
            }
            catch (Exception e) {
                MCA.LOGGER.error((Object)e);
            }
        }
        if (stream != null) {
            try {
                NativeImage image = NativeImage.read((InputStream)stream);
                stream.close();
                if (image.getWidth() == 64 && image.getHeight() == 64) {
                    if (SkinPorter.isSlimFormat(image)) {
                        SkinPorter.convertSlimToDefault(image);
                    }
                    this.workspace = new Workspace(image);
                    this.setPage(Page.EDITOR_TYPE);
                } else if (image.getWidth() == 64 && image.getHeight() == 32) {
                    this.workspace = new Workspace(SkinPorter.portLegacySkin(image));
                    this.setPage(Page.EDITOR_TYPE);
                } else {
                    this.setError((Component)Component.translatable((String)"gui.skin_library.not_64"));
                }
            }
            catch (IOException e) {
                MCA.LOGGER.error((Object)e);
            }
        }
    }

    private void publish() {
        if (this.workspace.title.equals("Unnamed Asset")) {
            this.setError((Component)Component.translatable((String)"gui.skin_library.choose_name"));
            return;
        }
        if (!Utils.verify(this.workspace.currentImage)) {
            this.setError((Component)Component.translatable((String)"gui.skin_library.read_the_help"));
            return;
        }
        if (this.workspace.skinType == SkinType.HAIR && !Utils.verifyHair(this.workspace.currentImage) && !this.skipHairWarning) {
            this.setError((Component)Component.translatable((String)"gui.skin_library.read_the_help_hair"));
            this.skipHairWarning = true;
            return;
        }
        this.skipHairWarning = false;
        if (!this.uploading) {
            this.uploading = true;
            CompletableFuture.runAsync(() -> {
                if (Auth.hasToken()) {
                    Response request = null;
                    try {
                        request = Api.request(this.workspace.contentid == -1 ? Api.HttpMethod.POST : Api.HttpMethod.PUT, this.workspace.contentid == -1 ? ContentIdResponse.class : SuccessResponse.class, (String)(this.workspace.contentid == -1 ? "content/mca" : "content/mca/" + this.workspace.contentid), Map.of(), Map.of("title", this.workspace.title, "meta", this.workspace.toListEntry().toJson().toString(), "data", new String(Base64.getEncoder().encode(this.workspace.currentImage.asByteArray()))));
                    }
                    catch (IOException e) {
                        MCA.LOGGER.error((Object)e);
                    }
                    if (request instanceof ContentIdResponse || request instanceof SuccessResponse) {
                        Response finalRequest = request;
                        this.reloadDatabase(() -> {
                            int n;
                            if (finalRequest instanceof ContentIdResponse) {
                                ContentIdResponse $b$0 = (ContentIdResponse)finalRequest;
                                try {
                                    int patt1$temp;
                                    int contentid1;
                                    n = contentid1 = (patt1$temp = $b$0.contentid());
                                }
                                catch (Throwable throwable) {
                                    throw new MatchException(throwable.toString(), throwable);
                                }
                            } else {
                                n = this.workspace.contentid;
                            }
                            int contentid = n;
                            this.setTag(contentid, this.workspace.skinType.name().toLowerCase(Locale.ROOT), true);
                            if (this.workspace.profession != null) {
                                this.setTag(contentid, this.workspace.profession.replace("mca.", ""), true);
                            }
                            this.getSubmittedContent(contentid).or(() -> this.getContentById(contentid)).ifPresent(content -> {
                                this.focusedContent = content;
                                this.setPage(Page.DETAIL);
                                this.uploading = false;
                            });
                            SkinCache.enforceSync(contentid);
                        });
                    } else if (request instanceof ErrorResponse) {
                        ErrorResponse response = (ErrorResponse)request;
                        if (response.code() == 428) {
                            this.setError((Component)Component.translatable((String)"gui.skin_library.upload_duplicate"));
                        } else {
                            this.setError((Component)Component.translatable((String)"gui.skin_library.upload_failed"));
                        }
                        this.uploading = false;
                    }
                }
            });
        } else {
            this.setError((Component)Component.translatable((String)"gui.skin_library.already_uploading"));
        }
    }

    private Optional<LiteContent> getContentById(int contentid) {
        return Stream.concat(this.libraryContents.stream(), this.serverContent.stream()).filter(v -> v.contentid() == contentid).findAny();
    }

    private Optional<LiteContent> getServerContentById(int contentid) {
        return this.serverContent.stream().filter(v -> v.contentid() == contentid).findAny();
    }

    private Optional<LiteContent> getSubmittedContent(int contentid) {
        return this.currentUser == null ? Optional.empty() : this.currentUser.submissions().stream().filter(v -> v.contentid() == contentid).findAny();
    }

    private void setTag(int contentid, String tag, boolean add) {
        if (Auth.hasToken()) {
            Api.request(add ? Api.HttpMethod.POST : Api.HttpMethod.DELETE, SuccessResponse.class, "tag/mca/" + contentid + "/" + tag);
            this.getContentById(contentid).ifPresent(c -> {
                if (add) {
                    c.tags().add(tag);
                } else {
                    c.tags().remove(tag);
                }
            });
            this.getSubmittedContent(contentid).ifPresent(c -> {
                if (add) {
                    c.tags().add(tag);
                } else {
                    c.tags().remove(tag);
                }
            });
        }
    }

    private void removeContent(int contentId) {
        if (Auth.hasToken()) {
            Api.request(Api.HttpMethod.DELETE, SuccessResponse.class, "content/mca/" + contentId);
            this.removeContentLocally(contentId);
        }
    }

    private void removeContentLocally(int contentId) {
        this.libraryContents.removeIf(v -> v.contentid() == contentId);
        if (this.currentUser != null) {
            this.currentUser.likes().removeIf(v -> v.contentid() == contentId);
            this.currentUser.submissions().removeIf(v -> v.contentid() == contentId);
        }
    }

    private void reportContent(int contentId, String reason) {
        if (Auth.hasToken()) {
            Api.request(Api.HttpMethod.POST, SuccessResponse.class, "report/mca/" + contentId + "/" + reason);
            if (reason.equals("DEFAULT")) {
                this.removeContentLocally(contentId);
            }
            this.setError((Component)Component.translatable((String)"gui.skin_library.reported"));
        }
    }

    private void setLike(int contentid, boolean add) {
        if (Auth.hasToken() && this.currentUser != null) {
            Api.request(add ? Api.HttpMethod.POST : Api.HttpMethod.DELETE, SuccessResponse.class, "like/mca/" + contentid);
            if (add) {
                this.getContentById(contentid).ifPresent(this.currentUser.likes()::add);
            } else {
                this.currentUser.likes().removeIf(v -> v.contentid() == contentid);
            }
        }
    }

    private void setBan(int userid, boolean banned) {
        if (Auth.hasToken() && this.currentUser != null) {
            Api.request(Api.HttpMethod.PUT, SuccessResponse.class, "user/" + userid, Map.of("banned", Boolean.toString(banned)));
        }
    }

    public void refreshPage() {
        this.setPage(this.page);
    }

    public void clearError() {
        this.error = null;
    }

    public void setError(Component text) {
        this.error = text;
    }

    private <T> void addServerContent(Map<String, T> map, String type) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("immersive_library:")) continue;
            try {
                int contentid = Integer.parseInt(entry.getKey().substring(18));
                this.serverContent.add(this.getContentById(contentid).orElse(new LiteContent(contentid, -1, "unknown", -1, Set.of(type), "unknown", -1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void skinListUpdatedCallback() {
        this.refreshServerContent();
        if (this.page == Page.LIBRARY) {
            this.refreshContentList();
        }
    }

    private void refreshServerContent() {
        this.serverContent.clear();
        this.addServerContent(VillagerEditorScreen.getClothing(), "clothing");
        this.addServerContent(VillagerEditorScreen.getHair(), "hair");
    }

    private /* synthetic */ void lambda$rebuild$4(Page page, Button sender) {
        this.setPage(page);
    }

    public static enum SortingMode {
        LIKES("likes"),
        NEWEST("date"),
        RECOMMENDATIONS("recommendations"),
        REPORTS("reports");

        public final String order;

        private SortingMode(String order) {
            this.order = order;
        }
    }

    public static enum SubscriptionFilter {
        LIBRARY,
        GLOBAL,
        LIKED,
        SUBMISSIONS;


        public static Component getText(SubscriptionFilter t) {
            return Component.translatable((String)("gui.skin_library.subscription_filter." + t.name().toLowerCase(Locale.ROOT)));
        }
    }

    public static enum Page {
        LIBRARY,
        EDITOR_LOCKED,
        EDITOR_PREPARE,
        EDITOR_TYPE,
        EDITOR,
        HELP,
        LOGIN,
        LOGOUT,
        DETAIL,
        DELETE,
        LOADING,
        REPORT;

    }

    public static enum SkinType {
        CLOTHING,
        HAIR;

    }
}

