/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.MCAClient;
import net.conczin.mca.client.gui.ColorSelector;
import net.conczin.mca.client.gui.SkinLibraryScreen;
import net.conczin.mca.client.gui.SkinListUpdateListener;
import net.conczin.mca.client.gui.widget.ColorPickerWidget;
import net.conczin.mca.client.gui.widget.GeneSliderWidget;
import net.conczin.mca.client.gui.widget.HorizontalColorPickerWidget;
import net.conczin.mca.client.gui.widget.HorizontalGradientWidget;
import net.conczin.mca.client.gui.widget.NamedTextFieldWidget;
import net.conczin.mca.client.gui.widget.TooltipButtonWidget;
import net.conczin.mca.client.resources.ClientUtils;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.entity.ai.Traits;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.Personality;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.GetVillagerRequest;
import net.conczin.mca.network.c2s.SkinListRequest;
import net.conczin.mca.network.c2s.VillagerEditorSyncRequest;
import net.conczin.mca.network.c2s.VillagerNameRequest;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.registry.ProfessionsMCA;
import net.conczin.mca.resources.data.skin.Clothing;
import net.conczin.mca.resources.data.skin.Hair;
import net.conczin.mca.resources.data.skin.SkinListEntry;
import net.conczin.mca.util.compat.ButtonWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VillagerEditorScreen
extends Screen
implements SkinListUpdateListener {
    protected static final int DATA_WIDTH = 175;
    private static final int TRAITS_PER_PAGE = 8;
    private static boolean isSkinListOutdated = true;
    private static HashMap<String, Clothing> clothing = new HashMap();
    private static HashMap<String, Hair> hair = new HashMap();
    protected final VillagerEntityMCA villager;
    protected final VillagerEntityMCA villagerVisualization;
    final UUID villagerUUID;
    final UUID playerUUID;
    final boolean allowPlayerModel;
    final boolean allowVillagerModel;
    final int CLOTHES_H = 8;
    final int CLOTHES_V = 2;
    final int CLOTHES_PER_PAGE = 17;
    private final ColorSelector color;
    protected String page;
    protected CompoundTag villagerData;
    ButtonWidget widgetMasculine;
    ButtonWidget widgetFeminine;
    private int villagerBreedingAge;
    private int traitPage;
    private EditBox villagerNameField;
    private boolean hsvColoredHair;
    private int clothingPage;
    private int clothingPageCount;
    private ButtonWidget pageButtonWidget;
    private List<String> filteredClothing;
    private List<String> filteredHair;
    private Gender filterGender;
    private String searchString;
    private int hoveredClothingId;
    private ButtonWidget villagerSkinWidget;
    private ButtonWidget playerSkinWidget;
    private ButtonWidget vanillaSkinWidget;
    private ButtonWidget doneWidget;
    private ButtonWidget genderButtonFemale;
    private ButtonWidget genderButtonMale;

    public VillagerEditorScreen(UUID villagerUUID, UUID playerUUID, boolean allowPlayerModel, boolean allowVillagerModel) {
        super((Component)Component.translatable((String)"gui.VillagerEditorScreen.title"));
        this.villager = Objects.requireNonNull((VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.create((Level)Objects.requireNonNull(Minecraft.getInstance().level)));
        this.villagerVisualization = Objects.requireNonNull((VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.create((Level)Objects.requireNonNull(Minecraft.getInstance().level)));
        this.CLOTHES_H = 8;
        this.CLOTHES_V = 2;
        this.CLOTHES_PER_PAGE = 17;
        this.color = new ColorSelector();
        this.traitPage = 0;
        this.filteredClothing = new LinkedList<String>();
        this.filteredHair = new LinkedList<String>();
        this.filterGender = Gender.NEUTRAL;
        this.searchString = "";
        this.villagerUUID = villagerUUID;
        this.playerUUID = playerUUID;
        this.allowPlayerModel = allowPlayerModel;
        this.allowVillagerModel = allowVillagerModel;
        this.requestVillagerData();
        this.setPage(Objects.requireNonNullElse(this.page, "loading"));
    }

    public VillagerEditorScreen(UUID villagerUUID, UUID playerUUID) {
        this(villagerUUID, playerUUID, MCAClient.isPlayerRendererAllowed(), MCAClient.isVillagerRendererAllowed());
    }

    public static void setSkinList(HashMap<String, Clothing> clothing, HashMap<String, Hair> hair) {
        VillagerEditorScreen.clothing = clothing;
        VillagerEditorScreen.hair = hair;
    }

    public static void sync() {
        if (isSkinListOutdated) {
            Network.sendToServer(new SkinListRequest());
            isSkinListOutdated = false;
        }
    }

    public static HashMap<String, Clothing> getClothing() {
        VillagerEditorScreen.sync();
        return clothing;
    }

    public static HashMap<String, Hair> getHair() {
        VillagerEditorScreen.sync();
        return hair;
    }

    public static void setSkinListOutdated() {
        isSkinListOutdated = true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        this.setPage(this.page);
    }

    private int doubleGeneSliders(int y, Genetics.GeneType ... genes) {
        boolean right = false;
        Genetics genetics = this.villager.getGenetics();
        for (Genetics.GeneType g : genes) {
            this.addRenderableWidget((GuiEventListener)new GeneSliderWidget(this.width / 2 + (right ? 87 : 0), y, 87, 20, (Component)Component.translatable((String)g.getTranslationKey()), genetics.getGene(g), b -> genetics.setGene(g, b.floatValue())));
            if (right) {
                y += 20;
            }
            right = !right;
        }
        return y + 4 + (right ? 20 : 0);
    }

    private int integerChanger(int y, IntConsumer onClick, Supplier<Component> content) {
        int bw = 22;
        ButtonWidget current = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + bw * 2, y, 175 - bw * 4, 20, content.get(), b -> {}));
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2, y, bw, 20, (Component)Component.literal((String)"-5"), b -> {
            onClick.accept(-5);
            current.setMessage((Component)content.get());
        }));
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + bw, y, bw, 20, (Component)Component.literal((String)"-50"), b -> {
            onClick.accept(-50);
            current.setMessage((Component)content.get());
        }));
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 175 - bw * 2, y, bw, 20, (Component)Component.literal((String)"+50"), b -> {
            onClick.accept(50);
            current.setMessage((Component)content.get());
        }));
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 175 - bw, y, bw, 20, (Component)Component.literal((String)"+5"), b -> {
            onClick.accept(5);
            current.setMessage((Component)content.get());
        }));
        return y + 22;
    }

    protected void setPage(String page) {
        this.page = page;
        this.clearWidgets();
        if (page.equals("loading")) {
            return;
        }
        if (this.shouldShowPageSelection()) {
            String[] pages = this.getPages();
            int w = 350 / pages.length;
            int x = (int)((double)this.width / 2.0 - (double)pages.length / 2.0 * (double)w);
            for (String string : pages) {
                ((ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget((int)x, (int)(this.height / 2 - 105), (int)w, (int)20, (Component)Component.translatable((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"gui.villager_editor.page.\u0001"}, (String)string))), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$setPage$6(java.lang.String net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((VillagerEditorScreen)this, (String)string)))).active = !string.equals(page);
                x += w;
            }
            this.doneWidget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 175 + 20, this.height / 2 + 85, 135, 20, (Component)Component.translatable((String)"gui.done"), sender -> {
                this.syncVillagerData();
                this.onClose();
            }));
        }
        int y = this.height / 2 - 80;
        int margin = 40;
        Genetics genetics = this.villager.getGenetics();
        switch (page) {
            case "general": {
                EditBox textFieldWidget;
                this.drawName(this.width / 2, y);
                this.drawGender(this.width / 2, y += 20);
                y += 22;
                if (this.villagerUUID.equals(this.playerUUID)) {
                    this.addModelSelectionWidgets(this.width / 2, y);
                    y += 22;
                }
                if (!this.villagerUUID.equals(this.playerUUID)) {
                    this.addRenderableWidget((GuiEventListener)new GeneSliderWidget(this.width / 2, y, 175, 20, (Component)Component.translatable((String)"gui.villager_editor.age"), 1.0 + (double)this.villagerBreedingAge / (double)AgeState.getMaxAge(), b -> {
                        this.villagerBreedingAge = -((int)((1.0 - b) * (double)AgeState.getMaxAge())) + 1;
                        this.villager.setAge(this.villagerBreedingAge);
                        this.villager.refreshDimensions();
                    }));
                    y += 28;
                }
                for (String who : new String[]{"Father", "Mother", "Spouse"}) {
                    textFieldWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new NamedTextFieldWidget(this.font, this.width / 2, y, 175, 18, (Component)Component.translatable((String)("gui.villager_editor.relation." + who.toLowerCase(Locale.ROOT)))));
                    textFieldWidget.setMaxLength(64);
                    textFieldWidget.setValue(this.villagerData.getString("FamilyTree" + who + "Name"));
                    textFieldWidget.setResponder(name -> this.villagerData.putString("FamilyTreeNew" + who + "Name", name));
                    y += 20;
                }
                textFieldWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2, y += 4, 175, 18, (Component)Component.literal((String)"UUID")));
                textFieldWidget.setMaxLength(64);
                textFieldWidget.setValue(this.villagerUUID.toString());
                break;
            }
            case "body": {
                if (!Config.getServerConfig().allowPlayerSizeAdjustment && this.villagerUUID.equals(this.playerUUID)) {
                    y = this.doubleGeneSliders(y, Genetics.BREAST, Genetics.SKIN);
                    genetics.setGene(Genetics.SIZE, 0.8f);
                    genetics.setGene(Genetics.WIDTH, 0.8f);
                } else {
                    y = this.doubleGeneSliders(y, Genetics.SIZE, Genetics.WIDTH, Genetics.BREAST, Genetics.SKIN);
                }
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2, y, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.randClothing"), b -> this.sendCommand("clothing")));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 87, y, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.selectClothing"), b -> this.setPage("clothing")));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2, y += 22, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.prev"), b -> {
                    CompoundTag compound = new CompoundTag();
                    compound.putInt("offset", -1);
                    this.sendCommand("clothing", compound);
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 87, y, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.next"), b -> {
                    CompoundTag compound = new CompoundTag();
                    compound.putInt("offset", 1);
                    this.sendCommand("clothing", compound);
                }));
                this.addRenderableWidget((GuiEventListener)new ColorPickerWidget(this.width / 2 + margin, y += 22, 175 - margin * 2, 175 - margin * 2, genetics.getGene(Genetics.HEMOGLOBIN), genetics.getGene(Genetics.MELANIN), MCA.locate("textures/colormap/villager_skin.png"), (vx, vy) -> {
                    genetics.setGene(Genetics.HEMOGLOBIN, vx.floatValue());
                    genetics.setGene(Genetics.MELANIN, vy.floatValue());
                }));
                break;
            }
            case "head": {
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(this.width / 2 + 87, y, 87, 20, Component.translatable((String)(this.hsvColoredHair ? "gui.villager_editor.hair_hsv" : "gui.villager_editor.hair_genetic")), Component.translatable((String)"gui.villager_editor.hair_mode.tooltip"), b -> {
                    this.hsvColoredHair = !this.hsvColoredHair;
                    this.init();
                }));
                y = this.doubleGeneSliders(y, Genetics.FACE);
                y = this.doubleGeneSliders(y, Genetics.VOICE_TONE, Genetics.VOICE);
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2, y, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.randHair"), b -> this.sendCommand("hair")));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 87, y, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.selectHair"), b -> this.setPage("hair")));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2, y += 22, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.prev"), b -> {
                    CompoundTag compound = new CompoundTag();
                    compound.putInt("offset", -1);
                    this.sendCommand("hair", compound);
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 87, y, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.next"), b -> {
                    CompoundTag compound = new CompoundTag();
                    compound.putInt("offset", 1);
                    this.sendCommand("hair", compound);
                }));
                y += 22;
                if (this.hsvColoredHair) {
                    this.color.hueWidget = (HorizontalColorPickerWidget)this.addRenderableWidget((GuiEventListener)new HorizontalColorPickerWidget(this.width / 2 + 20, y, 135, 15, this.color.hue / 360.0, MCA.locate("textures/colormap/hue.png"), (vx, vy) -> {
                        this.color.setHSV(vx * 360.0, this.color.saturation, this.color.brightness);
                        this.refreshHairColor();
                    }));
                    this.color.saturationWidget = (HorizontalColorPickerWidget)this.addRenderableWidget((GuiEventListener)new HorizontalGradientWidget(this.width / 2 + 20, y + 20, 135, 15, this.color.saturation, () -> {
                        double[] doubles = ClientUtils.HSV2RGB(this.color.hue, 0.0, 1.0);
                        return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                    }, () -> {
                        double[] doubles = ClientUtils.HSV2RGB(this.color.hue, 1.0, 1.0);
                        return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                    }, (vx, vy) -> {
                        this.color.setHSV(this.color.hue, (double)vx, this.color.brightness);
                        this.refreshHairColor();
                    }));
                    this.color.brightnessWidget = (HorizontalColorPickerWidget)this.addRenderableWidget((GuiEventListener)new HorizontalGradientWidget(this.width / 2 + 20, y + 40, 135, 15, this.color.brightness, () -> {
                        double[] doubles = ClientUtils.HSV2RGB(this.color.hue, this.color.saturation, 0.0);
                        return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                    }, () -> {
                        double[] doubles = ClientUtils.HSV2RGB(this.color.hue, this.color.saturation, 1.0);
                        return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                    }, (vx, vy) -> {
                        this.color.setHSV(this.color.hue, this.color.saturation, (double)vx);
                        this.refreshHairColor();
                    }));
                    this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2, y += 65, 175, 20, (Component)Component.translatable((String)"gui.villager_editor.clear_hair"), b -> {
                        this.villager.clearHairDye();
                        this.init();
                    }));
                    break;
                }
                this.addRenderableWidget((GuiEventListener)new ColorPickerWidget(this.width / 2 + margin, y, 175 - margin * 2, 175 - margin * 2, genetics.getGene(Genetics.PHEOMELANIN), genetics.getGene(Genetics.EUMELANIN), MCA.locate("textures/colormap/villager_hair.png"), (vx, vy) -> {
                    genetics.setGene(Genetics.PHEOMELANIN, vx.floatValue());
                    genetics.setGene(Genetics.EUMELANIN, vy.floatValue());
                }));
                break;
            }
            case "personality": {
                LinkedList<ButtonWidget> linkedList = new LinkedList<ButtonWidget>();
                int row = 0;
                int BUTTONS_PER_ROW = 2;
                for (Personality p : Personality.values()) {
                    if (p == Personality.UNASSIGNED) continue;
                    if (row == 2) {
                        row = 0;
                        y += 19;
                    }
                    ButtonWidget widget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 87 * row, y, 87, 20, p.getName(), b -> {
                        this.villager.getVillagerBrain().setPersonality(p);
                        personalityButtons.forEach(v -> {
                            v.active = true;
                        });
                        b.active = false;
                    }));
                    widget.active = p != this.villager.getVillagerBrain().getPersonality();
                    linkedList.add(widget);
                    ++row;
                }
                break;
            }
            case "traits": {
                int index;
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2, y, 32, 20, (Component)Component.literal((String)"<"), b -> this.setTraitPage(this.traitPage - 1)));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 175 - 32, y, 32, 20, (Component)Component.literal((String)">"), b -> this.setTraitPage(this.traitPage + 1)));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 32, y, 111, 20, (Component)Component.translatable((String)"gui.villager_editor.page", (Object[])new Object[]{this.traitPage + 1}), b -> ++this.traitPage));
                y += 22;
                Traits.Trait[] traitArray = this.getValidTraits();
                for (int i = 0; i < 8 && (index = i + this.traitPage * 8) < traitArray.length; ++i) {
                    Traits.Trait t = traitArray[index];
                    MutableComponent name2 = t.getName().copy().withStyle(this.villager.getTraits().hasTrait(t) ? ChatFormatting.GREEN : ChatFormatting.GRAY);
                    this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2, y, 175, 20, (Component)name2, b -> {
                        if (this.villager.getTraits().hasTrait(t)) {
                            this.villager.getTraits().removeTrait(t);
                        } else {
                            this.villager.getTraits().addTrait(t);
                        }
                        b.setMessage((Component)t.getName().copy().withStyle(this.villager.getTraits().hasTrait(t) ? ChatFormatting.GREEN : ChatFormatting.GRAY));
                    }));
                    y += 20;
                }
                break;
            }
            case "debug": {
                boolean bl = false;
                LinkedList<ButtonWidget> professionButtons = new LinkedList<ButtonWidget>();
                for (VillagerProfession p : new VillagerProfession[]{VillagerProfession.NONE, ProfessionsMCA.GUARD, ProfessionsMCA.ARCHER, ProfessionsMCA.OUTLAW, ProfessionsMCA.ADVENTURER, ProfessionsMCA.CULTIST}) {
                    boolean bl2;
                    MutableComponent text = Component.translatable((String)("entity.minecraft.villager." + String.valueOf(p)));
                    ButtonWidget widget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + (bl2 ? 87 : 0), y, 87, 20, (Component)text, b -> {
                        CompoundTag compound = new CompoundTag();
                        compound.putString("profession", BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)p).toString());
                        this.syncVillagerData();
                        Network.sendToServer(new VillagerEditorSyncRequest("profession", this.villagerUUID, compound));
                        this.requestVillagerData();
                        professionButtons.forEach(button -> {
                            button.active = true;
                        });
                        b.active = false;
                    }));
                    professionButtons.add(widget);
                    boolean bl3 = widget.active = this.villager.getProfession() != p;
                    if (bl2) {
                        y += 20;
                    }
                    bl2 = !bl2;
                }
                this.addRenderableWidget((GuiEventListener)new GeneSliderWidget(this.width / 2, y += 4, 175, 20, (Component)Component.translatable((String)"gui.villager_editor.infection"), this.villager.getInfectionProgress(), b -> {
                    this.villager.setInfected(b > 0.0);
                    this.villager.setInfectionProgress(b.floatValue());
                }));
                y += 22;
                assert (this.minecraft != null);
                assert (this.minecraft.player != null);
                Memories player = this.villager.getVillagerBrain().getMemoriesForPlayer((Player)this.minecraft.player);
                y = this.integerChanger(y, player::modHearts, () -> Component.translatable((String)"gui.blueprint.reputation", (Object[])new Object[]{player.getHearts()}));
                this.integerChanger(y, v -> this.villager.getVillagerBrain().modifyMoodValue(v), () -> Component.translatable((String)"gui.interact.label.mood", (Object[])new Object[]{this.villager.getVillagerBrain().getMoodValue()}));
                break;
            }
            case "clothing": 
            case "hair": {
                this.filterGender = this.villager.getGenetics().getGender();
                this.searchString = "";
                EditBox textFieldWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 87, this.height / 2 - 100, 175, 18, (Component)Component.translatable((String)"gui.villager_editor.search")));
                textFieldWidget.setMaxLength(64);
                textFieldWidget.setResponder(v -> {
                    this.searchString = v;
                    this.filter();
                });
                y = this.height / 2 + 85;
                this.pageButtonWidget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 30, y, 60, 20, (Component)Component.literal((String)""), b -> {}));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 32 - 28, y, 28, 20, (Component)Component.literal((String)"<<"), b -> {
                    this.clothingPage = Math.max(0, this.clothingPage - 1);
                    this.updateClothingPageWidget();
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 32, y, 28, 20, (Component)Component.literal((String)">>"), b -> {
                    this.clothingPage = Math.max(0, Math.min(this.clothingPageCount - 1, this.clothingPage + 1));
                    this.updateClothingPageWidget();
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 32 + 32, y, 64, 20, (Component)Component.translatable((String)"gui.button.done"), b -> {
                    if (page.equals("clothing")) {
                        this.setPage("body");
                    } else {
                        this.setPage("head");
                    }
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 128, y, 64, 20, (Component)Component.translatable((String)"gui.button.library"), b -> Minecraft.getInstance().setScreen((Screen)new SkinLibraryScreen(this, this.villagerVisualization))));
                this.widgetMasculine = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 32 - 96 - 64, y, 64, 20, (Component)Component.translatable((String)"gui.villager_editor.masculine"), b -> {
                    this.filterGender = Gender.MALE;
                    this.filter();
                    this.widgetMasculine.active = false;
                    this.widgetFeminine.active = true;
                }));
                this.widgetMasculine.active = this.filterGender != Gender.MALE;
                this.widgetFeminine = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 32 - 96 - 64 + 64, y, 64, 20, (Component)Component.translatable((String)"gui.villager_editor.feminine"), b -> {
                    this.filterGender = Gender.FEMALE;
                    this.filter();
                    this.widgetMasculine.active = true;
                    this.widgetFeminine.active = false;
                }));
                this.widgetFeminine.active = this.filterGender != Gender.FEMALE;
                this.filter();
            }
        }
    }

    private void refreshHairColor() {
        if (this.villager.getHairDye() == 0) {
            this.color.setHSV(0.0, 0.5, 0.5);
        }
        this.villager.setHairDye(Math.max(0.003921569f, (float)this.color.red), Math.max(0.003921569f, (float)this.color.green), Math.max(0.003921569f, (float)this.color.blue));
    }

    private Traits.Trait[] getValidTraits() {
        return (Traits.Trait[])Traits.Trait.values().stream().filter((? super T e) -> {
            if (this.villagerUUID.equals(this.playerUUID)) {
                return (Config.getInstance().bypassTraitRestrictions || e.isUsableOnPlayer()) && e.isEnabled();
            }
            return e.isEnabled();
        }).toList().toArray(Traits.Trait[]::new);
    }

    private void updateClothingPageWidget() {
        if (this.pageButtonWidget != null) {
            this.pageButtonWidget.setMessage((Component)Component.literal((String)String.format("%d / %d", this.clothingPage + 1, this.clothingPageCount)));
        }
    }

    private void filter() {
        if (Objects.equals(this.page, "clothing")) {
            this.filteredClothing = this.filter(VillagerEditorScreen.getClothing());
        } else {
            this.filteredHair = this.filter(VillagerEditorScreen.getHair());
        }
    }

    private <T extends SkinListEntry> List<String> filter(HashMap<String, T> map) {
        List<String> filtered = map.entrySet().stream().filter((? super T v) -> this.filterGender == ((SkinListEntry)v.getValue()).getGender() || ((SkinListEntry)v.getValue()).getGender() == Gender.NEUTRAL).filter((? super T v) -> {
            Object patt0$temp = v.getValue();
            if (patt0$temp instanceof Clothing) {
                Clothing c = (Clothing)patt0$temp;
                return !c.exclude;
            }
            return true;
        }).filter((? super T v) -> MCA.isBlankString(this.searchString) || ((String)v.getKey()).contains(this.searchString)).map(Map.Entry::getKey).toList();
        this.clothingPageCount = (int)Math.ceil((float)filtered.size() / 17.0f);
        this.clothingPage = Math.max(0, Math.min(this.clothingPage, this.clothingPageCount - 1));
        this.updateClothingPageWidget();
        return filtered;
    }

    protected String[] getPages() {
        if (this.villagerUUID.equals(this.playerUUID)) {
            return new String[]{"general", "body", "head", "traits"};
        }
        return new String[]{"general", "body", "head", "personality", "traits", "debug"};
    }

    protected void drawName(int x, int y) {
        this.drawName(x, y, name -> {
            this.updateName((String)name);
            if (this.doneWidget != null) {
                this.doneWidget.active = !MCA.isBlankString(name);
            }
        });
    }

    protected void drawName(int x, int y, Consumer<String> onChanged) {
        this.villagerNameField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, x, y, 116, 18, (Component)Component.translatable((String)"structure_block.structure_name")));
        this.villagerNameField.setMaxLength(32);
        this.villagerNameField.setValue(this.getName().getString());
        this.villagerNameField.setResponder(onChanged);
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(x + 116 + 1, y - 1, 56, 20, (Component)Component.translatable((String)"gui.button.random"), b -> Network.sendToServer(new VillagerNameRequest(this.villager.getGenetics().getGender()))));
    }

    public Component getName() {
        Component villagerName = null;
        boolean isPlayer = this.villagerUUID.equals(this.playerUUID);
        if (isPlayer) {
            assert (this.minecraft != null);
            assert (this.minecraft.player != null);
            villagerName = this.minecraft.player.getCustomName();
        } else if (this.villager.hasCustomName()) {
            villagerName = this.villager.getCustomName();
        }
        if (villagerName == null || MCA.isBlankString(villagerName.getString())) {
            if (isPlayer) {
                assert (this.minecraft != null);
                assert (this.minecraft.player != null);
                villagerName = this.minecraft.player.getName();
            } else {
                villagerName = this.villager.getName();
            }
            if (MCA.isBlankString(villagerName.getString())) {
                Network.sendToServer(new VillagerNameRequest(this.villager.getGenetics().getGender()));
            } else {
                this.updateName(villagerName.getString());
            }
        }
        return villagerName;
    }

    public void updateName(String name) {
        if (!MCA.isBlankString(name)) {
            Component newName = Component.nullToEmpty((String)name);
            boolean isPlayer = this.villagerUUID.equals(this.playerUUID);
            if (isPlayer) {
                assert (this.minecraft != null);
                assert (this.minecraft.player != null);
                Component realName = this.minecraft.player.getName();
                if (realName.getString().equals(name)) {
                    newName = null;
                }
                this.minecraft.player.setCustomName(newName);
                this.minecraft.player.setCustomNameVisible(newName != null);
            }
            this.villager.setCustomName(newName);
        }
    }

    void drawGender(int x, int y) {
        this.genderButtonFemale = new ButtonWidget(x, y, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.feminine"), sender -> {
            this.villager.getGenetics().setGender(Gender.FEMALE);
            this.sendCommand("gender");
            this.genderButtonFemale.active = false;
            this.genderButtonMale.active = true;
        });
        this.addRenderableWidget((GuiEventListener)this.genderButtonFemale);
        this.genderButtonMale = new ButtonWidget(x + 87, y, 87, 20, (Component)Component.translatable((String)"gui.villager_editor.masculine"), sender -> {
            this.villager.getGenetics().setGender(Gender.MALE);
            this.sendCommand("gender");
            this.genderButtonFemale.active = true;
            this.genderButtonMale.active = false;
        });
        this.addRenderableWidget((GuiEventListener)this.genderButtonMale);
        this.genderButtonFemale.active = this.villager.getGenetics().getGender() != Gender.FEMALE;
        this.genderButtonMale.active = this.villager.getGenetics().getGender() != Gender.MALE;
    }

    void addModelSelectionWidgets(int x, int y) {
        if (this.allowPlayerModel && this.allowVillagerModel) {
            this.villagerSkinWidget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(x, y, 58, 20, "gui.villager_editor.villager_skin", b -> {
                this.villagerData.putInt("PlayerModel", VillagerLike.PlayerModel.VILLAGER.ordinal());
                this.syncVillagerData();
                this.playerSkinWidget.active = true;
                this.villagerSkinWidget.active = false;
                this.vanillaSkinWidget.active = true;
            }));
            this.villagerSkinWidget.active = this.villagerData.getInt("PlayerModel") != VillagerLike.PlayerModel.VILLAGER.ordinal();
            this.playerSkinWidget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(x + 58, y, 58, 20, "gui.villager_editor.player_skin", b -> {
                this.villagerData.putInt("PlayerModel", VillagerLike.PlayerModel.PLAYER.ordinal());
                this.syncVillagerData();
                this.playerSkinWidget.active = false;
                this.villagerSkinWidget.active = true;
                this.vanillaSkinWidget.active = true;
            }));
            this.playerSkinWidget.active = this.villagerData.getInt("PlayerModel") != VillagerLike.PlayerModel.PLAYER.ordinal();
            this.vanillaSkinWidget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(x + 116, y, 58, 20, "gui.villager_editor.vanilla_skin", b -> {
                this.villagerData.putInt("PlayerModel", VillagerLike.PlayerModel.VANILLA.ordinal());
                this.syncVillagerData();
                this.villagerSkinWidget.active = true;
                this.playerSkinWidget.active = true;
                this.vanillaSkinWidget.active = false;
            }));
            this.vanillaSkinWidget.active = this.villagerData.getInt("PlayerModel") != VillagerLike.PlayerModel.VANILLA.ordinal();
        } else {
            ((TooltipButtonWidget)this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget((int)x, (int)y, (int)175, (int)20, (String)"gui.villager_editor.model_blacklist_hint", (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$addModelSelectionWidgets$61(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()))).active = false;
        }
    }

    private void sendCommand(String command) {
        this.sendCommand(command, new CompoundTag());
    }

    private void sendCommand(String command, CompoundTag nbt) {
        this.syncVillagerData();
        Network.sendToServer(new VillagerEditorSyncRequest(command, this.villagerUUID, nbt));
        this.requestVillagerData();
    }

    private void setTraitPage(int i) {
        Traits.Trait[] traits = this.getValidTraits();
        int maxPage = (int)Math.ceil((double)traits.length / 8.0) - 1;
        this.traitPage = Math.max(0, Math.min(maxPage, i));
        this.setPage("traits");
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.page.equals("clothing") && this.hoveredClothingId >= 0 && this.filteredClothing.size() > this.hoveredClothingId) {
            this.villager.setClothes(this.filteredClothing.get(this.hoveredClothingId));
            this.setPage("body");
            this.eventCallback("clothing");
            return true;
        }
        if (this.page.equals("hair") && this.hoveredClothingId >= 0 && this.filteredHair.size() > this.hoveredClothingId) {
            this.villager.setHair(this.filteredHair.get(this.hoveredClothingId));
            this.setPage("head");
            this.eventCallback("hair");
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void eventCallback(String event) {
    }

    protected boolean shouldUsePlayerModel() {
        return false;
    }

    protected boolean shouldPrintPlayerHint() {
        return true;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        if (this.villager == null) {
            return;
        }
        this.villager.tickCount = (int)(System.currentTimeMillis() / 50L);
        if (this.shouldDrawEntity()) {
            int x = this.width / 2 - 175;
            int y = this.height / 2;
            if (this.villagerUUID.equals(this.playerUUID) && this.shouldUsePlayerModel()) {
                assert (Minecraft.getInstance().player != null);
                InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)x, (int)(y - 75), (int)(x + 175), (int)(y + 75), (int)60, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)Minecraft.getInstance().player);
            } else {
                InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)x, (int)(y - 75), (int)(x + 175), (int)(y + 75), (int)60, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.villager);
            }
            if (this.shouldPrintPlayerHint() && this.villagerUUID.equals(this.playerUUID) && this.villagerData.getInt("PlayerModel") != VillagerLike.PlayerModel.VILLAGER.ordinal()) {
                PoseStack matrices = context.pose();
                matrices.pushPose();
                matrices.translate((float)x, (float)(y - 145), 0.0f);
                matrices.scale(0.5f, 0.5f, 0.5f);
                context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.villager_editor.model_hint"), 0, 0, -1426063361);
                matrices.popPose();
            }
        }
        if (this.page.equals("clothing") || this.page.equals("hair")) {
            CompoundTag nbt = new CompoundTag();
            this.villager.save(nbt);
            this.villagerVisualization.load(nbt);
            this.villagerVisualization.setAge(this.villager.getAge());
            this.villagerVisualization.refreshDimensions();
            int i = 0;
            this.hoveredClothingId = -1;
            block0: for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 8 + y; ++x) {
                    int index = this.clothingPage * 17 + i;
                    if ((this.page.equals("clothing") ? this.filteredClothing : this.filteredHair).size() <= index) continue block0;
                    if (this.page.equals("clothing")) {
                        this.villagerVisualization.setClothes(this.filteredClothing.get(index));
                    } else {
                        this.villagerVisualization.setHair(this.filteredHair.get(index));
                    }
                    int cx = this.width / 2 + (int)(((double)x - 4.0 + 0.5 - 0.5 * (double)(y % 2)) * 40.0);
                    int cy = this.height / 2 + (int)(((double)y - 1.0 + 0.5) * 65.0);
                    if (Math.abs(cx - mouseX) <= 20 && Math.abs(cy - mouseY + 5) <= 30) {
                        this.hoveredClothingId = index;
                    }
                    InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)(cx - 20), (int)(cy - 25), (int)(cx + 20), (int)(cy + 40), (int)(this.hoveredClothingId == index ? 35 : 30), (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.villagerVisualization);
                    ++i;
                }
            }
        }
    }

    protected boolean shouldDrawEntity() {
        return !this.page.equals("loading") && !this.page.equals("clothing") && !this.page.equals("hair");
    }

    protected boolean shouldShowPageSelection() {
        return !this.page.equals("clothing") && !this.page.equals("hair");
    }

    public void setVillagerName(String name) {
        this.villagerNameField.setValue(name);
        this.updateName(name);
    }

    public void setVillagerData(CompoundTag villagerData) {
        if (this.villager != null) {
            this.villagerData = villagerData;
            this.villager.load(villagerData);
            int hairDye = this.villager.getHairDye();
            this.hsvColoredHair = hairDye != -16777216;
            this.color.setRGB((double)FastColor.ABGR32.red((int)hairDye) / 255.0, (double)FastColor.ABGR32.green((int)hairDye) / 255.0, (double)FastColor.ABGR32.blue((int)hairDye) / 255.0);
            this.villagerBreedingAge = villagerData.getInt("Age");
            this.villager.setAge(this.villagerBreedingAge);
            if (this.minecraft != null && this.minecraft.player != null) {
                this.villager.setPosRaw(this.minecraft.player.getX(), this.minecraft.player.getY(), this.minecraft.player.getZ());
                this.villagerVisualization.setPosRaw(this.minecraft.player.getX(), this.minecraft.player.getY(), this.minecraft.player.getZ());
            }
            this.villager.refreshDimensions();
        }
        if (this.page.equals("loading")) {
            this.setPage("general");
        } else {
            this.setPage(this.page);
        }
    }

    private void requestVillagerData() {
        Network.sendToServer(new GetVillagerRequest(this.villagerUUID));
    }

    public void syncVillagerData() {
        CompoundTag nbt = this.villagerData;
        this.villager.save(nbt);
        nbt.putInt("Age", this.villagerBreedingAge);
        Network.sendToServer(new VillagerEditorSyncRequest("sync", this.villagerUUID, nbt));
    }

    @Override
    public void skinListUpdatedCallback() {
        this.filter();
    }

    public VillagerEntityMCA getVillager() {
        return this.villager;
    }

    private static /* synthetic */ void lambda$addModelSelectionWidgets$61(Button b) {
    }

    private /* synthetic */ void lambda$setPage$6(String p, Button sender) {
        this.setPage(p);
    }
}

