/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.CallToPlayerMessage;
import net.conczin.mca.network.c2s.GetFamilyRequest;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.util.compat.ButtonWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WhistleScreen
extends Screen {
    private List<String> keys = new ArrayList<String>();
    private CompoundTag villagerData = new CompoundTag();
    private VillagerEntityMCA dummy;
    private ButtonWidget selectionLeftButton;
    private ButtonWidget selectionRightButton;
    private ButtonWidget villagerNameButton;
    private ButtonWidget callButton;
    private int loadingAnimationTicks;
    private int selectedIndex;

    public WhistleScreen() {
        super((Component)Component.translatable((String)"gui.whistle.title"));
    }

    public void tick() {
        super.tick();
        if (this.loadingAnimationTicks != -1) {
            ++this.loadingAnimationTicks;
        }
        if (this.loadingAnimationTicks >= 20) {
            this.loadingAnimationTicks = 0;
        }
    }

    public void init() {
        Network.sendToServer(new GetFamilyRequest());
        this.selectionLeftButton = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 123, this.height / 2 + 65, 20, 20, (Component)Component.literal((String)"<<"), b -> {
            this.selectedIndex = this.selectedIndex == 0 ? this.keys.size() - 1 : --this.selectedIndex;
            this.setVillagerData(this.selectedIndex);
        }));
        this.selectionRightButton = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 103, this.height / 2 + 65, 20, 20, (Component)Component.literal((String)">>"), b -> {
            this.selectedIndex = this.selectedIndex == this.keys.size() - 1 ? 0 : ++this.selectedIndex;
            this.setVillagerData(this.selectedIndex);
        }));
        this.villagerNameButton = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 100, this.height / 2 + 65, 200, 20, (Component)Component.literal((String)""), b -> {}));
        this.callButton = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 100, this.height / 2 + 90, 60, 20, (Component)Component.translatable((String)"gui.button.call"), b -> {
            Network.sendToServer(new CallToPlayerMessage(UUID.fromString(this.keys.get(this.selectedIndex))));
            Objects.requireNonNull(this.minecraft).setScreen(null);
        }));
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 40, this.height / 2 + 90, 60, 20, (Component)Component.translatable((String)"gui.button.exit"), b -> Objects.requireNonNull(this.minecraft).setScreen(null)));
        this.toggleButtons(false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float offset) {
        super.render(context, mouseX, mouseY, offset);
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.whistle.title"), this.width / 2, this.height / 2 - 100, 0xFFFFFF);
        if (this.loadingAnimationTicks != -1) {
            String loadingMsg = new String(new char[this.loadingAnimationTicks / 5 % 4]).replace("\u0000", ".");
            context.drawString(this.font, (Component)Component.translatable((String)"gui.loading").append((Component)Component.literal((String)loadingMsg)), this.width / 2 - 20, this.height / 2 - 10, 0xFFFFFF);
        } else if (this.keys.isEmpty()) {
            context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.whistle.noFamily"), this.width / 2, this.height / 2 + 50, 0xFFFFFF);
        } else {
            context.drawCenteredString(this.font, this.selectedIndex + 1 + " / " + this.keys.size(), this.width / 2, this.height / 2 + 50, 0xFFFFFF);
        }
        if (this.dummy != null) {
            int posX = this.width / 2;
            int posY = this.height / 2;
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)(posX - 30), (int)(posY - 70), (int)(posX + 30), (int)(posY + 45), (int)60, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.dummy);
        }
    }

    public void setVillagerData(@NotNull CompoundTag data) {
        this.villagerData = data;
        this.keys = new ArrayList<String>(data.getAllKeys());
        this.loadingAnimationTicks = -1;
        this.selectedIndex = 0;
        this.setVillagerData(0);
    }

    private void setVillagerData(int index) {
        if (!this.keys.isEmpty()) {
            CompoundTag firstData = this.villagerData.getCompound(this.keys.get(index));
            this.dummy = (VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.create((Level)Minecraft.getInstance().level);
            this.dummy.readAdditionalSaveData(firstData);
            this.villagerNameButton.setMessage(this.dummy.getDisplayName());
            this.toggleButtons(true);
        } else {
            this.toggleButtons(false);
        }
    }

    private void toggleButtons(boolean enabled) {
        this.selectionLeftButton.active = enabled;
        this.selectionRightButton.active = enabled;
        this.callButton.active = enabled;
    }
}

