/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui.immersive_library;

import com.mojang.blaze3d.platform.NativeImage;
import net.conczin.mca.client.resources.SkinLocations;
import net.minecraft.util.Mth;

public class Utils {
    public static boolean verify(NativeImage image) {
        int errors = 0;
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                if (!SkinLocations.SKIN_LOOKUP[x][y] || image.getLuminanceOrAlpha(x, y) != 0 || ++errors <= 6) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean verifyHair(NativeImage image) {
        int errors = 0;
        int pixels = 0;
        double brightness = 0.0;
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                int r = image.getRedOrLuminance(x, y) & 0xFF;
                int g = image.getGreenOrLuminance(x, y) & 0xFF;
                int b = image.getBlueOrLuminance(x, y) & 0xFF;
                int a = image.getLuminanceOrAlpha(x, y) & 0xFF;
                if (a <= 0) continue;
                int l = Mth.clamp((int)((int)(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b)), (int)0, (int)255);
                brightness += (double)l;
                ++pixels;
                errors += Math.abs(r - l);
                errors += Math.abs(g - l);
                errors += Math.abs(b - l);
            }
        }
        return errors < pixels && (brightness /= (double)pixels) > 160.0;
    }
}

