/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.client.model.PlayerArmorExtendedModel;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.VillagerDimensions;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;

public class PlayerEntityExtendedModel<T extends LivingEntity>
extends PlayerModel<T>
implements CommonVillagerModel<T> {
    public final ModelPart breasts;
    public final ModelPart breastsWear;
    final VillagerDimensions.Mutable dimensions = new VillagerDimensions.Mutable(AgeState.ADULT);
    float breastSize;

    public PlayerEntityExtendedModel(ModelPart root) {
        super(root, false);
        this.breasts = root.getChild("breasts");
        this.breastsWear = root.getChild("breastplate");
    }

    public void copyPropertiesTo(HumanoidModel<T> target) {
        super.copyPropertiesTo(target);
        if (target instanceof PlayerEntityExtendedModel) {
            PlayerEntityExtendedModel playerTarget = (PlayerEntityExtendedModel)target;
            this.copyAttributes(playerTarget);
        }
        if (target instanceof PlayerArmorExtendedModel) {
            PlayerArmorExtendedModel armorTarget = (PlayerArmorExtendedModel)target;
            this.copyAttributes(armorTarget);
        }
    }

    private void copyAttributes(PlayerEntityExtendedModel<T> target) {
        target.leftPants.copyFrom(this.leftPants);
        target.rightPants.copyFrom(this.rightPants);
        target.leftSleeve.copyFrom(this.leftSleeve);
        target.rightSleeve.copyFrom(this.rightSleeve);
        target.jacket.copyFrom(this.jacket);
        target.breastsWear.copyFrom(this.breastsWear);
        this.copyCommonAttributes(target);
        target.breasts.visible = this.breasts.visible;
        target.breasts.copyFrom(this.breasts);
    }

    private void copyAttributes(PlayerArmorExtendedModel<T> target) {
        this.copyCommonAttributes(target);
        target.breasts.visible = this.breasts.visible;
        target.breasts.copyFrom(this.breasts);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.breastsWear.visible = this.jacket.visible;
        this.renderCommon(matrices, vertices, light, overlay, color);
    }

    @Override
    public ModelPart getBreastPart() {
        return this.breasts;
    }

    @Override
    public ModelPart getBodyPart() {
        return this.body;
    }

    @Override
    public Iterable<ModelPart> getCommonHeadParts() {
        return this.headParts();
    }

    @Override
    public Iterable<ModelPart> getCommonBodyParts() {
        return this.bodyParts();
    }

    @Override
    public Iterable<ModelPart> getBreastParts() {
        return ImmutableList.of((Object)this.breasts, (Object)this.breastsWear);
    }

    @Override
    public VillagerDimensions.Mutable getDimensions() {
        return this.dimensions;
    }

    @Override
    public float getBreastSize() {
        return this.breastSize;
    }

    @Override
    public void setBreastSize(float breastSize) {
        this.breastSize = breastSize;
    }

    public void setupAnim(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (CommonVillagerModel.getVillager(villager).getAgeState() == AgeState.BABY && !villager.isPassenger()) {
            limbDistance = (float)Math.sin((float)((LivingEntity)villager).tickCount / 12.0f);
            limbAngle = (float)Math.cos((float)((LivingEntity)villager).tickCount / 9.0f) * 3.0f;
            headYaw += (float)Math.sin((float)((LivingEntity)villager).tickCount / 2.0f);
        }
        super.setupAnim(villager, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        this.applyVillagerDimensions(CommonVillagerModel.getVillager(villager), villager.isCrouching());
    }

    public <M extends HumanoidModel<T>> void copyVisibility(M model) {
        this.head.visible = model.head.visible;
        this.hat.visible = model.head.visible;
        this.body.visible = model.body.visible;
        this.jacket.visible = model.body.visible;
        this.breasts.visible = model.body.visible;
        this.breastsWear.visible = model.body.visible;
        this.leftArm.visible = model.leftArm.visible;
        this.leftSleeve.visible = model.leftArm.visible;
        this.rightArm.visible = model.rightArm.visible;
        this.rightSleeve.visible = model.rightArm.visible;
        this.leftLeg.visible = model.leftLeg.visible;
        this.leftPants.visible = model.leftLeg.visible;
        this.rightLeg.visible = model.rightLeg.visible;
        this.rightPants.visible = model.rightLeg.visible;
    }
}

