/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.conczin.mca.Config;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.VillagerDimensions;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class VillagerEntityBaseModelMCA<T extends LivingEntity>
extends HumanoidModel<T>
implements CommonVillagerModel<T> {
    protected static final String BREASTS = "breasts";
    public final ModelPart breasts;
    final VillagerDimensions.Mutable dimensions = new VillagerDimensions.Mutable(AgeState.ADULT);
    float breastSize;

    public VillagerEntityBaseModelMCA(ModelPart root) {
        super(root);
        this.breasts = root.getChild(BREASTS);
    }

    public static MeshDefinition getModelData(CubeDeformation dilation) {
        MeshDefinition modelData = HumanoidModel.createMesh((CubeDeformation)dilation, (float)0.0f);
        PartDefinition data = modelData.getRoot();
        data.addOrReplaceChild(BREASTS, VillagerEntityBaseModelMCA.newBreasts(dilation, 0), PartPose.ZERO);
        return modelData;
    }

    protected static CubeListBuilder newBreasts(CubeDeformation dilation, int oy) {
        CubeListBuilder builder = CubeListBuilder.create();
        if (Config.getInstance().enableBoobs) {
            builder.texOffs(18, 21 + oy).addBox(-3.25f, -1.25f, -1.5f, 6.0f, 3.0f, 3.0f, dilation);
        }
        return builder;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.hat);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void prepareMobModel(T entity, float limbAngle, float limbDistance, float tickDelta) {
        super.prepareMobModel(entity, limbDistance, limbAngle, tickDelta);
        this.riding |= ((VillagerLike)entity).getAgeState() == AgeState.BABY;
    }

    public void setupAnim(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (((VillagerLike)villager).getAgeState() == AgeState.BABY && !villager.isPassenger()) {
            limbDistance = (float)Math.sin((float)((LivingEntity)villager).tickCount / 12.0f);
            limbAngle = (float)Math.cos((float)((LivingEntity)villager).tickCount / 9.0f) * 3.0f;
            headYaw += (float)Math.sin((float)((LivingEntity)villager).tickCount / 2.0f);
        }
        if (villager.isBaby()) {
            limbAngle /= 3.0f;
        }
        super.setupAnim(villager, limbAngle /= 0.2f + ((VillagerLike)villager).getRawVerticalScaleFactor(), limbDistance, animationProgress, headYaw, headPitch);
        if (((VillagerLike)villager).getVillagerBrain().isPanicking()) {
            float toRadians = (float)Math.PI / 180;
            float armRaise = ((float)Math.sin(animationProgress / 5.0f) * 30.0f - 180.0f + (float)Math.sin(animationProgress / 3.0f) * 3.0f) * toRadians;
            float waveSideways = ((float)Math.sin(animationProgress / 2.0f) * 12.0f - 17.0f) * toRadians;
            this.leftArm.xRot = armRaise;
            this.leftArm.zRot = -waveSideways;
            this.rightArm.xRot = -armRaise;
            this.rightArm.zRot = waveSideways;
        }
        this.applyVillagerDimensions((VillagerLike)villager, villager.isCrouching());
    }

    public void copyPropertiesTo(HumanoidModel<T> target) {
        super.copyPropertiesTo(target);
        if (target instanceof VillagerEntityBaseModelMCA) {
            VillagerEntityBaseModelMCA m = (VillagerEntityBaseModelMCA)target;
            this.copyCommonAttributes(m);
            m.breasts.visible = this.breasts.visible;
            m.breasts.copyFrom(this.breasts);
        }
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.renderCommon(matrices, vertices, light, overlay, color);
    }

    @Override
    public ModelPart getBreastPart() {
        return this.breasts;
    }

    @Override
    public ModelPart getBodyPart() {
        return this.body;
    }

    @Override
    public Iterable<ModelPart> getCommonHeadParts() {
        return this.headParts();
    }

    @Override
    public Iterable<ModelPart> getCommonBodyParts() {
        return this.bodyParts();
    }

    @Override
    public Iterable<ModelPart> getBreastParts() {
        return ImmutableList.of((Object)this.breasts);
    }

    @Override
    public VillagerDimensions.Mutable getDimensions() {
        return this.dimensions;
    }

    @Override
    public float getBreastSize() {
        return this.breastSize;
    }

    @Override
    public void setBreastSize(float breastSize) {
        this.breastSize = breastSize;
    }
}

