/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class InteractionParticle
extends TextureSheetParticle {
    protected InteractionParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
        this.xd *= (double)0.01f;
        this.yd *= (double)0.01f;
        this.zd *= (double)0.01f;
        this.yd += 0.1;
        this.quadSize *= 1.5f;
        this.lifetime = 20;
        this.hasPhysics = false;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float tickDelta) {
        return 0.3f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)0.86f;
            this.yd *= (double)0.86f;
            this.zd *= (double)0.86f;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            InteractionParticle heartparticle = new InteractionParticle(world, x, y + 0.5, z);
            heartparticle.pickSprite(this.sprite);
            heartparticle.setColor(1.0f, 1.0f, 1.0f);
            return heartparticle;
        }
    }
}

