/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.render.layer;

import net.conczin.mca.client.gui.immersive_library.SkinCache;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.client.render.layer.VillagerLayer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ClothingLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends VillagerLayer<T, M> {
    private final String variant;

    public ClothingLayer(RenderLayerParent<T, M> renderer, M model, String variant) {
        super(renderer, model);
        this.variant = variant;
    }

    @Override
    public ResourceLocation getSkin(T villager) {
        String v = CommonVillagerModel.getVillager(villager).isBurned() ? "burnt" : this.variant;
        String identifier = CommonVillagerModel.getVillager(villager).getClothes();
        if (identifier.startsWith("immersive_library:")) {
            return SkinCache.getTextureIdentifier(Integer.parseInt(identifier.substring(18)));
        }
        return this.cached(identifier + v, clothes -> {
            ResourceLocation id = ResourceLocation.parse((String)CommonVillagerModel.getVillager((Entity)villager).getClothes());
            ResourceLocation idNew = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().replace("normal", v));
            if (this.canUse(idNew)) {
                return idNew;
            }
            return id;
        });
    }
}

