/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.tts.sound;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import org.lwjgl.BufferUtils;

public class PCMAudioStream
implements AudioStream {
    private static final AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, false);
    private ByteBuffer buffer;

    public PCMAudioStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public AudioFormat getFormat() {
        return FORMAT;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer read(int size) {
        if (this.buffer == null) {
            return null;
        }
        int remaining = this.buffer.remaining();
        if (remaining <= 0) {
            return null;
        }
        int bytesToRead = Math.min(size, remaining);
        ByteBuffer result = this.buffer.slice();
        result.limit(bytesToRead);
        this.buffer.position(this.buffer.position() + bytesToRead);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)size);
        byteBuffer.put(result);
        byteBuffer.flip();
        return byteBuffer;
    }

    public void close() throws IOException {
    }
}

