/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity;

import net.conczin.mca.Config;
import net.conczin.mca.entity.UpdatableInventory;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.Relationship;
import net.conczin.mca.entity.ai.Traits;
import net.conczin.mca.entity.ai.brain.VillagerBrain;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.CompassionateEntity;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.interaction.ZombieCommandHandler;
import net.conczin.mca.registry.TagsMCA;
import net.conczin.mca.util.InventoryUtils;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZombieVillagerEntityMCA
extends ZombieVillager
implements VillagerLike<ZombieVillagerEntityMCA>,
CompassionateEntity<Relationship<ZombieVillagerEntityMCA>> {
    private static final CDataManager<ZombieVillagerEntityMCA> DATA = VillagerEntityMCA.createTrackedData(ZombieVillagerEntityMCA.class).build();
    private final VillagerBrain<ZombieVillagerEntityMCA> mcaBrain = new VillagerBrain<ZombieVillagerEntityMCA>(this);
    private final Genetics genetics = new Genetics(this);
    private final Traits traits = new Traits(this);
    private final Relationship<ZombieVillagerEntityMCA> relations = new Relationship<ZombieVillagerEntityMCA>(this);
    private final ZombieCommandHandler interactions = new ZombieCommandHandler(this);
    private final UpdatableInventory inventory = new UpdatableInventory(27);
    private int burned;

    public ZombieVillagerEntityMCA(EntityType<? extends ZombieVillager> type, Level world, Gender gender) {
        super(type, world);
        this.genetics.setGender(gender);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.getTypeDataManager().register(builder);
    }

    @Override
    public CDataManager<ZombieVillagerEntityMCA> getTypeDataManager() {
        return DATA;
    }

    @Override
    public Genetics getGenetics() {
        return this.genetics;
    }

    @Override
    public Traits getTraits() {
        return this.traits;
    }

    @Override
    public VillagerBrain<?> getVillagerBrain() {
        return this.mcaBrain;
    }

    public ZombieCommandHandler getInteractions() {
        return this.interactions;
    }

    @Override
    public boolean isBurned() {
        return this.burned > 0;
    }

    @Override
    public Relationship<ZombieVillagerEntityMCA> getRelationships() {
        return this.relations;
    }

    @Override
    public float getInfectionProgress() {
        return 1.0f;
    }

    @Override
    public void setInfectionProgress(float progress) {
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        if (name != null) {
            this.setName(name.getString());
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (pose == Pose.SLEEPING) {
            return SLEEPING_DIMENSIONS;
        }
        float height = this.getVerticalScaleFactor() * 2.0f;
        float width = this.getHorizontalScaleFactor() * 0.6f;
        return EntityDimensions.scalable((float)width, (float)height);
    }

    public final InteractionResult interactAt(Player player, Vec3 pos, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand.equals((Object)InteractionHand.MAIN_HAND) && !stack.is(TagsMCA.Items.ZOMBIE_EGGS) && stack.getItem() != Items.GOLDEN_APPLE && player instanceof ServerPlayer) {
            String t = new String(new char[this.getRandom().nextInt(8) + 2]).replace("\u0000", ". ");
            this.sendChatMessage((Component)Component.literal((String)t), (Entity)player);
        }
        return super.interactAt(player, pos, hand);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        if (this.getAgeState() == AgeState.UNASSIGNED) {
            if (this.random.nextFloat() < Config.getInstance().babyZombieChance) {
                this.setAgeState(this.isBaby() ? AgeState.BABY : AgeState.random());
            } else {
                this.setAgeState(AgeState.ADULT);
            }
        }
        if (this.getAgeState() == AgeState.BABY) {
            this.setAgeState(AgeState.TODDLER);
        }
        this.initialize(spawnReason);
        return data;
    }

    protected void onOffspringSpawnedFromEgg(Player player, Mob child) {
        child.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(child.blockPosition()), MobSpawnType.SPAWN_EGG, null);
    }

    public void aiStep() {
        super.aiStep();
        --this.burned;
        if (this.isOnFire()) {
            this.burned = Config.getInstance().burnedClothingTickLength;
        }
        if (this.burned > 0) {
            this.spawnBurntParticles();
        }
    }

    public void setBaby(boolean isBaby) {
        super.setBaby(isBaby);
        this.setAgeState(isBaby ? AgeState.BABY : AgeState.ADULT);
    }

    @Override
    public boolean isHostile() {
        return true;
    }

    public void die(DamageSource cause) {
        super.die(cause);
        if (this.level().isClientSide) {
            return;
        }
        InventoryUtils.dropAllItems((Entity)this, (Container)this.inventory);
        this.relations.onDeath(cause);
    }

    public void setInventory(UpdatableInventory inventory) {
        CompoundTag nbt = new CompoundTag();
        InventoryUtils.saveToNBT(this.registryAccess(), inventory, nbt);
        InventoryUtils.readFromNBT(this.registryAccess(), this.inventory, nbt);
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> type, boolean keepInventory) {
        VillagerLike villager;
        Mob mob = !this.isRemoved() && type == EntityType.VILLAGER ? super.convertTo(this.getGenetics().getGender().getVillagerType(), keepInventory) : super.convertTo(type, keepInventory);
        if (mob instanceof VillagerLike) {
            villager = (VillagerLike)mob;
            villager.copyVillagerAttributesFrom(this);
            villager.setInfected(false);
        }
        if (mob instanceof VillagerEntityMCA) {
            villager = (VillagerEntityMCA)mob;
            villager.setUUID(this.getUUID());
            ((VillagerEntityMCA)villager).setInventory(this.inventory);
            ((VillagerEntityMCA)villager).setAge(this.getAgeState().toAge());
        }
        return (T)mob;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.getTypeDataManager().load(this, nbt);
        this.relations.readFromNbt(nbt);
        this.updateAttributes();
        this.inventory.clearContent();
        InventoryUtils.readFromNBT(this.registryAccess(), this.inventory, nbt);
        this.validateClothes();
    }

    public final void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.getTypeDataManager().save(this, nbt);
        this.relations.writeToNbt(nbt);
        InventoryUtils.saveToNBT(this.registryAccess(), this.inventory, nbt);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> par) {
        if (this.getTypeDataManager().isParam(AGE_STATE, par) || this.getTypeDataManager().isParam(Genetics.SIZE.getParam(), par)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(par);
    }

    protected boolean shouldDespawnInPeaceful() {
        return !this.isPersistenceRequired();
    }
}

