/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.conczin.mca.MCAClient;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.Personality;
import net.minecraft.locale.Language;
import net.minecraft.util.RandomSource;

public enum DialogueType {
    ADULT(null),
    ADULTP(ADULT),
    UNASSIGNED(ADULT),
    BABY(UNASSIGNED),
    CHILD(ADULT),
    CHILDP(CHILD),
    TODDLER(CHILD),
    TODDLERP(CHILDP),
    SPOUSE(ADULT),
    TEEN(ADULT),
    TEENP(TEEN),
    ENGAGED(ADULT);

    private static final RandomSource random;
    private static final DialogueType[] VALUES;
    public static final Map<String, DialogueType> MAP;
    public final DialogueType fallback;

    private DialogueType(DialogueType fallback) {
        this.fallback = fallback;
    }

    public static DialogueType fromAge(AgeState state) {
        for (DialogueType t : DialogueType.values()) {
            if (!t.name().equals(state.name())) continue;
            return t;
        }
        return UNASSIGNED;
    }

    public static DialogueType byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return UNASSIGNED;
        }
        return VALUES[id];
    }

    private static Optional<String> getPrefixedPhrase(DialogueType type, String prefix, String key) {
        String s;
        DialogueType t = type;
        while (t != null) {
            s = prefix + "." + t.name().toLowerCase(Locale.ENGLISH) + "." + key;
            if (Language.getInstance().has(s)) {
                return Optional.of(s);
            }
            t = t.fallback;
        }
        s = prefix + "." + key;
        if (Language.getInstance().has(s)) {
            return Optional.of(s);
        }
        return Optional.empty();
    }

    public static String applyFallback(String key) {
        Optional<String> p;
        String personality;
        Optional<String> p2;
        Optional<String> p3;
        if (!key.contains("#")) {
            return key;
        }
        HashMap<String, String> flags = new HashMap<String, String>();
        for (String s : key.split("\\.")) {
            if (!s.startsWith("#")) continue;
            flags.put(s.substring(1, 2), s.substring(2));
            key = key.replace(s + ".", "");
        }
        DialogueType type = null;
        if (flags.containsKey("T")) {
            type = MAP.get(flags.get("T"));
        }
        if (type == null) {
            return key;
        }
        if (flags.containsKey("P") && random.nextBoolean() && (p3 = DialogueType.getPrefixedPhrase(type, (String)flags.get("P"), key)).isPresent()) {
            return p3.get();
        }
        if (flags.containsKey("E") && MCAClient.useExpandedPersonalityTranslations() && (p2 = DialogueType.getPrefixedPhrase(type, personality = Personality.valueOf((String)flags.get("E")).name().toLowerCase(Locale.ROOT), key)).isPresent()) {
            return p2.get();
        }
        if (flags.containsKey("G") && (p = DialogueType.getPrefixedPhrase(type, (String)flags.get("G"), key)).isPresent()) {
            return p.get();
        }
        DialogueType t = type;
        while (t != null) {
            String s = t.name().toLowerCase(Locale.ENGLISH) + "." + key;
            if (Language.getInstance().has(s)) {
                return s;
            }
            t = t.fallback;
        }
        return key;
    }

    public DialogueType toChild() {
        return switch (this.ordinal()) {
            case 6 -> TODDLERP;
            case 4 -> CHILDP;
            case 9 -> TEENP;
            case 0 -> ADULTP;
            default -> UNASSIGNED;
        };
    }

    static {
        random = RandomSource.create();
        VALUES = DialogueType.values();
        MAP = Arrays.stream(VALUES).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

