/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.UUID;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.DialogueType;
import net.conczin.mca.entity.ai.brain.VillagerBrain;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

public class Memories {
    private final UUID playerUUID;
    private final VillagerBrain<?> brain;
    private int hearts;
    private int interactionFatigue;
    private DialogueType dialogueType;
    private long lastSeen;

    public Memories(VillagerBrain<?> brain, long time, UUID uuid) {
        this.brain = brain;
        this.playerUUID = uuid;
        this.dialogueType = DialogueType.UNASSIGNED;
        this.lastSeen = time / 24000L;
    }

    public static <E extends Mob> Memories fromCNBT(E villager, @Nullable CompoundTag tag) {
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        Memories memories = new Memories(((VillagerLike)villager).getVillagerBrain(), villager.level().getDayTime(), tag.getUUID("playerUUID"));
        memories.hearts = tag.getInt("hearts");
        memories.interactionFatigue = tag.getInt("interactionFatigue");
        memories.dialogueType = DialogueType.byId(tag.getInt("dialogueType"));
        memories.lastSeen = tag.getLong("lastSeen");
        return memories;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int getHearts() {
        return this.hearts;
    }

    public void setHearts(int value) {
        this.hearts = value;
        this.brain.updateMemories(this);
    }

    public void modHearts(int value) {
        this.setHearts(this.hearts += value);
    }

    public int getInteractionFatigue() {
        return this.interactionFatigue;
    }

    public void setInteractionFatigue(int value) {
        this.interactionFatigue = value;
        this.brain.updateMemories(this);
    }

    public void modInteractionFatigue(int value) {
        this.interactionFatigue += value;
        this.brain.updateMemories(this);
    }

    public DialogueType getDialogueType() {
        return this.dialogueType;
    }

    public void setDialogueType(DialogueType dialogueType) {
        this.dialogueType = dialogueType;
        this.brain.updateMemories(this);
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(int lastSeen) {
        this.lastSeen = lastSeen;
        this.brain.updateMemories(this);
    }

    public CompoundTag toCNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("playerUUID", this.playerUUID);
        nbt.putInt("hearts", this.hearts);
        nbt.putInt("interactionFatigue", this.interactionFatigue);
        nbt.putInt("dialogueType", this.dialogueType.ordinal());
        nbt.putLong("lastSeen", this.lastSeen);
        return nbt;
    }
}

