/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Locale;
import net.conczin.mca.ClientProxy;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.EntityWrapper;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.DialogueType;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.VillagerMessage;
import net.conczin.mca.resources.API;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface Messenger
extends EntityWrapper {
    public static final TargetingConditions CAN_RECEIVE = TargetingConditions.forNonCombat();

    public static void sendEventMessage(Level world, Component message) {
        world.players().forEach(player -> player.displayClientMessage(message, true));
    }

    default public boolean isSpeechImpaired() {
        return false;
    }

    default public boolean isToYoungToSpeak() {
        return false;
    }

    default public void playSpeechEffect() {
    }

    default public DialogueType getDialogueType(Player receiver) {
        return DialogueType.UNASSIGNED;
    }

    public static String getName(ServerPlayer target) {
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            return FamilyTree.get(world).getOrEmpty(target.getUUID()).map(FamilyTreeNode::getName).filter(n -> !MCA.isBlankString(n)).orElse(target.getName().getString());
        }
        return target.getName().getString();
    }

    default public MutableComponent getTranslatable(Player target, String phraseId, Object ... params) {
        Mob mob;
        String targetName;
        Object genderString = "";
        if (target instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)target;
            targetName = Messenger.getName(serverPlayer);
            genderString = "#G" + PlayerSaveData.get(serverPlayer).getGender().name().toLowerCase(Locale.ROOT) + ".";
        } else {
            targetName = target.getName().getString();
        }
        Object[] newParams = new Object[params.length + 1];
        System.arraycopy(params, 0, newParams, 1, params.length);
        newParams[0] = targetName;
        Object professionString = "";
        if (!this.asEntity().isBaby() && (mob = this.asEntity()) instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)mob;
            professionString = "#P" + BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)v.getProfession()).getPath() + ".";
        }
        Object personalityString = "";
        Mob mob2 = this.asEntity();
        if (mob2 instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)mob2;
            personalityString = "#E" + v.getVillagerBrain().getPersonality().name() + ".";
        }
        return Component.translatable((String)((String)genderString + (String)personalityString + (String)professionString + "#T" + this.getDialogueType(target).name() + "." + phraseId), (Object[])newParams);
    }

    default public void sendChatToAllAround(MutableComponent phrase) {
        for (Player player : this.asEntity().level().getNearbyPlayers(CAN_RECEIVE, (LivingEntity)this.asEntity(), this.asEntity().getBoundingBox().inflate(20.0))) {
            float dist = player.distanceTo((Entity)this.asEntity());
            this.sendChatMessage((Component)phrase.withStyle(dist < 10.0f ? ChatFormatting.WHITE : ChatFormatting.GRAY), (Entity)player);
        }
    }

    default public void sendChatToAllAround(String phrase, Object ... params) {
        for (Player player : this.asEntity().level().getNearbyPlayers(CAN_RECEIVE, (LivingEntity)this.asEntity(), this.asEntity().getBoundingBox().inflate(20.0))) {
            float dist = player.distanceTo((Entity)this.asEntity());
            this.sendChatMessage((Component)this.getTranslatable(player, phrase, params).withStyle(dist < 10.0f ? ChatFormatting.WHITE : ChatFormatting.GRAY), (Entity)player);
        }
    }

    default public void sendChatMessage(Player target, String phraseId, Object ... params) {
        this.sendChatMessage((Component)this.getTranslatable(target, phraseId, params), (Entity)target);
    }

    default public Component transformMessage(Component message) {
        if (this.isSpeechImpaired()) {
            return Component.literal((String)API.getRandomSentence("zombie", message.getString()));
        }
        if (this.isToYoungToSpeak()) {
            return Component.literal((String)API.getRandomSentence("baby", message.getString()));
        }
        return message;
    }

    default public Component sendChatMessage(Component message, Entity receiver) {
        message = this.transformMessage(message);
        MutableComponent prefix = Component.literal((String)Config.getInstance().villagerChatPrefix).append(this.asEntity().getDisplayName()).append(": ");
        VillagerMessage msg = new VillagerMessage((Component)prefix, message, this.asEntity().getUUID());
        if (receiver instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)receiver;
            Network.sendToPlayer(msg, serverPlayer);
        } else {
            ClientProxy.getNetworkHandler().handleVillagerMessage(msg);
        }
        this.playSpeechEffect();
        return message;
    }

    default public void sendEventMessage(Component message, Player receiver) {
        receiver.displayClientMessage(message, true);
    }

    default public void sendEventMessage(Component message) {
        if (!(this instanceof Entity)) {
            return;
        }
        Messenger.sendEventMessage(((Entity)this).level(), message);
    }
}

