/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.server.world.data.Building;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;

public class EnterBuildingTask
extends Behavior<VillagerEntityMCA> {
    private final String building;
    private final float speed;

    public EnterBuildingTask(String building, float speed) {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.LOOK_TARGET, MemoryStatus.REGISTERED));
        this.building = building;
        this.speed = speed;
    }

    protected void start(ServerLevel serverWorld, VillagerEntityMCA villager, long l) {
        Optional<BlockPos> blockPos = this.getNextPosition(villager);
        blockPos.ifPresent(pos -> BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)villager, (BlockPos)pos, (float)this.speed, (int)1));
    }

    protected Optional<Building> getNearestBuilding(VillagerEntityMCA villager) {
        return villager.getResidency().getHomeVillage().flatMap(buildings -> buildings.getBuildings().values().stream().filter(a -> a.getType().equals(this.getBuilding(villager))).min(Comparator.comparingInt(a -> a.getCenter().distManhattan((Vec3i)villager.blockPosition()))));
    }

    protected Optional<BlockPos> getRandomPositionIn(Building b, Level world) {
        if (b.getBuildingType().grouped()) {
            return Optional.ofNullable(b.getCenter());
        }
        RandomSource r = world.getRandom();
        BlockPos pos0 = b.getPos0();
        BlockPos pos1 = b.getPos1();
        BlockPos diff = pos1.subtract((Vec3i)pos0);
        int margin = 2;
        for (int attempt = 0; attempt < 16; ++attempt) {
            BlockPos p = pos0.offset((Vec3i)new BlockPos(r.nextInt(Math.max(1, diff.getX() - margin * 2)) + margin, r.nextInt(Math.max(1, diff.getY() - margin * 2)) + margin, r.nextInt(Math.max(1, diff.getZ() - margin * 2)) + margin));
            if (world.canSeeSky(p)) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    protected Optional<BlockPos> getNextPosition(VillagerEntityMCA villager) {
        Optional<Building> b = this.getNearestBuilding(villager);
        if (b.isPresent() && !b.get().containsPos((Vec3i)villager.blockPosition())) {
            return this.getRandomPositionIn(b.get(), villager.level());
        }
        return Optional.empty();
    }

    public String getBuilding(VillagerEntityMCA villager) {
        return this.building;
    }
}

