/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import java.util.Optional;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.brain.tasks.EnterBuildingTask;
import net.conczin.mca.registry.ProfessionsMCA;
import net.conczin.mca.server.world.data.Building;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class EnterFavoredBuildingTask
extends EnterBuildingTask {
    private static final int TICKS_PER_MOOD = 1200;
    private int lastMoodIncrease = 0;

    public EnterFavoredBuildingTask(float speed) {
        super("", speed);
    }

    @Override
    public String getBuilding(VillagerEntityMCA villager) {
        String building = villager.getVillagerBrain().getMood().getBuilding();
        if (building != null) {
            return building;
        }
        return ProfessionsMCA.getFavoredBuilding(villager.getProfession());
    }

    @Override
    protected Optional<BlockPos> getNextPosition(VillagerEntityMCA villager) {
        Optional<Building> b = this.getNearestBuilding(villager);
        if (b.isPresent()) {
            if (b.get().containsPos((Vec3i)villager.blockPosition())) {
                if (villager.tickCount > this.lastMoodIncrease + 1200 && villager.getVillagerBrain().getMoodValue() < 0) {
                    this.lastMoodIncrease = villager.tickCount;
                    villager.getVillagerBrain().modifyMoodValue(1);
                }
            } else {
                return this.getRandomPositionIn(b.get(), villager.level());
            }
        }
        return Optional.empty();
    }
}

