/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.Messenger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class ExtendedMeleeAttackTask
extends Behavior<Mob> {
    private final float range;
    private final int interval;
    private final MemoryModuleType<? extends LivingEntity> target;

    public ExtendedMeleeAttackTask(int interval, float range) {
        this(interval, range, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.ATTACK_TARGET);
    }

    public ExtendedMeleeAttackTask(int interval, float range, MemoryModuleType<? extends LivingEntity> target) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, target, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT));
        this.range = range;
        this.interval = interval;
        this.target = target;
    }

    protected boolean checkExtraStartConditions(ServerLevel world, Mob attacker) {
        LivingEntity target = this.getTarget(attacker);
        return BehaviorUtils.canSee((LivingEntity)attacker, (LivingEntity)target) && this.withinRange((LivingEntity)attacker, target);
    }

    protected void start(ServerLevel world, Mob mobEntity, long l) {
        LivingEntity livingEntity = this.getTarget(mobEntity);
        BehaviorUtils.lookAtEntity((LivingEntity)mobEntity, (LivingEntity)livingEntity);
        if (mobEntity instanceof VillagerLike) {
            VillagerLike villager = (VillagerLike)mobEntity;
            mobEntity.swing(villager.getDominantHand());
        } else {
            mobEntity.swing(InteractionHand.MAIN_HAND);
        }
        mobEntity.doHurtTarget((Entity)livingEntity);
        mobEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)this.interval);
        if (livingEntity.isDeadOrDying() && mobEntity instanceof Messenger) {
            Messenger messenger = (Messenger)mobEntity;
            if ((double)mobEntity.getRandom().nextFloat() < 0.3) {
                messenger.sendChatToAllAround("villager.kill", new Object[0]);
            }
        }
    }

    private boolean withinRange(LivingEntity attacker, LivingEntity target) {
        double r;
        double d = attacker.distanceToSqr(target.getX(), target.getY(), target.getZ());
        return d <= (r = (double)(attacker.getBbWidth() + target.getBbWidth() + this.range));
    }

    private LivingEntity getTarget(Mob mobEntity) {
        return (LivingEntity)mobEntity.getBrain().getMemoryInternal(this.target).get();
    }
}

