/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.conczin.mca.entity.ai.brain.tasks.InteractTask;
import net.conczin.mca.util.BlockBoxExtended;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class PatrolVillageTask
extends Behavior<VillagerEntityMCA> {
    private final int completionRange;
    private final float speed;

    public PatrolVillageTask(int completionRange, float speed) {
        super((Map)ImmutableMap.of(MemoryModuleTypeMCA.PLAYER_FOLLOWING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED));
        this.completionRange = completionRange;
        this.speed = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA entity) {
        return !InteractTask.shouldRun(entity);
    }

    protected void start(ServerLevel serverWorld, VillagerEntityMCA villager, long l) {
        this.getNextPosition(villager).ifPresent(pos -> BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)villager, (BlockPos)pos, (float)this.speed, (int)this.completionRange));
    }

    private Optional<BlockPos> getNextPosition(VillagerEntityMCA villager) {
        return villager.getResidency().getHomeVillage().map(village -> {
            BlockBoxExtended box = village.getBox();
            int x = box.minX() + villager.getRandom().nextInt(box.getXSpan());
            int z = box.minZ() + villager.getRandom().nextInt(box.getZSpan());
            Vec3 targetPos = new Vec3((double)x, (double)box.getCenter().getY(), (double)z);
            return DefaultRandomPos.getPosTowards((PathfinderMob)villager, (int)32, (int)16, (Vec3)targetPos, (double)1.5707963267948966);
        }).map(BlockPos::containing);
    }
}

