/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks.chore;

import java.util.Map;
import java.util.Optional;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractChoreTask
extends Behavior<VillagerEntityMCA> {
    protected static final int FAILED_COOLDOWN = 100;
    protected static final int WALKING_THRESHOLD = 200;
    protected VillagerEntityMCA villager;
    protected int failedTicks;
    protected int walkingTicks;
    protected int lastAge;

    public AbstractChoreTask(Map<MemoryModuleType<?>, MemoryStatus> requirements) {
        super(requirements, 400);
    }

    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA entity) {
        int diff = Math.max(0, entity.tickCount - this.lastAge);
        this.lastAge = entity.tickCount;
        if (this.failedTicks > 0) {
            this.failedTicks -= diff;
            this.walkingTicks += diff;
            if (this.walkingTicks > 200) {
                Optional<Vec3> optional = Optional.ofNullable(LandRandomPos.getPos((PathfinderMob)entity, (int)10, (int)5));
                entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, optional.map(vec3d -> new WalkTarget(vec3d, 0.4f, 0)));
                this.walkingTicks = 0;
            }
            return false;
        }
        return this.villager == null || !this.villager.getVillagerBrain().isPanicking();
    }

    protected void tick(ServerLevel world, VillagerEntityMCA entity, long time) {
        if (this.getAssigningPlayer().isEmpty()) {
            MCA.LOGGER.info("Force-stopped chore because assigning player was not present.");
            this.villager.getVillagerBrain().abandonJob();
        }
    }

    protected void start(ServerLevel world, VillagerEntityMCA entity, long time) {
        this.villager = entity;
    }

    Optional<Player> getAssigningPlayer() {
        return this.villager.getVillagerBrain().getJobAssigner();
    }

    void abandonJobWithMessage(String message) {
        this.getAssigningPlayer().ifPresent(player -> this.villager.sendChatMessage((Player)player, message, new Object[0]));
        this.villager.getVillagerBrain().abandonJob();
    }
}

