/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Chore;
import net.conczin.mca.entity.ai.TaskUtils;
import net.conczin.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import net.conczin.mca.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HarvestingTask
extends AbstractChoreTask {
    private static final int ITEM_READY = 0;
    private static final int ITEM_FOUND = 1;
    private static final int ITEM_MISSING = 2;
    private final List<BlockPos> plantable = new ArrayList<BlockPos>();
    private final List<BlockPos> harvestable = new ArrayList<BlockPos>();
    private final List<BlockPos> bonemealable = new ArrayList<BlockPos>();
    private int lastLandScan = -1200;
    private int lastCropScan = -1200;
    private int workingTick = 0;
    private BlockPos currentPos;

    public HarvestingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.HARVEST && super.checkExtraStartConditions(world, villager);
    }

    protected boolean canStillUse(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.currentPos != null && this.checkExtraStartConditions(world, villager);
    }

    protected void stop(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.getItemInHand(villager.getDominantHand());
        if (!stack.isEmpty()) {
            villager.setItemInHand(villager.getDominantHand(), ItemStack.EMPTY);
        }
        if (this.currentPos != null) {
            this.plantable.remove(this.currentPos);
            this.harvestable.remove(this.currentPos);
            this.bonemealable.remove(this.currentPos);
            this.currentPos = null;
        }
    }

    @Override
    protected void start(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack2;
        int i;
        super.start(world, villager, time);
        if (!villager.hasItemInSlot(villager.getDominantSlot())) {
            i = InventoryUtils.getFirstSlotContainingItem((Container)villager.getInventory(), stack -> stack.getItem() instanceof HoeItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.harvesting.nohoe");
            } else {
                stack2 = villager.getInventory().getItem(i);
                villager.setItemInHand(villager.getDominantHand(), stack2);
            }
        }
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((Container)villager.getInventory(), HoeItem.class) && !villager.hasItemInSlot(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.harvesting.nohoe");
        } else if (!villager.hasItemInSlot(villager.getDominantSlot())) {
            i = InventoryUtils.getFirstSlotContainingItem((Container)villager.getInventory(), stack -> stack.getItem() instanceof HoeItem);
            stack2 = villager.getInventory().getItem(i);
            villager.setItemInHand(villager.getDominantHand(), stack2);
        }
        if (this.plantable.isEmpty() && villager.tickCount - this.lastLandScan > 1200) {
            this.searchUnusedFarmLand(32, 8);
            this.lastLandScan = villager.tickCount;
        }
        if ((this.harvestable.isEmpty() || this.bonemealable.isEmpty()) && villager.tickCount - this.lastCropScan > 1207) {
            this.searchCrop(32, 8);
            this.lastCropScan = villager.tickCount;
        }
        this.currentPos = TaskUtils.getNearestPoint(villager.blockPosition(), this.plantable);
        if (this.currentPos == null) {
            this.currentPos = TaskUtils.getNearestPoint(villager.blockPosition(), this.harvestable);
            if (this.currentPos == null) {
                this.currentPos = TaskUtils.getNearestPoint(villager.blockPosition(), this.bonemealable);
                if (this.currentPos != null) {
                    this.swapItem(stack -> stack.getItem() instanceof BoneMealItem);
                }
            }
        }
    }

    private boolean isValidFarmland(BlockPos pos) {
        BlockState state = this.villager.level().getBlockState(pos);
        return state.getBlock() instanceof FarmBlock && state.canSurvive((LevelReader)this.villager.level(), pos) && this.villager.level().getBlockState(pos.above()).isAir();
    }

    private boolean isValidMature(BlockPos pos) {
        CropBlock crop;
        BlockState state = this.villager.level().getBlockState(pos);
        Block block = state.getBlock();
        return block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(state) || state.getBlock() instanceof StemBlock;
    }

    private boolean isValidImmature(BlockPos pos) {
        CropBlock crop;
        BlockState state = this.villager.level().getBlockState(pos);
        Block block = state.getBlock();
        return block instanceof CropBlock && !(crop = (CropBlock)block).isMaxAge(state);
    }

    private void searchCrop(int rangeX, int rangeY) {
        List<BlockPos> nearbyCrops = TaskUtils.getNearbyBlocks(this.villager.blockPosition(), this.villager.level(), blockState -> blockState.getBlock() instanceof CropBlock || blockState.getBlock() instanceof StemBlock, rangeX, rangeY);
        this.harvestable.addAll(nearbyCrops.stream().filter(this::isValidMature).toList());
        if (this.hasBoneMeal()) {
            this.bonemealable.addAll(nearbyCrops.stream().filter(this::isValidImmature).toList());
        } else {
            this.bonemealable.clear();
        }
    }

    private boolean hasBoneMeal() {
        return InventoryUtils.contains((Container)this.villager.getInventory(), BoneMealItem.class);
    }

    private void searchUnusedFarmLand(int rangeX, int rangeY) {
        this.plantable.addAll(TaskUtils.getNearbyBlocks(this.villager.blockPosition(), this.villager.level(), blockState -> blockState.is(Blocks.FARMLAND), rangeX, rangeY).stream().filter(this::isValidFarmland).toList());
    }

    @Override
    protected void tick(ServerLevel world, VillagerEntityMCA villager, long time) {
        villager.moveTowards(this.currentPos);
        if (villager.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)this.currentPos)) <= 6.0) {
            ++this.workingTick;
            if (this.workingTick % 5 == 0) {
                villager.swing(villager.getDominantHand());
            }
            if (this.workingTick > 40) {
                this.plantable.remove(this.currentPos);
                this.harvestable.remove(this.currentPos);
                this.bonemealable.remove(this.currentPos);
                if (this.isValidFarmland(this.currentPos)) {
                    this.plantSeeds(world, villager, this.currentPos.above(), null);
                } else if (this.isValidMature(this.currentPos)) {
                    BlockState state = world.getBlockState(this.currentPos);
                    if (state.getBlock() instanceof StemBlock) {
                        this.harvestCrops(world, this.currentPos);
                    } else {
                        this.harvestCrops(world, this.currentPos);
                        this.plantSeeds(world, villager, this.currentPos, state.getBlock());
                    }
                } else if (this.isValidImmature(this.currentPos)) {
                    this.bonemealCrop(world, villager, this.currentPos);
                    if (!this.hasBoneMeal()) {
                        this.bonemealable.clear();
                    }
                }
                this.workingTick = 0;
                this.currentPos = null;
            }
        }
    }

    private int swapItem(Predicate<ItemStack> find) {
        ItemStack stack = this.villager.getMainHandItem();
        if (find.test(stack)) {
            return 0;
        }
        SimpleContainer inventory = this.villager.getInventory();
        int slot = InventoryUtils.getFirstSlotContainingItem((Container)inventory, find);
        if (slot < 0) {
            return 2;
        }
        this.villager.setItemInHand(this.villager.getDominantHand(), inventory.getItem(slot));
        return 1;
    }

    private void plantSeeds(ServerLevel world, VillagerEntityMCA villager, BlockPos target, Block block) {
        BlockHitResult hitResult = new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)target), Direction.DOWN, target, true);
        Optional<ItemStack> stack = InventoryUtils.stream((Container)villager.getInventory()).filter(s -> {
            BlockItem blockItem;
            Item patt0$temp;
            return !s.isEmpty() && (patt0$temp = s.getItem()) instanceof BlockItem && (blockItem = (BlockItem)patt0$temp).getBlock() == block;
        }).findAny();
        if (stack.isEmpty()) {
            stack = InventoryUtils.stream((Container)villager.getInventory()).filter(s -> {
                BlockItem blockItem;
                Item patt0$temp;
                return !s.isEmpty() && (patt0$temp = s.getItem()) instanceof BlockItem && (blockItem = (BlockItem)patt0$temp).getBlock() instanceof CropBlock;
            }).findAny();
        }
        stack.ifPresentOrElse(s -> {
            world.setBlock(hitResult.getBlockPos(), ((BlockItem)s.getItem()).getBlock().defaultBlockState(), 3);
            s.shrink(1);
            villager.swing(villager.getDominantHand());
            this.bonemealable.add(target);
        }, () -> this.getAssigningPlayer().ifPresent(p -> villager.sendChatMessage((Player)p, "chore.harvesting.noseed", new Object[0])));
    }

    private void bonemealCrop(ServerLevel world, VillagerEntityMCA villager, BlockPos pos) {
        if (this.swapItem(stack -> stack.getItem() instanceof BoneMealItem) == 0 && BoneMealItem.growCrop((ItemStack)villager.getItemBySlot(villager.getDominantSlot()), (Level)world, (BlockPos)pos)) {
            villager.swing(villager.getDominantHand());
        }
    }

    private void harvestCrops(ServerLevel world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (world.destroyBlock(pos, false, (Entity)this.villager)) {
            LootParams.Builder builder = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)this.villager.position()).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.THIS_ENTITY, (Object)this.villager).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withLuck(0.0f);
            ObjectArrayList drops = world.getServer().reloadableRegistries().getLootTable(state.getBlock().getLootTable()).getRandomItems(builder.create(LootContextParamSets.BLOCK));
            for (ItemStack stack : drops) {
                this.villager.getInventory().addItem(stack);
            }
        }
    }
}

