/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.goal;

import net.conczin.mca.entity.GrimReaperEntity;
import net.conczin.mca.entity.ReaperAttackState;
import net.conczin.mca.entity.ai.TaskUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class GrimReaperRestGoal
extends Goal {
    private static final int COOLDOWN = 1000;
    private static final int MAX_HEALING_COUNT = 5;
    private static final int MAX_HEALING_TIME = 400;
    private final GrimReaperEntity reaper;
    private int lastHeal = -1000;
    private int healingCount = 0;
    private int healingTime;

    public GrimReaperRestGoal(GrimReaperEntity reaper) {
        this.reaper = reaper;
    }

    public boolean canUse() {
        return this.reaper.tickCount > this.lastHeal + 1000 && this.reaper.getHealth() <= this.reaper.getMaxHealth() * (1.0f - ((float)this.healingCount + 1.0f) / 5.0f);
    }

    public boolean canContinueToUse() {
        return this.healingTime > 0;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        this.reaper.teleportTo(this.reaper.getX(), this.reaper.getY() + 8.0, this.reaper.getZ());
        this.healingTime = 400;
        this.lastHeal = this.reaper.tickCount;
        ++this.healingCount;
    }

    public void stop() {
        this.reaper.setAttackState(ReaperAttackState.IDLE);
    }

    public void tick() {
        --this.healingTime;
        this.reaper.setAttackState(ReaperAttackState.REST);
        this.reaper.setDeltaMovement(Vec3.ZERO);
        if (!this.reaper.level().isClientSide && this.healingTime % (10 + this.healingCount * 5) == 0) {
            this.reaper.setHealth(this.reaper.getHealth() + 1.0f);
        }
        if (!this.reaper.level().isClientSide && this.healingTime % 50 == 0) {
            EntityType m;
            Entity e;
            int dX = this.reaper.getRandom().nextInt(16) - 8;
            int dZ = this.reaper.getRandom().nextInt(16) - 8;
            int y = TaskUtils.getSpawnSafeTopLevel(this.reaper.level(), (int)this.reaper.getX() + dX, 256, (int)this.reaper.getZ() + dZ);
            EntityType.LIGHTNING_BOLT.spawn((ServerLevel)this.reaper.level(), BlockPos.containing((double)(this.reaper.getX() + (double)dX), (double)y, (double)(this.reaper.getZ() + (double)dZ)), MobSpawnType.TRIGGERED);
            if (!this.reaper.level().isClientSide && this.healingTime % 100 == 0 && (e = (m = this.reaper.getRandom().nextFloat() < 0.5f ? EntityType.ZOMBIE : EntityType.SKELETON).spawn((ServerLevel)this.reaper.level(), BlockPos.containing((double)(this.reaper.getX() + (double)dX), (double)y, (double)(this.reaper.getZ() + (double)dZ)), MobSpawnType.TRIGGERED)) instanceof Mob) {
                Mob mob = (Mob)e;
                if (m == EntityType.SKELETON) {
                    mob.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
                } else {
                    mob.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
                }
                mob.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.IRON_HELMET));
                mob.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.IRON_CHESTPLATE));
                mob.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.IRON_LEGGINGS));
                mob.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.IRON_BOOTS));
            }
        }
    }
}

