/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.conczin.mca.ClientProxy;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerFactory;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.item.components.BabyParentsComponent;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.OpenGuiRequest;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.DataComponentsMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class BabyItem
extends Item {
    private final Gender gender;

    public BabyItem(Gender gender, Item.Properties properties) {
        super(properties);
        this.gender = gender;
    }

    public static ItemStack createItem(Entity mother, Entity father, long seed) {
        Gender gender = Gender.getRandom();
        ItemStack stack = (gender.binary() == Gender.MALE ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL).getDefaultInstance();
        VillagerLike<?> motherVillager = VillagerLike.toVillager(mother);
        VillagerLike<?> fatherVillager = VillagerLike.toVillager(father);
        VillagerEntityMCA child = VillagerFactory.newVillager(mother.level()).withPosition(mother.position()).withGender(gender).withAge(-AgeState.getMaxAge()).build();
        child.getGenetics().combine(motherVillager.getGenetics(), fatherVillager.getGenetics(), seed);
        child.getTraits().inherit(motherVillager.getTraits(), seed);
        child.getTraits().inherit(fatherVillager.getTraits(), seed);
        CompoundTag compound = new CompoundTag();
        child.save(compound);
        stack.set(DataComponentsMCA.BABY_NBT, (Object)CustomData.of((CompoundTag)compound));
        stack.set(DataComponentsMCA.BABY_AGE, (Object)0);
        stack.set(DataComponentsMCA.BABY_PARENTS, (Object)new BabyParentsComponent(mother.getUUID(), father.getUUID(), mother.getName().getString(), father.getName().getString()));
        FamilyTree tree = FamilyTree.get((ServerLevel)mother.level());
        tree.getOrCreate(mother);
        tree.getOrCreate(father);
        return stack;
    }

    public static boolean hasBeenInvalidated(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponentsMCA.BABY_INVALIDATED, (Object)false);
    }

    private static boolean canGrow(int age) {
        return age >= Config.getServerConfig().babyItemGrowUpTime;
    }

    private static boolean isReadyToGrowUp(ItemStack stack) {
        return BabyItem.canGrow((Integer)stack.getOrDefault(DataComponentsMCA.BABY_AGE, (Object)0));
    }

    public Gender getGender() {
        return this.gender;
    }

    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public boolean onDropped(ItemStack stack, Player player) {
        if (!BabyItem.hasBeenInvalidated(stack)) {
            if (!player.level().isClientSide) {
                int count = (Integer)stack.getOrDefault(DataComponentsMCA.BABY_DROP_ATTEMPTS, (Object)0) + 1;
                stack.set(DataComponentsMCA.BABY_DROP_ATTEMPTS, (Object)count);
                CriterionMCA.BABY_DROPPED.trigger((ServerPlayer)player, count);
                player.displayClientMessage((Component)Component.translatable((String)"item.mca.baby.no_drop"), true);
            }
            return false;
        }
        return true;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.isClientSide) {
            return;
        }
        if (world.getGameTime() % 100L == 0L) {
            stack.set(DataComponentsMCA.BABY_AGE, (Object)((Integer)stack.getOrDefault(DataComponentsMCA.BABY_AGE, (Object)0) + 100));
        }
    }

    public Component getName(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return Component.translatable((String)(this.getDescriptionId(stack) + ".named"), (Object[])new Object[]{stack.get(DataComponents.CUSTOM_NAME)});
        }
        return super.getName(stack);
    }

    public String getDescriptionId(ItemStack stack) {
        if (BabyItem.hasBeenInvalidated(stack)) {
            return super.getDescriptionId(stack) + ".blanket";
        }
        return super.getDescriptionId(stack);
    }

    public final InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!stack.has(DataComponents.CUSTOM_NAME)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Network.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.BABY_NAME), serverPlayer);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!BabyItem.isReadyToGrowUp(stack)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"item.mca.baby.not_ready"), true);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.birthChild(stack, (ServerLevel)world, serverPlayer);
        }
        stack.shrink(1);
        return InteractionResultHolder.success((Object)stack);
    }

    protected VillagerEntityMCA birthChild(ItemStack stack, ServerLevel world, ServerPlayer player) {
        VillagerEntityMCA child = VillagerFactory.newVillager((Level)world).withPosition(player.position()).withGender(this.gender).withAge(-AgeState.getMaxAge()).build();
        CompoundTag savedBaby = ((CustomData)stack.getOrDefault(DataComponentsMCA.BABY_NBT, (Object)CustomData.EMPTY)).copyTag();
        if (!savedBaby.isEmpty()) {
            child.readAdditionalSaveData(savedBaby);
        }
        child.setCustomName((Component)stack.getOrDefault(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Unnamed")));
        WorldUtils.spawnEntity((Level)world, (Mob)child, MobSpawnType.BREEDING);
        FamilyTree tree = FamilyTree.get(world);
        child.getRelationships().getFamilyEntry().removeMother();
        child.getRelationships().getFamilyEntry().removeFather();
        BabyParentsComponent parents = (BabyParentsComponent)stack.get(DataComponentsMCA.BABY_PARENTS);
        if (parents != null) {
            Stream.of(parents.mother(), parents.father()).forEach(uuid -> Optional.ofNullable(world.getEntity(uuid)).map(tree::getOrCreate).or(() -> tree.getOrEmpty((UUID)uuid)).ifPresent(entry -> child.getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)entry)));
            Stream.of(parents.mother(), parents.father()).map(arg_0 -> ((ServerLevel)world).getEntity(arg_0)).filter(Objects::nonNull).filter(e -> e instanceof ServerPlayer).map(ServerPlayer.class::cast).distinct().forEach(ply -> {
                CriterionMCA.FAMILY.trigger((ServerPlayer)ply);
                Memories memories = child.getVillagerBrain().getMemoriesForPlayer((Player)ply);
                memories.setHearts(Config.getInstance().childInitialHearts);
            });
        }
        return child;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        BabyParentsComponent parents;
        Player player = ClientProxy.getClientPlayer();
        int age = (Integer)stack.getOrDefault(DataComponentsMCA.BABY_AGE, (Object)0);
        Component name = (Component)stack.get(DataComponents.CUSTOM_NAME);
        if (name != null) {
            tooltip.add((Component)Component.translatable((String)"item.mca.baby.name", (Object[])new Object[]{name.copy().withColor(this.gender.getColor())}).withStyle(ChatFormatting.GRAY));
            if (age > 0) {
                tooltip.add((Component)Component.translatable((String)"item.mca.baby.age", (Object[])new Object[]{StringUtil.formatTickDuration((int)age, (float)20.0f)}).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"item.mca.baby.give_name").withStyle(ChatFormatting.YELLOW));
        }
        if ((parents = (BabyParentsComponent)stack.get(DataComponentsMCA.BABY_PARENTS)) != null) {
            tooltip.add((Component)Component.translatable((String)"item.mca.baby.mother", (Object[])new Object[]{player != null && parents.mother().equals(player.getUUID()) ? Component.translatable((String)"item.mca.baby.owner.you") : parents.motherName()}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"item.mca.baby.father", (Object[])new Object[]{player != null && parents.father().equals(player.getUUID()) ? Component.translatable((String)"item.mca.baby.owner.you") : parents.fatherName()}).withStyle(ChatFormatting.GRAY));
        }
        if (stack.has(DataComponents.CUSTOM_NAME) && BabyItem.canGrow(age)) {
            tooltip.add((Component)Component.translatable((String)"item.mca.baby.state.ready").withStyle(ChatFormatting.DARK_GREEN));
        }
    }
}

