/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.item;

import java.util.List;
import net.conczin.mca.block.TombstoneBlock;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.DataComponentsMCA;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.registry.SoundsMCA;
import net.conczin.mca.registry.TagsMCA;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ScytheItem
extends SwordItem {
    public ScytheItem(Item.Properties settings) {
        super((Tier)Tiers.GOLD, settings);
    }

    public static void setSoul(ItemStack stack, boolean soul) {
        stack.set(DataComponentsMCA.SCYTHE_HAS_SOUL, (Object)soul);
    }

    public static boolean hasSoul(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponentsMCA.SCYTHE_HAS_SOUL, (Object)false);
    }

    public static InteractionResult use(UseOnContext context, boolean cure) {
        BlockPos pos;
        Level world = context.getLevel();
        BlockState state = world.getBlockState(pos = context.getClickedPos());
        if (state.is(TagsMCA.Blocks.TOMBSTONES)) {
            return TombstoneBlock.Data.of(world.getBlockEntity(pos)).filter(TombstoneBlock.Data::hasEntity).map(data -> {
                if (!context.getLevel().isClientSide) {
                    CriterionMCA.GENERIC_EVENT.trigger((ServerPlayer)context.getPlayer(), cure ? "staffOfLife" : "scytheRevive");
                }
                if (!world.isClientSide && !data.isResurrecting()) {
                    data.startResurrecting(cure);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.FAIL);
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.addAll(FlowingText.wrap((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip")).withStyle(ChatFormatting.GRAY), 160));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        boolean active = (Boolean)stack.getOrDefault(DataComponentsMCA.SCYTHE_ACTIVE, (Object)false);
        RandomSource r = entity.level().random;
        if (active != selected) {
            stack.set(DataComponentsMCA.SCYTHE_ACTIVE, (Object)selected);
            float baseVolume = selected ? 0.75f : 0.25f;
            entity.level().playSound(null, entity.blockPosition(), SoundsMCA.REAPER_SCYTHE_OUT, entity.getSoundSource(), baseVolume + r.nextFloat() / 2.0f, 0.65f + r.nextFloat() / 10.0f);
        }
        if (selected && living.swingTime == -1) {
            entity.level().playSound(null, entity.blockPosition(), SoundsMCA.REAPER_SCYTHE_SWING, entity.getSoundSource(), 0.25f, 1.0f);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.startUsingItem(hand);
        return super.use(world, user, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (ScytheItem.hasSoul(context.getItemInHand())) {
            InteractionResult result = ScytheItem.use(context, false);
            if (result == InteractionResult.SUCCESS) {
                ScytheItem.setSoul(context.getItemInHand(), false);
            }
            if (result != InteractionResult.PASS) {
                return result;
            }
        }
        return super.useOn(context);
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || ScytheItem.hasSoul(stack);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.level().random.nextInt(50) > 40) {
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 1000, 1));
        }
        SoundEvent sound = SoundsMCA.REAPER_SCYTHE_OUT;
        if (!ScytheItem.hasSoul(stack) && target.isDeadOrDying() && (target.getType() == EntitiesMCA.MALE_VILLAGER || target.getType() == EntitiesMCA.FEMALE_VILLAGER)) {
            ScytheItem.setSoul(stack, true);
            sound = SoundEvents.BELL_RESONATE;
            if (attacker instanceof ServerPlayer) {
                CriterionMCA.GENERIC_EVENT.trigger((ServerPlayer)attacker, "scytheKill");
            }
        }
        RandomSource r = attacker.level().random;
        attacker.level().playSound(null, attacker.blockPosition(), sound, attacker.getSoundSource(), 0.75f + r.nextFloat() / 2.0f, 0.75f + r.nextFloat() / 2.0f);
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return stack.getItem() == ingredient.getItem();
    }
}

