/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network;

import net.conczin.mca.Config;
import net.conczin.mca.MCAClient;
import net.conczin.mca.client.book.Book;
import net.conczin.mca.client.book.CivilRegistryBook;
import net.conczin.mca.client.gui.BlueprintScreen;
import net.conczin.mca.client.gui.CombScreen;
import net.conczin.mca.client.gui.ExtendedBookScreen;
import net.conczin.mca.client.gui.FamilyTreeScreen;
import net.conczin.mca.client.gui.FamilyTreeSearchScreen;
import net.conczin.mca.client.gui.InteractScreen;
import net.conczin.mca.client.gui.LimitedVillagerEditorScreen;
import net.conczin.mca.client.gui.NameBabyScreen;
import net.conczin.mca.client.gui.NeedleScreen;
import net.conczin.mca.client.gui.SkinListUpdateListener;
import net.conczin.mca.client.gui.VillagerEditorScreen;
import net.conczin.mca.client.gui.VillagerTrackerSearchScreen;
import net.conczin.mca.client.gui.WhistleScreen;
import net.conczin.mca.client.tts.SpeechManager;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.item.BabyItem;
import net.conczin.mca.item.ExtendedWrittenBookItem;
import net.conczin.mca.network.ClientHandler;
import net.conczin.mca.network.s2c.AnalysisResults;
import net.conczin.mca.network.s2c.BabyNameResponse;
import net.conczin.mca.network.s2c.CivilRegistryResponse;
import net.conczin.mca.network.s2c.ConfigResponse;
import net.conczin.mca.network.s2c.CustomSkinsChangedMessage;
import net.conczin.mca.network.s2c.FamilyTreeUUIDResponse;
import net.conczin.mca.network.s2c.GetFamilyResponse;
import net.conczin.mca.network.s2c.GetFamilyTreeResponse;
import net.conczin.mca.network.s2c.GetInteractDataResponse;
import net.conczin.mca.network.s2c.GetVillageFailedResponse;
import net.conczin.mca.network.s2c.GetVillageResponse;
import net.conczin.mca.network.s2c.GetVillagerResponse;
import net.conczin.mca.network.s2c.InteractionDialogueQuestionResponse;
import net.conczin.mca.network.s2c.InteractionDialogueResponse;
import net.conczin.mca.network.s2c.OpenDestinyGuiRequest;
import net.conczin.mca.network.s2c.OpenGuiRequest;
import net.conczin.mca.network.s2c.PlayerDataMessage;
import net.conczin.mca.network.s2c.ShowToastRequest;
import net.conczin.mca.network.s2c.SkinListResponse;
import net.conczin.mca.network.s2c.VillagerMessage;
import net.conczin.mca.network.s2c.VillagerNameResponse;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.resources.BuildingTypes;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientHandlerImpl
implements ClientHandler {
    private final Minecraft client = Minecraft.getInstance();

    @Override
    public void handleGuiRequest(OpenGuiRequest message) {
        assert (this.client.level != null);
        assert (Minecraft.getInstance().player != null);
        switch (message.getGui()) {
            case WHISTLE: {
                this.client.setScreen((Screen)new WhistleScreen());
                break;
            }
            case BOOK: {
                ItemStack item;
                Item item2;
                if (this.client.player == null || !((item2 = (item = this.client.player.getItemInHand(InteractionHand.MAIN_HAND)).getItem()) instanceof ExtendedWrittenBookItem)) break;
                ExtendedWrittenBookItem bookItem = (ExtendedWrittenBookItem)item2;
                Book book = bookItem.getBook(item);
                this.client.setScreen((Screen)new ExtendedBookScreen(book));
                break;
            }
            case BLUEPRINT: {
                this.client.setScreen((Screen)new BlueprintScreen());
                break;
            }
            case INTERACT: {
                ItemStack item;
                boolean isOnBlacklist;
                if (this.client.player == null || (isOnBlacklist = Config.getInstance().villagerInteractionItemBlacklist.contains(BuiltInRegistries.ITEM.getKey((Object)(item = this.client.player.getItemInHand(InteractionHand.MAIN_HAND)).getItem()).toString()))) break;
                VillagerLike villager = (VillagerLike)this.client.level.getEntity(message.villager());
                this.client.setScreen((Screen)new InteractScreen(villager));
                break;
            }
            case VILLAGER_EDITOR: {
                Entity entity = this.client.level.getEntity(message.villager());
                assert (entity != null);
                this.client.setScreen((Screen)new VillagerEditorScreen(entity.getUUID(), Minecraft.getInstance().player.getUUID()));
                break;
            }
            case LIMITED_VILLAGER_EDITOR: {
                Entity entity = this.client.level.getEntity(message.villager());
                assert (entity != null);
                this.client.setScreen((Screen)new LimitedVillagerEditorScreen(entity.getUUID(), Minecraft.getInstance().player.getUUID()));
                break;
            }
            case NEEDLE_AND_THREAD: {
                Entity entity = this.client.level.getEntity(message.villager());
                if (entity == null) {
                    this.client.setScreen((Screen)new NeedleScreen(Minecraft.getInstance().player.getUUID()));
                    break;
                }
                this.client.setScreen((Screen)new NeedleScreen(entity.getUUID(), Minecraft.getInstance().player.getUUID()));
                break;
            }
            case COMB: {
                Entity entity = this.client.level.getEntity(message.villager());
                if (entity == null) {
                    this.client.setScreen((Screen)new CombScreen(Minecraft.getInstance().player.getUUID()));
                    break;
                }
                this.client.setScreen((Screen)new CombScreen(entity.getUUID(), Minecraft.getInstance().player.getUUID()));
                break;
            }
            case BABY_NAME: {
                ItemStack item;
                if (this.client.player == null || !((item = this.client.player.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof BabyItem)) break;
                this.client.setScreen((Screen)new NameBabyScreen((Player)this.client.player, item));
                break;
            }
            case FAMILY_TREE: {
                this.client.setScreen((Screen)new FamilyTreeSearchScreen());
                break;
            }
            case VILLAGER_TRACKER: {
                this.client.setScreen((Screen)new VillagerTrackerSearchScreen());
                break;
            }
        }
    }

    @Override
    public void handleFamilyTreeResponse(GetFamilyTreeResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof FamilyTreeScreen) {
            FamilyTreeScreen gui = (FamilyTreeScreen)screen;
            gui.setFamilyData(message.uuid(), message.family());
        }
    }

    @Override
    public void handleInteractDataResponse(GetInteractDataResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setConstraints(message.constraints());
            gui.setParents(message.father().orElse(null), message.mother().orElse(null));
            gui.setSpouse(message.marriageState(), message.spouse().orElse(null));
        }
    }

    @Override
    public void handleVillageDataResponse(GetVillageResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            BuildingTypes.getInstance().setBuildingTypes(message.buildingTypes());
            Village village = new Village(message.getData(), null);
            gui.setVillage(village);
            gui.setVillageData(message.rank(), message.reputation(), message.isVillage(), message.ids(), message.tasks());
        }
    }

    @Override
    public void handleVillageDataFailedResponse(GetVillageFailedResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            gui.setVillage(null);
        }
    }

    @Override
    public void handleFamilyDataResponse(GetFamilyResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof WhistleScreen) {
            WhistleScreen gui = (WhistleScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleVillagerDataResponse(GetVillagerResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleDialogueResponse(InteractionDialogueResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setDialogue(message.question(), message.answers());
        }
    }

    @Override
    public void handleDialogueQuestionResponse(InteractionDialogueQuestionResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setLastPhrase(message.questionText(), message.silent());
        }
    }

    @Override
    public void handleSkinListResponse(AnalysisResults message) {
        InteractScreen.setAnalysis(message.analysis());
    }

    @Override
    public void handleBabyNameResponse(BabyNameResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof NameBabyScreen) {
            NameBabyScreen gui = (NameBabyScreen)screen;
            gui.setBabyName(message.name());
        }
    }

    @Override
    public void handleVillagerNameResponse(VillagerNameResponse message) {
        Screen screen = this.client.screen;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerName(message.name());
        }
    }

    @Override
    public void handleToastMessage(ShowToastRequest message) {
        SystemToast.add((ToastComponent)this.client.getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)message.getTitle(), (Component)message.getMessage());
    }

    @Override
    public void handleFamilyTreeUUIDResponse(FamilyTreeUUIDResponse response) {
        Screen screen = this.client.screen;
        if (screen instanceof FamilyTreeSearchScreen) {
            FamilyTreeSearchScreen gui = (FamilyTreeSearchScreen)screen;
            gui.setList(response.list());
        }
    }

    @Override
    public void handlePlayerDataMessage(PlayerDataMessage response) {
        assert (this.client.level != null);
        VillagerEntityMCA villager = (VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.create((Level)this.client.level);
        assert (villager != null);
        villager.readAdditionalSaveData(response.nbt());
        MCAClient.addPlayerData(response.uuid(), villager);
    }

    @Override
    public void handleSkinListResponse(SkinListResponse message) {
        Screen screen = this.client.screen;
        VillagerEditorScreen.setSkinList(message.clothing(), message.hair());
        if (screen instanceof SkinListUpdateListener) {
            SkinListUpdateListener gui = (SkinListUpdateListener)screen;
            gui.skinListUpdatedCallback();
        }
    }

    @Override
    public void handleDestinyGuiRequest(OpenDestinyGuiRequest message) {
        MCAClient.getDestinyManager().requestOpen(message.allowTeleportation());
    }

    @Override
    public void handleConfigResponse(ConfigResponse message) {
        Config.setServerConfig(message.getConfig());
    }

    @Override
    public void handleVillagerMessage(VillagerMessage message) {
        MutableComponent full = message.prefix().copy().append(message.message());
        this.client.getChatListener().handleSystemMessage((Component)full, false);
        SpeechManager.INSTANCE.onChatMessage(message.message(), message.uuid());
    }

    @Override
    public void handleCustomSkinsChangedMessage(CustomSkinsChangedMessage message) {
        VillagerEditorScreen.setSkinListOutdated();
    }

    @Override
    public void handleCivilRegistryResponse(CivilRegistryResponse response) {
        ExtendedBookScreen extendedBookScreen;
        Book book;
        Screen screen = this.client.screen;
        if (screen instanceof ExtendedBookScreen && (book = (extendedBookScreen = (ExtendedBookScreen)screen).getBook()) instanceof CivilRegistryBook) {
            CivilRegistryBook civilRegistryBook = (CivilRegistryBook)book;
            civilRegistryBook.receive(response.getIndex(), response.getLines());
        }
    }
}

