/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.Locale;
import java.util.Optional;
import net.conczin.mca.MCA;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.server.world.data.Building;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.server.world.data.VillageManager;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public record ReportBuildingMessage(Action action, String data) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<ReportBuildingMessage> TYPE = new CustomPacketPayload.Type(MCA.locate("report_building"));
    public static final StreamCodec<FriendlyByteBuf, ReportBuildingMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper(i -> Action.values()[i], Enum::ordinal), ReportBuildingMessage::action, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8).map(o -> o.orElse(null), o -> o == null ? Optional.empty() : Optional.of(o)), ReportBuildingMessage::data, ReportBuildingMessage::new);

    public ReportBuildingMessage(Action action) {
        this(action, null);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        VillageManager villages = VillageManager.get(player.serverLevel());
        switch (this.action.ordinal()) {
            case 1: 
            case 2: {
                Building.validationResult result = villages.processBuilding(player.blockPosition(), true, this.action == Action.ADD_ROOM);
                player.displayClientMessage((Component)Component.translatable((String)("blueprint.scan." + result.name().toLowerCase(Locale.ENGLISH))), true);
                break;
            }
            case 0: {
                villages.findNearestVillage((Entity)player).ifPresent(Village::toggleAutoScan);
                break;
            }
            case 5: {
                villages.findNearestVillage((Entity)player).ifPresent(buildings -> buildings.getBuildings().values().stream().toList().forEach(b -> villages.processBuilding(b.getCenter(), true, b.isStrictScan())));
                break;
            }
            case 3: 
            case 4: {
                Optional<Village> village = villages.findNearestVillage((Entity)player);
                Optional building = village.flatMap(v -> v.getBuildings().values().stream().filter(b -> b.containsPos((Vec3i)player.blockPosition())).filter(b -> this.action != Action.FORCE_TYPE || !b.getBuildingType().grouped()).findAny());
                building.ifPresentOrElse(b -> {
                    if (this.action == Action.FORCE_TYPE) {
                        if (b.getType().equals(this.data)) {
                            b.setTypeForced(false);
                            b.determineType();
                        } else {
                            b.setTypeForced(true);
                            b.setType(this.data);
                        }
                    } else {
                        ((Village)village.get()).removeBuilding(b.getId());
                    }
                }, () -> player.displayClientMessage((Component)Component.translatable((String)"blueprint.noBuilding"), true));
            }
        }
    }

    public CustomPacketPayload.Type<ReportBuildingMessage> type() {
        return TYPE;
    }

    public static enum Action {
        AUTO_SCAN,
        ADD_ROOM,
        ADD,
        REMOVE,
        FORCE_TYPE,
        FULL_SCAN;

    }
}

