/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.GetVillagerRequest;
import net.conczin.mca.network.s2c.PlayerDataMessage;
import net.conczin.mca.resources.ClothingList;
import net.conczin.mca.resources.HairList;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;

public record VillagerEditorSyncRequest(String command, UUID uuid, CompoundTag data) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<VillagerEditorSyncRequest> TYPE = new CustomPacketPayload.Type(MCA.locate("villager_editor_sync_request"));
    public static final StreamCodec<FriendlyByteBuf, VillagerEditorSyncRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, VillagerEditorSyncRequest::command, (StreamCodec)UUIDUtil.STREAM_CODEC, VillagerEditorSyncRequest::uuid, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, VillagerEditorSyncRequest::data, VillagerEditorSyncRequest::new);

    @Override
    public void handleServer(ServerPlayer player) {
        Entity entity = player.serverLevel().getEntity(this.uuid);
        switch (this.command) {
            case "hair": {
                this.setHair(player, entity);
                break;
            }
            case "clothing": {
                this.setClothing(player, entity);
                break;
            }
            case "gender": {
                this.setHair(player, entity);
                this.setClothing(player, entity);
                break;
            }
            case "sync": {
                this.saveEntity(player, entity, this.data());
                break;
            }
            case "profession": {
                if (!(entity instanceof VillagerEntityMCA)) break;
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                VillagerProfession profession = (VillagerProfession)BuiltInRegistries.VILLAGER_PROFESSION.get(ResourceLocation.parse((String)this.data.getString("profession")));
                villager.setProfession(profession);
            }
        }
    }

    private void setHair(ServerPlayer player, Entity entity) {
        CompoundTag villagerData = GetVillagerRequest.getVillagerData(entity);
        if (villagerData != null) {
            String hair = this.data.contains("offset") ? HairList.getInstance().getPool(this.getGender(villagerData)).pickNext(villagerData.getString("Hair"), this.data.getInt("offset")) : HairList.getInstance().getPool(this.getGender(villagerData)).pickOne();
            villagerData.putString("Hair", hair);
            this.saveEntity(player, entity, villagerData);
        }
    }

    private void setClothing(ServerPlayer player, Entity entity) {
        CompoundTag villagerData = GetVillagerRequest.getVillagerData(entity);
        if (villagerData != null) {
            String clothes = "mca:missing";
            if (entity instanceof Player) {
                clothes = this.data.contains("offset") ? ClothingList.getInstance().getPool(this.getGender(villagerData), VillagerProfession.NONE).pickNext(villagerData.getString("Clothes"), this.data.getInt("offset")) : ClothingList.getInstance().getPool(this.getGender(villagerData), VillagerProfession.NONE).pickOne();
            } else if (entity instanceof VillagerLike) {
                VillagerLike villager = (VillagerLike)entity;
                clothes = this.data.contains("offset") ? ClothingList.getInstance().getPool(villager).pickNext(villager.getClothes(), this.data.getInt("offset")) : ClothingList.getInstance().getPool(villager).pickOne();
            }
            villagerData.putString("Clothes", clothes);
            this.saveEntity(player, entity, villagerData);
        }
    }

    private void saveEntity(ServerPlayer player, Entity entity, CompoundTag villagerData) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PlayerSaveData data = PlayerSaveData.get(serverPlayer);
            data.setEntityData(villagerData);
            data.setEntityDataSet(true);
            this.syncFamilyTree(player, entity, villagerData);
            serverPlayer.serverLevel().players().forEach(p -> Network.sendToPlayer(new PlayerDataMessage(player.getUUID(), villagerData), p));
        } else if (entity instanceof VillagerLike) {
            VillagerLike villagerLike = (VillagerLike)entity;
            villagerLike.syncFromEditor(villagerData);
            entity.refreshDimensions();
            this.syncFamilyTree(player, entity, villagerData);
            if (entity instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.getResidency().getHomeVillage().ifPresent(b -> b.updateResident(villager));
            }
        }
    }

    private Gender getGender(CompoundTag villagerData) {
        return Gender.byId(villagerData.getInt("gender"));
    }

    private Optional<FamilyTreeNode> getFamilyNode(ServerPlayer player, FamilyTree tree, String name, Gender gender) {
        try {
            UUID uuid = UUID.fromString(name);
            Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
            if (node.isPresent()) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.villager_editor.uuid_known", (Object[])new Object[]{name, node.get().getName()}), true);
                return node;
            }
            player.displayClientMessage((Component)Component.translatable((String)"gui.villager_editor.uuid_unknown", (Object[])new Object[]{name}).withStyle(ChatFormatting.RED), true);
            return Optional.empty();
        }
        catch (IllegalArgumentException exception) {
            List<FamilyTreeNode> nodes = tree.getAllWithName(name).toList();
            if (nodes.isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.villager_editor.name_created", (Object[])new Object[]{name}).withStyle(ChatFormatting.YELLOW), true);
                return Optional.of(tree.getOrCreate(UUID.randomUUID(), name, gender));
            }
            if (nodes.size() > 1) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.villager_editor.name_not_unique", (Object[])new Object[]{name}).withStyle(ChatFormatting.RED), true);
                String uuids = nodes.stream().map(FamilyTreeNode::id).map(UUID::toString).collect(Collectors.joining(", "));
                player.displayClientMessage((Component)Component.translatable((String)"gui.villager_editor.list_of_ids", (Object[])new Object[]{uuids}), false);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.villager_editor.name_unique", (Object[])new Object[]{name}), true);
            }
            return Optional.ofNullable(nodes.getFirst());
        }
    }

    private void syncFamilyTree(ServerPlayer player, Entity entity, CompoundTag villagerData) {
        String name;
        FamilyTree tree = FamilyTree.get((ServerLevel)entity.level());
        FamilyTreeNode entry = tree.getOrCreate(entity);
        entry.setGender(this.getGender(this.data));
        String s = villagerData.getString("CustomName");
        try {
            entry.setName(Objects.requireNonNull(Component.Serializer.fromJson((String)s, (HolderLookup.Provider)entity.registryAccess())).getString());
        }
        catch (Exception e) {
            MCA.LOGGER.error("Failed to parse custom name for villager: {}", (Object)s, (Object)e);
        }
        if (villagerData.contains("FamilyTreeNewFatherName")) {
            name = villagerData.getString("FamilyTreeNewFatherName");
            if (MCA.isBlankString(name)) {
                entry.removeFather();
            } else {
                this.getFamilyNode(player, tree, name, Gender.MALE).ifPresent(entry::setFather);
            }
        }
        if (villagerData.contains("FamilyTreeNewMotherName")) {
            name = villagerData.getString("FamilyTreeNewMotherName");
            if (MCA.isBlankString(name)) {
                entry.removeMother();
            } else {
                this.getFamilyNode(player, tree, name, Gender.FEMALE).ifPresent(entry::setMother);
            }
        }
        if (villagerData.contains("FamilyTreeNewSpouseName")) {
            name = villagerData.getString("FamilyTreeNewSpouseName");
            if (MCA.isBlankString(name)) {
                Optional.of(entry.partner()).flatMap(tree::getOrEmpty).ifPresent(node -> node.updatePartner(null, null));
                entry.updatePartner(null, null);
            } else {
                this.getFamilyNode(player, tree, name, entry.gender().opposite()).ifPresent(node -> {
                    entry.updatePartner((FamilyTreeNode)node);
                    node.updatePartner(entry);
                });
            }
        }
    }

    public CustomPacketPayload.Type<VillagerEditorSyncRequest> type() {
        return TYPE;
    }
}

