/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data.dialogue;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.LongTermMemory;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.InteractionDialogueQuestionResponse;
import net.conczin.mca.network.s2c.InteractionDialogueResponse;
import net.conczin.mca.resources.Dialogues;
import net.conczin.mca.resources.data.dialogue.Question;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class Actions {
    public static final Map<String, Factory<JsonElement>> TYPES = new HashMap<String, Factory<JsonElement>>();
    private final List<Action> actions;
    private final boolean positive;
    private final boolean negative;

    public Actions(List<Action> actions, boolean positive, boolean negative) {
        this.actions = actions;
        this.positive = positive;
        this.negative = negative;
    }

    public static <T> void register(String name, BiFunction<JsonElement, String, T> jsonParser, Factory<T> predicate) {
        TYPES.put(name, json -> predicate.parse(jsonParser.apply((JsonElement)json, name)));
    }

    public static Actions fromJson(JsonObject json) {
        LinkedList<Action> actions = new LinkedList<Action>();
        boolean positive = false;
        boolean negative = false;
        for (Map.Entry entry : json.entrySet()) {
            if (TYPES.containsKey(entry.getKey())) {
                Action parsed = TYPES.get(entry.getKey()).parse((JsonElement)entry.getValue());
                actions.add(parsed);
                if (((String)entry.getKey()).equals("positive")) {
                    positive = true;
                }
                if (!((String)entry.getKey()).equals("negative")) continue;
                negative = true;
                continue;
            }
            MCA.LOGGER.info("Unknown dialogue action {}", entry.getKey());
        }
        if (!json.has("next")) {
            Action parsed = TYPES.get("quit").parse((JsonElement)json);
            actions.add(parsed);
        }
        return new Actions(actions, positive, negative);
    }

    public void trigger(VillagerEntityMCA villager, ServerPlayer player) {
        for (Action c : this.actions) {
            c.trigger(villager, player);
        }
    }

    public boolean isPositive() {
        return this.positive;
    }

    public boolean isNegative() {
        return this.negative;
    }

    static {
        Actions.register("next", GsonHelper::convertToString, id -> (villager, player) -> {
            if (id != null) {
                Question newQuestion = Dialogues.getInstance().getQuestion((String)id);
                if (newQuestion != null) {
                    if (newQuestion.isAuto()) {
                        Dialogues.getInstance().selectAnswer(villager, player, newQuestion.getName(), newQuestion.getRandomAnswer().getName());
                        return;
                    }
                    MutableComponent text = villager.getTranslatable((Player)player, Question.getTranslationKey(id), new Object[0]);
                    Network.sendToPlayer(new InteractionDialogueResponse(newQuestion, player, villager), player);
                    Network.sendToPlayer(new InteractionDialogueQuestionResponse((Component)text, newQuestion.isSilent()), player);
                } else {
                    villager.sendChatMessage((Player)player, Question.getTranslationKey(id), new Object[0]);
                }
                if (newQuestion == null || newQuestion.isCloseScreen()) {
                    villager.getInteractions().stopInteracting();
                }
            } else {
                villager.getInteractions().stopInteracting();
            }
        });
        Actions.register("say", GsonHelper::convertToString, id -> (villager, player) -> {
            MutableComponent text = villager.getTranslatable((Player)player, Question.getTranslationKey(id), new Object[0]);
            Network.sendToPlayer(new InteractionDialogueQuestionResponse((Component)text, false), player);
        });
        Actions.register("remember", GsonHelper::convertToJsonObject, json -> (villager, player) -> {
            String id = LongTermMemory.parseId(json, player);
            if (json.has("time")) {
                villager.getLongTermMemory().remember(id, json.get("time").getAsLong());
            } else {
                villager.getLongTermMemory().remember(id);
            }
        });
        Actions.register("quit", (a, b) -> a, id -> (villager, player) -> villager.getInteractions().stopInteracting());
        Actions.register("negative", GsonHelper::convertToInt, hearts -> (villager, player) -> {
            villager.getVillagerBrain().modifyMoodValue(-hearts.intValue());
            villager.getVillagerBrain().rewardHearts(player, -hearts.intValue());
        });
        Actions.register("positive", GsonHelper::convertToInt, hearts -> (villager, player) -> {
            villager.getVillagerBrain().modifyMoodValue((int)hearts);
            villager.getVillagerBrain().rewardHearts(player, (int)hearts);
        });
        Actions.register("command", GsonHelper::convertToString, command -> (villager, player) -> villager.getInteractions().handle(player, (String)command));
    }

    public static interface Factory<T> {
        public Action parse(T var1);
    }

    public static interface Action {
        public void trigger(VillagerEntityMCA var1, ServerPlayer var2);
    }
}

