/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data.tasks;

import com.google.gson.JsonObject;
import net.conczin.mca.resources.data.tasks.Task;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class PopulationTask
extends Task {
    public static final String TYPE = "population";
    private final int population;

    public PopulationTask(int population) {
        super("population_" + population);
        this.population = population;
    }

    public PopulationTask(JsonObject json) {
        this(GsonHelper.getAsInt((JsonObject)json, (String)TYPE));
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE);
        json.addProperty(TYPE, (Number)this.population);
        return json;
    }

    @Override
    public boolean isCompleted(Village village, ServerPlayer player) {
        return village.getPopulation() >= this.population;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public MutableComponent getTranslatable() {
        return Component.translatable((String)"task.population", (Object[])new Object[]{this.population});
    }
}

