/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.resources.BuildingTypes;
import net.conczin.mca.resources.data.BuildingType;
import net.conczin.mca.server.ReaperSpawner;
import net.conczin.mca.server.SpawnQueue;
import net.conczin.mca.server.world.data.Building;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;

public class VillageManager
extends SavedData
implements Iterable<Village> {
    public final Set<BlockPos> cache = ConcurrentHashMap.newKeySet();
    private final Map<Integer, Village> villages = new HashMap<Integer, Village>();
    private final List<BlockPos> buildingQueue = new LinkedList<BlockPos>();
    private final ServerLevel world;
    private final ReaperSpawner reapers;
    private int lastBuildingId;
    private int lastVillageId;
    private int buildingCooldown = 21;

    VillageManager(ServerLevel world) {
        this.world = world;
        this.reapers = new ReaperSpawner(this);
    }

    VillageManager(ServerLevel world, CompoundTag nbt) {
        this.world = world;
        this.lastBuildingId = nbt.getInt("lastBuildingId");
        this.lastVillageId = nbt.getInt("lastVillageId");
        this.reapers = nbt.contains("reapers", 10) ? new ReaperSpawner(this, nbt.getCompound("reapers")) : new ReaperSpawner(this);
        ListTag villageList = nbt.getList("villages", 10);
        for (int i = 0; i < villageList.size(); ++i) {
            Village village = new Village(villageList.getCompound(i), world);
            if (village.getBuildings().isEmpty()) {
                MCA.LOGGER.warn("Empty village detected ({}), removing...", (Object)village.getName());
                this.setDirty();
                continue;
            }
            this.villages.put(village.getId(), village);
        }
    }

    public static VillageManager get(ServerLevel world) {
        return WorldUtils.loadData(world, (nbt, provider) -> new VillageManager(world, (CompoundTag)nbt), VillageManager::new, "mca_villages");
    }

    public ReaperSpawner getReaperSpawner() {
        return this.reapers;
    }

    public Optional<Village> getOrEmpty(int id) {
        return Optional.ofNullable(this.villages.get(id));
    }

    public boolean removeVillage(int id) {
        if (this.villages.remove(id) != null) {
            this.cache.clear();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Village> iterator() {
        return this.villages.values().iterator();
    }

    public Stream<Village> findVillages(Predicate<Village> predicate) {
        return this.villages.values().stream().filter(predicate);
    }

    public Optional<Village> findNearestVillage(Entity entity) {
        BlockPos p = entity.blockPosition();
        return this.findVillages(v -> v.isWithinBorder(entity)).min((a, b) -> (int)(a.getCenter().distSqr((Vec3i)p) - b.getCenter().distSqr((Vec3i)p)));
    }

    public Optional<Village> findNearestVillage(BlockPos p, int margin) {
        return this.findVillages(v -> v.isWithinBorder(p, margin)).min((a, b) -> (int)(a.getCenter().distSqr((Vec3i)p) - b.getCenter().distSqr((Vec3i)p)));
    }

    public boolean isWithinHorizontalBoundaries(BlockPos p) {
        return this.villages.values().stream().anyMatch(v -> v.getBox().expand(0, 1000, 0).isInside((Vec3i)p));
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("lastBuildingId", this.lastBuildingId);
        nbt.putInt("lastVillageId", this.lastVillageId);
        nbt.put("villages", (Tag)NbtHelper.fromList(this.villages.values(), Village::save));
        nbt.put("reapers", (Tag)this.reapers.writeNbt());
        return nbt;
    }

    public void tick() {
        if (this.world.getDayTime() % 100L == 0L) {
            this.world.players().forEach(player -> PlayerSaveData.get(player).updateLastSeenVillage(this, (ServerPlayer)player));
        }
        if (this.world.getDayTime() % (long)(Config.getInstance().bountyHunterInterval / 10) == 0L && this.world.getDifficulty() != Difficulty.PEACEFUL) {
            this.world.players().forEach(player -> {
                if (this.world.random.nextInt(10) == 0 && !this.isWithinHorizontalBoundaries(player.blockPosition()) && !player.isCreative()) {
                    this.villages.values().stream().filter(v -> v.getPopulation() >= 3).filter(v -> v.getReputation((Player)player) < Config.getInstance().bountyHunterHearts).min(Comparator.comparingInt(v -> v.getReputation((Player)player))).ifPresent(buildings -> this.startBountyHunterWave((ServerPlayer)player, (Village)buildings));
                }
            });
        }
        long time = this.world.getGameTime();
        for (Village v : this) {
            v.tick(this.world, time);
        }
        if (time % (long)this.buildingCooldown == 0L && !this.buildingQueue.isEmpty()) {
            this.processBuilding(this.buildingQueue.removeFirst());
        }
        this.reapers.tick(this.world);
        SpawnQueue.getInstance().tick();
    }

    private void startBountyHunterWave(ServerPlayer player, Village sender) {
        int heartsPerHunter = 100;
        int count = Math.min(15, -sender.getReputation((Player)player) / heartsPerHunter + 2);
        if (sender.getPopulation() == 0) {
            sender.cleanReputation();
            count *= 2;
        } else {
            sender.pushHearts((Player)player, count * heartsPerHunter / 2);
        }
        CriterionMCA.GENERIC_EVENT.trigger(player, "bounty_hunter");
        for (int c = 0; c < count; ++c) {
            if (this.world.random.nextBoolean()) {
                this.spawnBountyHunter(EntityType.PILLAGER, player);
                continue;
            }
            this.spawnBountyHunter(EntityType.VINDICATOR, player);
        }
        player.displayClientMessage((Component)Component.translatable((String)(sender.getPopulation() == 0 ? "events.bountyHuntersFinal" : "events.bountyHunters"), (Object[])new Object[]{sender.getName()}).withStyle(ChatFormatting.RED), false);
        sender.getCivilRegistry().ifPresent(r -> r.addText((Component)Component.translatable((String)"civil_registry.bounty_hunters", (Object[])new Object[]{player.getName()})));
    }

    private <T extends AbstractIllager> void spawnBountyHunter(EntityType<T> t, ServerPlayer player) {
        AbstractIllager pillager = (AbstractIllager)t.create((Level)this.world);
        if (pillager != null) {
            for (int attempt = 0; attempt < 32; ++attempt) {
                int z;
                int y;
                float f = this.world.random.nextFloat() * ((float)Math.PI * 2);
                int x = (int)(player.getX() + (double)(Mth.cos((float)f) * 32.0f));
                BlockPos pos = new BlockPos(x, y = this.world.getHeight(Heightmap.Types.WORLD_SURFACE, x, z = (int)(player.getZ() + (double)(Mth.sin((float)f) * 32.0f))), z);
                if (!SpawnPlacements.isSpawnPositionOk(t, (LevelReader)this.world, (BlockPos)pos)) continue;
                pillager.setPos((double)x, (double)y, (double)z);
                pillager.setTarget((LivingEntity)player);
                WorldUtils.spawnEntity((Level)this.world, (Mob)pillager, MobSpawnType.EVENT);
                break;
            }
        }
    }

    public void reportBuilding(BlockPos pos) {
        this.cache.add(pos);
        this.buildingQueue.add(pos);
    }

    public Building.validationResult processBuilding(BlockPos pos) {
        return this.processBuilding(pos, false, true);
    }

    private BuildingType getGroupedBuildingType(BlockPos pos) {
        Block block = this.world.getBlockState(pos).getBlock();
        for (BuildingType bt : BuildingTypes.getInstance()) {
            if (!bt.grouped() || !bt.getBlockToGroup().containsKey(BuiltInRegistries.BLOCK.getKey((Object)block))) continue;
            return bt;
        }
        return null;
    }

    private Set<BlockPos> getBlockedSet(Village village) {
        return village.getBuildings().values().stream().filter(b -> !b.getBuildingType().grouped()).map(Building::getSourceBlock).collect(Collectors.toSet());
    }

    public Building.validationResult processBuilding(BlockPos pos, boolean enforce, boolean strictScan) {
        Village village;
        Optional<Village> optionalVillage = this.findNearestVillage(pos, 64);
        BuildingType groupedBuildingType = this.getGroupedBuildingType(pos);
        HashSet<BlockPos> blocked = new HashSet();
        boolean found = false;
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        if (optionalVillage.isPresent()) {
            Iterator name;
            village = optionalVillage.get();
            blocked = this.getBlockedSet(village);
            if (groupedBuildingType != null) {
                name = groupedBuildingType.name();
                double range = groupedBuildingType.mergeRange() * groupedBuildingType.mergeRange();
                Optional<Building> building = village.getBuildings().values().stream().filter(b -> b.getType().equals(name)).min((a, b) -> (int)(a.getCenter().distSqr((Vec3i)pos) - b.getCenter().distSqr((Vec3i)pos))).filter(b -> b.getCenter().distSqr((Vec3i)pos) < range);
                if (building.isPresent()) {
                    found = true;
                    building.get().addPOI((Level)this.world, pos);
                    this.setDirty();
                }
            } else {
                for (Building b2 : village.getBuildings().values()) {
                    if (!b2.containsPos((Vec3i)pos)) continue;
                    if (!enforce) {
                        found = true;
                    }
                    if (!enforce && this.world.getGameTime() - b2.getLastScan() <= 4800L || b2.validateBuilding((Level)this.world, blocked) == Building.validationResult.SUCCESS) continue;
                    toRemove.add(b2.getId());
                }
            }
            name = toRemove.iterator();
            while (name.hasNext()) {
                int id = (Integer)name.next();
                village.removeBuilding(id);
                this.setDirty();
            }
            if (village.getBuildings().isEmpty()) {
                this.villages.remove(village.getId());
                optionalVillage = Optional.empty();
                this.setDirty();
            }
        }
        if (!found && !blocked.contains(pos)) {
            village = optionalVillage.orElse(new Village(this.lastVillageId++, this.world));
            Building building = new Building(pos, strictScan);
            if (groupedBuildingType != null) {
                building.setType(groupedBuildingType.name());
                building.addPOI((Level)this.world, pos);
            } else {
                Building.validationResult result = building.validateBuilding((Level)this.world, blocked);
                if (result == Building.validationResult.SUCCESS) {
                    if (village.getBuildings().values().stream().anyMatch(b -> b.isIdentical(building))) {
                        return Building.validationResult.IDENTICAL;
                    }
                } else {
                    return result;
                }
            }
            this.villages.put(village.getId(), village);
            building.setId(this.lastBuildingId++);
            village.getBuildings().put(building.getId(), building);
            village.calculateDimensions();
            this.villages.values().stream().filter(v -> v != village).filter(v -> v.getBox().inflatedBy(64).intersects((BoundingBox)village.getBox())).findAny().ifPresent(v -> {
                if (v.getPopulation() > village.getPopulation()) {
                    this.merge((Village)v, village);
                    this.villages.remove(village.getId());
                } else {
                    this.merge(village, (Village)v);
                    this.villages.remove(v.getId());
                }
            });
            this.setDirty();
        }
        return Building.validationResult.SUCCESS;
    }

    public void setBuildingCooldown(int buildingCooldown) {
        this.buildingCooldown = buildingCooldown;
    }

    public void merge(Village into, Village from) {
        into.merge(from);
    }
}

