/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data.villageComponents;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class VillageMarriageManager {
    private final Village village;

    public VillageMarriageManager(Village village) {
        this.village = village;
    }

    public void marry(ServerLevel world) {
        if (world.random.nextFloat() >= Config.getInstance().marriageChancePerMinute) {
            return;
        }
        List<VillagerEntityMCA> allVillagers = this.village.getResidents(world);
        List availableVillagers = allVillagers.stream().filter(v -> !v.isBaby()).filter(v -> !v.getRelationships().isMarried()).filter(v -> !v.getRelationships().isEngaged()).filter(v -> !v.getRelationships().isPromised()).collect(Collectors.toList());
        if (availableVillagers.size() <= 1 || (double)availableVillagers.size() <= (double)allVillagers.size() * (1.0 - (double)this.village.getMarriageThreshold())) {
            return;
        }
        availableVillagers.sort(Comparator.comparingInt(a -> a.getVillagerBrain().getMemories().values().stream().map(Memories::getHearts).max(Integer::compare).orElse(0)));
        VillagerEntityMCA suitor = (VillagerEntityMCA)availableVillagers.removeFirst();
        availableVillagers.stream().filter(suitor::canBeAttractedTo).filter(i -> !suitor.getRelationships().getFamilyEntry().isRelative(i.getUUID())).findFirst().ifPresent(mate -> {
            suitor.getRelationships().marry((Entity)mate);
            mate.getRelationships().marry((Entity)suitor);
            if (Config.getInstance().villagerMarriageNotification) {
                this.village.broadCastMessage(world, "events.marry", suitor, (VillagerEntityMCA)mate);
            }
            this.village.getCivilRegistry().ifPresent(r -> r.addText((Component)Component.translatable((String)"events.marry", (Object[])new Object[]{suitor.getName(), mate.getName()})));
        });
    }
}

