/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.util;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface WorldUtils {
    public static List<Entity> getCloseEntities(Level world, Entity e, double range) {
        Vec3 pos = e.position();
        return world.getEntities(e, new AABB(pos, pos).inflate(range));
    }

    public static <T extends Entity> List<T> getCloseEntities(Level world, Entity e, double range, Class<T> c) {
        return WorldUtils.getCloseEntities(world, e.position(), range, c);
    }

    public static <T extends Entity> List<T> getCloseEntities(Level world, Vec3 pos, double range, Class<T> c) {
        return world.getEntitiesOfClass(c, new AABB(pos, pos).inflate(range));
    }

    public static <T extends SavedData> T loadData(ServerLevel world, BiFunction<CompoundTag, HolderLookup.Provider, T> loader, Function<ServerLevel, T> factory, String dataId) {
        return (T)world.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> (SavedData)factory.apply(world), loader, null), dataId);
    }

    public static void spawnEntity(Level world, Mob entity, MobSpawnType reason) {
        entity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(entity.blockPosition()), reason, null);
        world.addFreshEntity((Entity)entity);
    }

    public static Optional<BlockPos> getClosestStructurePosition(ServerLevel world, BlockPos center, ResourceLocation structure, int radius) {
        Structure feature;
        Registry registry = world.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Optional entry = registry.getHolder(registry.getId((Object)(feature = (Structure)registry.get(structure))));
        if (entry.isPresent()) {
            HolderSet.Direct of = HolderSet.direct((Holder[])new Holder[]{(Holder)entry.get()});
            Pair pair = world.getChunkSource().getGenerator().findNearestMapStructure(world, (HolderSet)of, center, radius, false);
            return pair == null ? Optional.empty() : Optional.ofNullable((BlockPos)pair.getFirst());
        }
        return Optional.empty();
    }

    public static Optional<BlockPos> getClosestStructurePosition(ServerLevel world, BlockPos center, TagKey<Structure> tag, int radius) {
        Registry registry = world.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Optional entryList = registry.getTag(tag);
        if (entryList.isPresent()) {
            ChunkGenerator chunkGenerator = world.getChunkSource().getGenerator();
            Pair pair = chunkGenerator.findNearestMapStructure(world, (HolderSet)entryList.get(), center, radius, false);
            return pair == null ? Optional.empty() : Optional.ofNullable((BlockPos)pair.getFirst());
        }
        return Optional.empty();
    }

    public static boolean isChunkLoaded(ServerLevel world, Vec3i pos) {
        return WorldUtils.isChunkLoaded(world, new BlockPos(pos));
    }

    public static boolean isChunkLoaded(ServerLevel world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk worldChunk = world.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
        if (worldChunk != null) {
            return worldChunk.getFullStatus() == FullChunkStatus.ENTITY_TICKING && world.areEntitiesLoaded(chunkPos.toLong());
        }
        return false;
    }

    public static boolean isAreaLoaded(ServerLevel world, ChunkPos pos, int radius) {
        ServerChunkCache chunkManager = world.getChunkSource();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (chunkManager.hasChunk(pos.x + x, pos.z + z)) continue;
                return false;
            }
        }
        return true;
    }
}

