/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.util.recipes;

import net.conczin.mca.entity.CribWoodType;
import net.conczin.mca.registry.ItemsMCA;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class CribRecipeProvider {
    public static void generate(RecipeOutput recipeOutput) {
        for (CribWoodType wood : CribWoodType.values()) {
            for (DyeColor color : DyeColor.values()) {
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemsMCA.CRIBS.stream().filter(c -> c.getColor() == color && c.getWood() == wood).findFirst().get()), (int)1).define(Character.valueOf('F'), CribRecipeProvider.fenceFromWoodType(wood)).define(Character.valueOf('P'), CribRecipeProvider.plankFromWoodType(wood)).define(Character.valueOf('C'), CribRecipeProvider.carpetFromColor(color)).pattern("F F").pattern("FCF").pattern("PPP").save(recipeOutput);
            }
        }
    }

    private static ItemLike plankFromWoodType(CribWoodType woodType) {
        return switch (woodType) {
            case CribWoodType.SPRUCE -> Blocks.SPRUCE_PLANKS;
            case CribWoodType.ACACIA -> Blocks.ACACIA_PLANKS;
            case CribWoodType.BIRCH -> Blocks.BIRCH_PLANKS;
            case CribWoodType.CHERRY -> Blocks.CHERRY_PLANKS;
            case CribWoodType.CRIMSON -> Blocks.CRIMSON_PLANKS;
            case CribWoodType.DARK_OAK -> Blocks.DARK_OAK_PLANKS;
            case CribWoodType.JUNGLE -> Blocks.JUNGLE_PLANKS;
            case CribWoodType.MANGROVE -> Blocks.MANGROVE_PLANKS;
            case CribWoodType.WARPED -> Blocks.WARPED_PLANKS;
            default -> Blocks.OAK_PLANKS;
        };
    }

    private static ItemLike fenceFromWoodType(CribWoodType woodType) {
        return switch (woodType) {
            case CribWoodType.SPRUCE -> Blocks.SPRUCE_FENCE;
            case CribWoodType.ACACIA -> Blocks.ACACIA_FENCE;
            case CribWoodType.BIRCH -> Blocks.BIRCH_FENCE;
            case CribWoodType.CHERRY -> Blocks.CHERRY_FENCE;
            case CribWoodType.CRIMSON -> Blocks.CRIMSON_FENCE;
            case CribWoodType.DARK_OAK -> Blocks.DARK_OAK_FENCE;
            case CribWoodType.JUNGLE -> Blocks.JUNGLE_FENCE;
            case CribWoodType.MANGROVE -> Blocks.MANGROVE_FENCE;
            case CribWoodType.WARPED -> Blocks.WARPED_FENCE;
            default -> Blocks.OAK_FENCE;
        };
    }

    private static ItemLike carpetFromColor(DyeColor color) {
        return switch (color) {
            case DyeColor.WHITE -> Blocks.WHITE_CARPET;
            case DyeColor.ORANGE -> Blocks.ORANGE_CARPET;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_CARPET;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_CARPET;
            case DyeColor.YELLOW -> Blocks.YELLOW_CARPET;
            case DyeColor.LIME -> Blocks.LIME_CARPET;
            case DyeColor.PINK -> Blocks.PINK_CARPET;
            case DyeColor.GRAY -> Blocks.GRAY_CARPET;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_CARPET;
            case DyeColor.CYAN -> Blocks.CYAN_CARPET;
            case DyeColor.PURPLE -> Blocks.PURPLE_CARPET;
            case DyeColor.BLUE -> Blocks.BLUE_CARPET;
            case DyeColor.BROWN -> Blocks.BROWN_CARPET;
            case DyeColor.GREEN -> Blocks.GREEN_CARPET;
            case DyeColor.BLACK -> Blocks.BLACK_CARPET;
            default -> Blocks.RED_CARPET;
        };
    }
}

