/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import fabric.net.mca.Config;
import fabric.net.mca.ProfessionsMCA;
import fabric.net.mca.entity.EntitiesMCA;
import fabric.net.mca.entity.EquipmentSet;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.ActivityMCA;
import fabric.net.mca.entity.ai.MemoryModuleTypeMCA;
import fabric.net.mca.entity.ai.SchedulesMCA;
import fabric.net.mca.entity.ai.brain.tasks.BowTask;
import fabric.net.mca.entity.ai.brain.tasks.ConditionalSingleTickTask;
import fabric.net.mca.entity.ai.brain.tasks.ConditionalTask;
import fabric.net.mca.entity.ai.brain.tasks.DeliverMessageTask;
import fabric.net.mca.entity.ai.brain.tasks.EnterBuildingTask;
import fabric.net.mca.entity.ai.brain.tasks.EnterFavoredBuildingTask;
import fabric.net.mca.entity.ai.brain.tasks.EquipmentTask;
import fabric.net.mca.entity.ai.brain.tasks.ExtendedFindPointOfInterestTask;
import fabric.net.mca.entity.ai.brain.tasks.ExtendedForgetCompletedPointOfInterestTask;
import fabric.net.mca.entity.ai.brain.tasks.ExtendedMeleeAttackTask;
import fabric.net.mca.entity.ai.brain.tasks.ExtendedWalkTowardsTask;
import fabric.net.mca.entity.ai.brain.tasks.FollowTask;
import fabric.net.mca.entity.ai.brain.tasks.GreetPlayerTask;
import fabric.net.mca.entity.ai.brain.tasks.GrieveTask;
import fabric.net.mca.entity.ai.brain.tasks.HoldItemTask;
import fabric.net.mca.entity.ai.brain.tasks.InteractTask;
import fabric.net.mca.entity.ai.brain.tasks.LambdaTask;
import fabric.net.mca.entity.ai.brain.tasks.LazyFindPointOfInterestTask;
import fabric.net.mca.entity.ai.brain.tasks.LoseUnimportantJobTask;
import fabric.net.mca.entity.ai.brain.tasks.PatrolVillageTask;
import fabric.net.mca.entity.ai.brain.tasks.SayTask;
import fabric.net.mca.entity.ai.brain.tasks.SequenceTask;
import fabric.net.mca.entity.ai.brain.tasks.SmarterOpenDoorsTask;
import fabric.net.mca.entity.ai.brain.tasks.StayTask;
import fabric.net.mca.entity.ai.brain.tasks.WanderOrTeleportToTargetTask;
import fabric.net.mca.entity.ai.brain.tasks.chore.ChoppingTask;
import fabric.net.mca.entity.ai.brain.tasks.chore.FishingTask;
import fabric.net.mca.entity.ai.brain.tasks.chore.HarvestingTask;
import fabric.net.mca.entity.ai.brain.tasks.chore.HuntingTask;
import fabric.net.mca.entity.ai.relationship.AgeState;
import fabric.net.mca.server.world.data.VillageManager;
import fabric.net.mca.server.world.data.villageComponents.VillageGuardsManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3852;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4100;
import net.minecraft.class_4101;
import net.minecraft.class_4103;
import net.minecraft.class_4106;
import net.minecraft.class_4107;
import net.minecraft.class_4108;
import net.minecraft.class_4109;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4113;
import net.minecraft.class_4114;
import net.minecraft.class_4116;
import net.minecraft.class_4117;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4121;
import net.minecraft.class_4122;
import net.minecraft.class_4123;
import net.minecraft.class_4124;
import net.minecraft.class_4125;
import net.minecraft.class_4126;
import net.minecraft.class_4127;
import net.minecraft.class_4128;
import net.minecraft.class_4130;
import net.minecraft.class_4133;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4208;
import net.minecraft.class_4214;
import net.minecraft.class_4217;
import net.minecraft.class_4218;
import net.minecraft.class_4219;
import net.minecraft.class_4220;
import net.minecraft.class_4242;
import net.minecraft.class_4243;
import net.minecraft.class_4245;
import net.minecraft.class_4246;
import net.minecraft.class_4248;
import net.minecraft.class_4249;
import net.minecraft.class_4250;
import net.minecraft.class_4251;
import net.minecraft.class_4252;
import net.minecraft.class_4253;
import net.minecraft.class_4289;
import net.minecraft.class_4290;
import net.minecraft.class_4458;
import net.minecraft.class_4807;
import net.minecraft.class_4810;
import net.minecraft.class_4815;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_4982;
import net.minecraft.class_4983;
import net.minecraft.class_5325;
import net.minecraft.class_5326;
import net.minecraft.class_5327;
import net.minecraft.class_7477;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;

public class VillagerTasksMCA {
    public static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18438, (Object)class_4140.field_18439, (Object)class_4140.field_25160, (Object)class_4140.field_18440, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_19006, (Object)class_4140.field_18443, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_22332, (Object)class_4140.field_18445, (Object[])new class_4140[]{class_4140.field_18446, class_4140.field_18447, class_4140.field_18448, class_4140.field_18449, class_4140.field_26389, class_4140.field_19007, class_4140.field_18451, class_4140.field_18452, class_4140.field_18453, class_4140.field_18873, class_4140.field_19008, class_4140.field_19009, class_4140.field_19293, class_4140.field_19385, class_4140.field_20616, class_4140.field_19386, class_4140.field_25754, class_4140.field_22355, class_4140.field_22475, (class_4140)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get(), (class_4140)MemoryModuleTypeMCA.STAYING.get(), (class_4140)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get(), (class_4140)MemoryModuleTypeMCA.WEARS_ARMOR.get(), (class_4140)MemoryModuleTypeMCA.SMALL_BOUNTY.get(), (class_4140)MemoryModuleTypeMCA.HIT_BY_PLAYER.get(), (class_4140)MemoryModuleTypeMCA.LAST_GRIEVE.get(), (class_4140)MemoryModuleTypeMCA.FORCED_HOME.get()});
    public static final ImmutableList<class_4149<? extends class_4148<? super class_1646>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_19010, (Object)class_4149.field_18469, (Object)class_4149.field_18470, (Object)class_4149.field_18875, (Object)class_4149.field_25756, (Object)((class_4149)ActivityMCA.VILLAGER_BABIES.get()), (Object)((class_4149)ActivityMCA.EXPLODING_CREEPER.get()), (Object)((class_4149)ActivityMCA.GUARD_ENEMIES.get()));

    public static class_4095.class_5303<VillagerEntityMCA> createProfile() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static class_4095<VillagerEntityMCA> initializeTasks(VillagerEntityMCA villager, class_4095<VillagerEntityMCA> brain) {
        class_3852 profession = villager.method_7231().method_16924();
        AgeState age = AgeState.byCurrentAge(villager.method_5618());
        boolean noDefault = false;
        if (brain.method_46873((class_4140)MemoryModuleTypeMCA.STAYING.get()).isPresent()) {
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getStayingPackage());
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getSelfDefencePackage());
            brain.method_18881(class_4168.field_18599, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (brain.method_46873((class_4140)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isPresent()) {
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getFollowingPackage());
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getSelfDefencePackage());
            brain.method_18881(class_4168.field_18599, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (profession == ProfessionsMCA.MERCENARY.get()) {
            brain.method_18884(SchedulesMCA.GUESTS);
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.method_18881(class_4168.field_18595, VillagerTasksMCA.getMercenaryPackage(0.5f));
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getGuardCorePackage(villager));
            brain.method_18881(class_4168.field_18599, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.method_18881(class_4168.field_18597, VillagerTasksMCA.getRestPackage(0.5f));
            brain.method_18881((class_4168)ActivityMCA.CHORE.get(), VillagerTasksMCA.getChorePackage());
            noDefault = true;
        } else if (!villager.requiresHome()) {
            brain.method_18884(SchedulesMCA.GUESTS);
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.method_18881(class_4168.field_18595, VillagerTasksMCA.getAdventurerPackage(0.5f));
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getSelfDefencePackage());
            brain.method_18881(class_4168.field_18599, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.method_18881(class_4168.field_18597, VillagerTasksMCA.getRestPackage(0.5f));
            noDefault = true;
        } else {
            if (age == AgeState.BABY) {
                brain.method_18884(class_4170.field_18605);
                return brain;
            }
            if (age != AgeState.ADULT) {
                brain.method_18884(class_4170.field_18605);
                brain.method_18881(class_4168.field_18885, VillagerTasksMCA.getPlayPackage(1.0f));
                brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getSelfDefencePackage());
            } else if (villager.isGuard()) {
                brain.method_18884(SchedulesMCA.getTypeSchedule((class_1309)villager, SchedulesMCA.GUARD, SchedulesMCA.GUARD_NIGHT));
                brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getGuardCorePackage(villager));
                brain.method_18881(class_4168.field_18596, VillagerTasksMCA.getGuardWorkPackage());
                brain.method_18881(class_4168.field_18599, VillagerTasksMCA.getGuardPanicPackage(0.5f));
                brain.method_18881(class_4168.field_19041, VillagerTasksMCA.getGuardWorkPackage());
            } else {
                brain.method_18884(SchedulesMCA.getTypeSchedule((class_1309)villager));
                brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getWorkingCorePackage(profession, 0.5f));
                brain.method_24529(class_4168.field_18596, VillagerTasksMCA.getWorkPackage(profession, 0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_18439, (Object)class_4141.field_18456)));
                brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getSelfDefencePackage());
                brain.method_18881(class_4168.field_19041, VillagerTasksMCA.getRaidPackage(0.5f));
            }
        }
        brain.method_18881((class_4168)ActivityMCA.GRIEVE.get(), VillagerTasksMCA.getGrievingPackage());
        if (!noDefault) {
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.method_18881(class_4168.field_18594, VillagerTasksMCA.getCorePackage(0.5f));
            brain.method_24529(class_4168.field_18598, VillagerTasksMCA.getMeetPackage(0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_18440, (Object)class_4141.field_18456)));
            brain.method_18881(class_4168.field_18597, VillagerTasksMCA.getRestPackage(0.5f));
            brain.method_18881(class_4168.field_18595, VillagerTasksMCA.getIdlePackage(0.5f));
            brain.method_18881(class_4168.field_18599, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.method_18881(class_4168.field_19042, VillagerTasksMCA.getPreRaidPackage(0.5f));
            brain.method_18881(class_4168.field_19043, VillagerTasksMCA.getHidePackage(0.5f));
            brain.method_18881((class_4168)ActivityMCA.CHORE.get(), VillagerTasksMCA.getChorePackage());
        }
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24526(class_4168.field_18595);
        brain.method_18871(villager.method_37908().method_8532(), villager.method_37908().method_8510());
        return brain;
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getStayingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new StayTask())), VillagerTasksMCA.getFullLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getFollowingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new FollowTask())), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getImportantCorePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_4125(0.8f)), (Object)(Config.getServerConfig().useSmarterDoorAI ? Pair.of((Object)0, (Object)((Object)new SmarterOpenDoorsTask())) : Pair.of((Object)0, (Object)class_4107.method_46964())), (Object)Pair.of((Object)0, (Object)new class_4110(45, 90)), (Object)Pair.of((Object)0, (Object)class_4214.method_47204()), (Object)Pair.of((Object)0, (Object)((Object)new DeliverMessageTask())), (Object)Pair.of((Object)1, (Object)((Object)new WanderOrTeleportToTargetTask())), (Object)Pair.of((Object)3, (Object)((Object)new InteractTask(speedModifier))), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.method_40225(class_7477.field_39291), (class_4140<class_4208>)class_4140.field_18438, false, Optional.of((byte)14), villager -> villager.getResidency().seekHome(), (entity, pos) -> {
            VillageManager manager = VillageManager.get((class_3218)entity.method_37908());
            if (entity.requiresHome()) {
                return manager.findNearestVillage((class_1297)entity).filter(v -> !v.isPositionValidBed((class_2338)pos)).isEmpty();
            }
            return manager.findNearestVillage((class_1297)entity).filter(v -> v.getBuildingAt((class_2382)pos).filter(b -> b.getBuildingType().name().equals("inn")).isPresent()).isPresent();
        }))));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getCorePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GreetPlayerTask())), (Object)Pair.of((Object)0, (Object)class_4249.method_47033()), (Object)Pair.of((Object)0, (Object)class_4253.method_47086()), (Object)Pair.of((Object)5, (Object)class_4815.method_46943((float)speedModifier, (boolean)false, (int)4)), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.method_40225(class_7477.field_39291), (class_4140<class_4208>)class_4140.field_18438, false, Optional.of((byte)14), villager -> villager.getResidency().seekHome(), (entity, pos) -> {
            VillageManager manager = VillageManager.get((class_3218)entity.method_37908());
            return manager.findNearestVillage((class_1297)entity).filter(v -> v.getBuildingAt((class_2382)pos).filter(b -> b.getBuildingType().noBeds()).isPresent()).isEmpty();
        }))), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.method_40225(class_7477.field_39292), (class_4140<class_4208>)class_4140.field_18440, true, Optional.of((byte)14), villager -> villager.method_18868().method_46873(class_4140.field_18440).ifPresent(p -> {
            if (villager.method_37908().method_27983() == p.method_19442()) {
                VillageManager manager = VillageManager.get((class_3218)villager.method_37908());
                if (!manager.cache.contains(p.method_19446())) {
                    manager.cache.add(p.method_19446());
                    manager.processBuilding(p.method_19446());
                }
                villager.getResidency().seekHome();
            }
        })))));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getWorkingCorePackage(class_3852 profession, float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4128.method_47190((Predicate)profession.comp_819(), (class_4140)class_4140.field_18439)), (Object)Pair.of((Object)0, (Object)class_4128.method_47190((Predicate)profession.comp_820(), (class_4140)class_4140.field_25160)), (Object)Pair.of((Object)2, (Object)class_5326.method_47006()), (Object)Pair.of((Object)3, (Object)new class_4108(speedModifier)), (Object)Pair.of((Object)6, LazyFindPointOfInterestTask.create(profession.comp_820(), (class_4140<class_4208>)class_4140.field_18439, (class_4140<class_4208>)class_4140.field_25160, true, Optional.empty())), (Object)Pair.of((Object)7, (Object)new class_5325(speedModifier)), (Object)Pair.of((Object)8, (Object)class_5327.method_47207((float)speedModifier)), (Object)Pair.of((Object)10, (Object)class_4114.method_46887()), (Object)Pair.of((Object)10, LoseUnimportantJobTask.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getSelfDefencePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_4113()), (Object)Pair.of((Object)1, (Object)((Object)new EquipmentTask(VillagerTasksMCA::isInDanger, v -> EquipmentSet.NAKED))), (Object)Pair.of((Object)2, (Object)((Object)new ExtendedMeleeAttackTask(15, 2.5f, (class_4140<? extends class_1309>)class_4140.field_18453))));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getGuardCorePackage(VillagerEntityMCA villager) {
        return ImmutableList.of((Object)Pair.of((Object)0, new ConditionalTask<VillagerEntityMCA>((class_4097<VillagerEntityMCA>)new class_4113(), VillagerTasksMCA::guardTooHurt)), (Object)Pair.of((Object)0, (Object)((Object)new SayTask("villager.retreat", 100, e -> VillagerTasksMCA.guardTooHurt(e) && e.getVillagerBrain().isPanicking()))), (Object)Pair.of((Object)0, (Object)((Object)new SayTask("villager.attack", 160, e -> !VillagerTasksMCA.guardTooHurt(e) && VillagerTasksMCA.getPreferredTarget(e).isPresent()))), (Object)Pair.of((Object)0, new ConditionalTask<VillagerEntityMCA>(new ExtendedMeleeAttackTask(15, 2.5f, (class_4140<? extends class_1309>)class_4140.field_18453), VillagerTasksMCA::guardTooHurt)), (Object)Pair.of((Object)1, (Object)((Object)new EquipmentTask(VillagerTasksMCA::isOnDuty, v -> v.getResidency().getHomeVillage().map(vil -> vil.getVillageGuardsManager().getGuardEquipment(v.getProfession(), v.getDominantHand())).orElse(VillageGuardsManager.getEquipmentFor(v.getDominantHand(), EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT))))), (Object)Pair.of((Object)2, (Object)class_4824.method_47120(t -> true, VillagerTasksMCA::getPreferredTarget)), (Object)Pair.of((Object)3, (Object)class_4828.method_47138(livingEntity -> !VillagerTasksMCA.isPreferredTarget(villager, livingEntity))), (Object)Pair.of((Object)4, new BowTask(20, 12)), (Object)Pair.of((Object)5, (Object)class_7898.method_47227(v -> v.method_24518(class_1802.field_8399), (class_7894)class_4807.method_46901((int)5, (float)0.75f))), (Object)Pair.of((Object)6, (Object)class_4822.method_47094((float)0.75f)), (Object)Pair.of((Object)7, (Object)((Object)new ExtendedMeleeAttackTask(20, 2.0f))), (Object)Pair.of((Object)8, (Object)new class_4810()), (Object[])new Pair[0]);
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getGuardWorkPackage() {
        return ImmutableList.of((Object)Pair.of((Object)10, (Object)((Object)new PatrolVillageTask(4, 0.4f))), (Object)Pair.of((Object)99, (Object)class_4127.method_47184()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getGuardPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)class_4100.method_47197()), (Object)Pair.of((Object)2, (Object)class_4121.method_24603((class_4140)class_4140.field_18453, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)2, (Object)class_4121.method_24603((class_4140)class_4140.field_18452, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)class_4117.method_47192((float)f, (int)2, (int)2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    private static boolean guardTooHurt(VillagerEntityMCA villager) {
        return (double)villager.method_6032() < (double)villager.method_6063() * 0.25;
    }

    private static Optional<? extends class_1309> getPreferredTarget(VillagerEntityMCA villager) {
        if (VillagerTasksMCA.guardTooHurt(villager)) {
            return Optional.empty();
        }
        Optional primary = villager.method_18868().method_46873((class_4140)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get());
        if (primary.isPresent() && (VillagerTasksMCA.getActivity(villager) != class_4168.field_18597 || (double)((class_1309)primary.get()).method_5739((class_1297)villager) < 8.0)) {
            return primary;
        }
        return villager.method_18868().method_46873(class_4140.field_22355);
    }

    private static boolean isPreferredTarget(VillagerEntityMCA villager, class_1309 entity) {
        Optional<? extends class_1309> target = VillagerTasksMCA.getPreferredTarget(villager);
        return target.filter(livingEntity -> livingEntity == entity).isPresent();
    }

    public static boolean isOnDuty(VillagerEntityMCA villager) {
        return VillagerTasksMCA.getActivity(villager) == class_4168.field_18596 || villager.method_18868().method_46873(class_4140.field_22355).isPresent();
    }

    public static boolean isInDanger(VillagerEntityMCA villager) {
        return villager.getVillagerBrain().isPanicking() || villager.method_18868().method_46873(class_4140.field_22355).isPresent();
    }

    private static class_4168 getActivity(VillagerEntityMCA villager) {
        return villager.method_18868().method_18894().method_19213((int)(villager.method_37908().method_8532() % 24000L));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getGrievingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, new SequenceTask((Map<class_4140<?>, class_4141>)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), ImmutableList.of((Object)((Object)new EnterBuildingTask("graveyard", 0.5f)), (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)((Object)new HoldItemTask(class_1268.field_5808, class_1802.field_17510)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(class_1268.field_5808, class_1802.field_17502)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(class_1268.field_5808, class_1802.field_17509)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(class_1268.field_5808, class_1802.field_17511)), (Object)1))), (Object)((Object)new WanderOrTeleportToTargetTask()), (Object)new class_4101(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)new class_4101(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)new class_4101(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)((Object)new HoldItemTask(class_1268.field_5808, class_1799.field_8037)), new LambdaTask<VillagerEntityMCA>(v -> {
            v.getVillagerBrain().justGrieved();
            v.method_18868().method_18871(v.method_37908().method_8532(), v.method_37908().method_8510());
        })))));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getWorkPackage(class_3852 profession, float speedModifier) {
        Object villagerWorkTask = profession == class_3852.field_17056 ? new class_4983() : new class_4133();
        return ImmutableList.of(VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)5, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)villagerWorkTask, (Object)7), (Object)Pair.of((Object)class_4116.method_47153((class_4140)class_4140.field_18439, (float)0.4f, (int)4), (Object)2), (Object)Pair.of((Object)class_4219.method_47157((class_4140)class_4140.field_18439, (float)0.4f, (int)1, (int)10), (Object)5), (Object)Pair.of((Object)class_4220.method_47161((class_4140)class_4140.field_18873, (float)speedModifier, (int)1, (int)6, (class_4140)class_4140.field_18439), (Object)5), (Object)Pair.of((Object)new class_4217(), (Object)(profession == class_3852.field_17056 ? 2 : 5)), (Object)Pair.of((Object)new class_4982(), (Object)(profession == class_3852.field_17056 ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new class_4130(400, 1600)), (Object)Pair.of((Object)10, (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)4)), (Object)Pair.of((Object)2, (Object)class_4122.method_47102((class_4140)class_4140.field_18439, (float)speedModifier, (int)9, (int)100, (int)1200)), (Object)Pair.of((Object)3, (Object)new class_4243(100)), (Object)Pair.of((Object)99, (Object)class_4127.method_47184()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getPlayPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_4112(80, 120)), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)5, (Object)class_4218.method_47000()), (Object)Pair.of((Object)5, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_19006, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4106.method_18941((class_1299)class_1299.field_6077, (int)8, (class_4140)class_4140.field_18447, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)class_4106.method_18941((class_1299)class_1299.field_16281, (int)8, (class_4140)class_4140.field_18447, (float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)class_4117.method_47191((float)speedModifier), (Object)1), (Object)Pair.of((Object)class_4120.method_47104((float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)new class_4245(speedModifier), (Object)2), (Object)Pair.of((Object)new class_4101(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)class_4127.method_47184()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getRestPackage(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)2, ExtendedWalkTowardsTask.create((class_4140<class_4208>)class_4140.field_18438, speed, 1, 192, 1200, v -> {
            boolean forced;
            Optional memory = v.method_18868().method_46873((class_4140)MemoryModuleTypeMCA.FORCED_HOME.get());
            boolean bl = forced = memory != null && memory.isPresent();
            if (forced) {
                v.sendChatToAllAround("villager.cant_find_bed", new Object[0]);
            }
            return !forced;
        }, v -> v.getResidency().seekHome())), (Object)Pair.of((Object)3, new ConditionalSingleTickTask<VillagerEntityMCA>(ExtendedForgetCompletedPointOfInterestTask.create(registryEntry -> registryEntry.method_40225(class_7477.field_39291), (class_4140<class_4208>)class_4140.field_18438, entity -> {
            if (entity instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.getResidency().seekHome();
            }
        }), v -> {
            Optional memory = v.method_18868().method_46873((class_4140)MemoryModuleTypeMCA.FORCED_HOME.get());
            return memory == null || memory.isEmpty();
        })), (Object)Pair.of((Object)3, (Object)new class_4123()), (Object)Pair.of((Object)5, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18438, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4290.method_47048((float)speed), (Object)1), (Object)Pair.of((Object)class_4289.method_46949((float)speed), (Object)4), (Object)Pair.of((Object)class_4458.method_46934((float)speed, (int)4), (Object)2), (Object)Pair.of((Object)new class_4101(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)class_4127.method_47184()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getMeetPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4116.method_47153((class_4140)class_4140.field_18440, (float)0.4f, (int)40), (Object)2), (Object)Pair.of((Object)class_4124.method_47111(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new class_4130(400, 1600)), (Object)Pair.of((Object)10, (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)4)), (Object)Pair.of((Object)2, (Object)class_4122.method_47102((class_4140)class_4140.field_18440, (float)speedModifier, (int)6, (int)100, (int)200)), (Object)Pair.of((Object)3, (Object)new class_4243(100)), (Object)Pair.of((Object)3, (Object)class_4128.method_47190(registryEntry -> registryEntry.method_40225(class_7477.field_39292), (class_4140)class_4140.field_18440)), (Object)Pair.of((Object)3, (Object)new class_4103((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)class_4140.field_18447), class_4103.class_4104.field_18348, class_4103.class_4216.field_18855, (List)ImmutableList.of((Object)Pair.of((Object)new class_4126(), (Object)1)))), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)class_4127.method_47184()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getIdlePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)((Object)new EnterFavoredBuildingTask(0.5f))), (Object)Pair.of((Object)2, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4106.method_18941((class_1299)((class_1299)EntitiesMCA.FEMALE_VILLAGER.get()), (int)8, (class_4140)class_4140.field_18447, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)class_4106.method_18941((class_1299)((class_1299)EntitiesMCA.MALE_VILLAGER.get()), (int)8, (class_4140)class_4140.field_18447, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)class_4106.method_18941((class_1299)class_1299.field_16281, (int)8, (class_4140)class_4140.field_18447, (float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)class_4117.method_47191((float)speedModifier), (Object)1), (Object)Pair.of((Object)class_4120.method_47104((float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)new class_4245(speedModifier), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new class_4243(100)), (Object)Pair.of((Object)3, (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)4)), (Object)Pair.of((Object)3, (Object)new class_4130(400, 1600)), (Object)Pair.of((Object)3, (Object)((Object)new GrieveTask())), (Object)Pair.of((Object)3, (Object)new class_4103((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)class_4140.field_18447), class_4103.class_4104.field_18348, class_4103.class_4216.field_18855, (List)ImmutableList.of((Object)Pair.of((Object)new class_4126(), (Object)1)))), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)class_4127.method_47184()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4100.method_47197()), (Object)Pair.of((Object)1, (Object)class_4121.method_24603((class_4140)class_4140.field_18453, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)1, (Object)class_4121.method_24603((class_4140)class_4140.field_18452, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)class_4117.method_47192((float)f, (int)2, (int)2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getPreRaidPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4251.method_47044()), (Object)Pair.of((Object)0, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4122.method_47102((class_4140)class_4140.field_18440, (float)(speedModifier * 1.5f), (int)2, (int)150, (int)200), (Object)6), (Object)Pair.of((Object)class_4117.method_47191((float)(speedModifier * 1.5f)), (Object)2)))), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)class_4250.method_47041()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getRaidPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4248.method_46995((float)speedModifier), (Object)5), (Object)Pair.of((Object)class_4117.method_47191((float)(speedModifier * 1.1f)), (Object)2)))), (Object)Pair.of((Object)0, (Object)new class_4242(600, 600)), (Object)Pair.of((Object)2, (Object)class_4246.method_46975((int)24, (float)(speedModifier * 1.4f), (int)1)), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)class_4250.method_47041()));
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getHidePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4252.method_47077((int)15, (int)3)), (Object)Pair.of((Object)1, (Object)class_4246.method_46975((int)32, (float)(speedModifier * 1.25f), (int)2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getChorePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new ChoppingTask())), (Object)Pair.of((Object)0, (Object)((Object)new FishingTask())), (Object)Pair.of((Object)0, (Object)((Object)new HarvestingTask())), (Object)Pair.of((Object)0, (Object)((Object)new HuntingTask())));
    }

    private static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getAdventurerPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)5, (Object)class_4106.method_18941((class_1299)((class_1299)EntitiesMCA.FEMALE_VILLAGER.get()), (int)8, (class_4140)class_4140.field_18447, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)class_4106.method_18941((class_1299)((class_1299)EntitiesMCA.MALE_VILLAGER.get()), (int)8, (class_4140)class_4140.field_18447, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)class_4106.method_18941((class_1299)class_1299.field_16281, (int)8, (class_4140)class_4140.field_18447, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)class_4117.method_47191((float)speedModifier)), (Object)Pair.of((Object)5, (Object)class_4120.method_47104((float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)((Object)new EnterBuildingTask("inn", 0.5f))));
    }

    private static ImmutableList<Pair<Integer, ? extends class_7893<? super VillagerEntityMCA>>> getMercenaryPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)5, (Object)class_4117.method_47191((float)speedModifier)), (Object)Pair.of((Object)5, (Object)class_4120.method_47104((float)speedModifier, (int)2)));
    }

    private static Pair<Integer, class_7893<class_1309>> getFullLookBehavior() {
        return Pair.of((Object)5, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_16281, (float)8.0f), (Object)8), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6077, (float)8.0f), (Object)2), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)8.0f), (Object)2), (Object)Pair.of((Object)class_4119.method_47061((class_1311)class_1311.field_6294, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47061((class_1311)class_1311.field_6300, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47061((class_1311)class_1311.field_24460, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47061((class_1311)class_1311.field_6302, (float)8.0f), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)2))));
    }

    private static Pair<Integer, class_7893<class_1309>> getMinimalLookBehavior() {
        return Pair.of((Object)5, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6077, (float)8.0f), (Object)2), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)8.0f), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)8))));
    }
}

