/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca;

import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MCA {
    public static final String MOD_ID = "mca";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Boolean> MOD_CACHE = new HashMap<String, Boolean>();
    public static final ExecutorService executorService = Executors.newSingleThreadExecutor();
    public static Map<String, String> translations = new HashMap<String, String>();
    public static String language;
    private static MinecraftServer server;

    public static ResourceLocation locate(String id) {
        return new ResourceLocation(MOD_ID, id);
    }

    public static boolean isBlankString(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean doesModExist(String modId) {
        if (!MOD_CACHE.containsKey(modId)) {
            Optional<Object> modData;
            try {
                modData = Optional.of(Platform.getMod((String)modId));
            }
            catch (Exception ignored) {
                modData = Optional.empty();
            }
            MOD_CACHE.put(modId, modData.isPresent());
        }
        return MOD_CACHE.get(modId);
    }

    public static void setServer(MinecraftServer server) {
        MCA.server = server;
    }

    public static Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(server);
    }
}

