/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class Traits {
    private static final CDataParameter<CompoundTag> TRAITS = CParameter.create("traits", new CompoundTag());
    public static final Map<String, Trait> TRAIT_REGISTRY = new HashMap<String, Trait>();
    public static Trait LEFT_HANDED = Traits.registerTrait("LEFT_HANDED", 1.0f, 0.5f, false);
    public static Trait WEAK = Traits.registerTrait("WEAK", 1.0f, 1.0f, false);
    public static Trait TOUGH = Traits.registerTrait("TOUGH", 1.0f, 1.0f, false);
    public static Trait COLOR_BLIND = Traits.registerTrait("COLOR_BLIND", 1.0f, 0.5f);
    public static Trait HETEROCHROMIA = Traits.registerTrait("HETEROCHROMIA", 1.0f, 0.5f);
    public static Trait LACTOSE_INTOLERANCE = Traits.registerTrait("LACTOSE_INTOLERANCE", 1.0f, 1.0f);
    public static Trait COELIAC_DISEASE = Traits.registerTrait("COELIAC_DISEASE", 1.0f, 1.0f, false);
    public static Trait DIABETES = Traits.registerTrait("DIABETES", 1.0f, 1.0f, false);
    public static Trait DWARFISM = Traits.registerTrait("DWARFISM", 1.0f, 1.0f);
    public static Trait ALBINISM = Traits.registerTrait("ALBINISM", 1.0f, 1.0f);
    public static Trait VEGETARIAN = Traits.registerTrait("VEGETARIAN", 1.0f, 1.0f, false);
    public static Trait BISEXUAL = Traits.registerTrait("BISEXUAL", 1.0f, 0.0f);
    public static Trait HOMOSEXUAL = Traits.registerTrait("HOMOSEXUAL", 1.0f, 0.0f);
    public static Trait ASEXUAL = Traits.registerTrait("ASEXUAL", 1.0f, 0.0f);
    public static Trait ELECTRIFIED = Traits.registerTrait("ELECTRIFIED", 0.0f, 0.0f, false);
    public static Trait SIRBEN = Traits.registerTrait("SIRBEN", 0.025f, 1.0f);
    public static Trait RAINBOW = Traits.registerTrait("RAINBOW", 0.05f, 0.0f);
    public static Trait UNKNOWN = Traits.registerTrait("UNKNOWN", 0.0f, 0.0f, false);
    private RandomSource random = RandomSource.m_216327_();
    private final VillagerLike<?> entity;

    public static Trait registerTrait(String id, float chance, float inherit, boolean usableOnPlayer) {
        Trait trait = new Trait(id, chance, inherit, usableOnPlayer);
        TRAIT_REGISTRY.put(id, trait);
        return trait;
    }

    public static Trait registerTrait(String id, float chance, float inherit) {
        return Traits.registerTrait(id, chance, inherit, true);
    }

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(TRAITS);
    }

    public Traits(VillagerLike<?> entity) {
        this.entity = entity;
    }

    public Set<Trait> getTraits() {
        return ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_128431_().stream().map(Trait::valueOf).collect(Collectors.toSet());
    }

    public Set<Trait> getInheritedTraits() {
        return this.getTraits().stream().filter(t -> this.random.m_188501_() < t.inherit * Config.getInstance().traitInheritChance).collect(Collectors.toSet());
    }

    public boolean hasTrait(VillagerLike<?> target, Trait trait) {
        return ((CompoundTag)target.getTrackedValue(TRAITS)).m_128441_(trait.id());
    }

    public boolean hasTrait(Trait trait) {
        return this.hasTrait(this.entity, trait);
    }

    public boolean hasTrait(String trait) {
        if (Trait.valueOf(trait) != null) {
            return this.hasTrait(this.entity, Trait.valueOf(trait));
        }
        return false;
    }

    public boolean eitherHaveTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) || this.hasTrait(other, trait);
    }

    public boolean hasSameTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) && this.hasTrait(other, trait);
    }

    public void addTrait(Trait trait) {
        CompoundTag traits = ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_6426_();
        traits.m_128379_(trait.id(), true);
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void removeTrait(Trait trait) {
        CompoundTag traits = ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_6426_();
        traits.m_128473_(trait.id());
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void randomize() {
        float total = (float)Trait.values().stream().mapToDouble(tr -> tr.chance).sum();
        for (Trait t : Trait.values()) {
            float chance = Config.getInstance().traitChance / total * t.chance;
            if (!(this.random.m_188501_() < chance) || !t.isEnabled()) continue;
            this.addTrait(t);
        }
    }

    public void inherit(Traits from) {
        for (Trait t : from.getInheritedTraits()) {
            this.addTrait(t);
        }
    }

    public void inherit(Traits from, long seed) {
        RandomSource old = this.random;
        this.random = RandomSource.m_216335_((long)seed);
        this.inherit(from);
        this.random = old;
    }

    public float getVerticalScaleFactor() {
        return this.hasTrait(DWARFISM) ? 0.65f : 1.0f;
    }

    public float getHorizontalScaleFactor() {
        return (this.hasTrait(DWARFISM) ? 0.85f : 1.0f) * (this.hasTrait(TOUGH) ? 1.2f : 1.0f) * (this.hasTrait(WEAK) ? 0.85f : 1.0f);
    }

    public static class Trait {
        private final String id;
        private final float chance;
        private final float inherit;
        private final boolean usableOnPlayer;

        Trait(String id, float chance, float inherit, boolean usableOnPlayer) {
            this.id = id;
            this.chance = chance;
            this.inherit = inherit;
            this.usableOnPlayer = usableOnPlayer;
        }

        public String id() {
            return this.id;
        }

        public static Collection<Trait> values() {
            return TRAIT_REGISTRY.values();
        }

        public static Trait valueOf(String id) {
            return TRAIT_REGISTRY.getOrDefault(id.toUpperCase(Locale.ROOT), UNKNOWN);
        }

        public Component getName() {
            return Component.m_237115_((String)("trait." + this.id().toLowerCase(Locale.ROOT)));
        }

        public Component getDescription() {
            return Component.m_237115_((String)("traitDescription." + this.id().toLowerCase(Locale.ROOT)));
        }

        public boolean isUsableOnPlayer() {
            return this.usableOnPlayer;
        }

        public boolean isEnabled() {
            return Config.getServerConfig().enabledTraits.getOrDefault(this.id(), false);
        }
    }
}

