/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.DestinyManager;
import net.conczin.mca.KeyBindings;
import net.conczin.mca.MCA;
import net.conczin.mca.client.gui.SkinLibraryScreen;
import net.conczin.mca.client.tts.SpeechManager;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.ConfigRequest;
import net.conczin.mca.network.c2s.PlayerDataRequest;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class MCAClient {
    public static final Map<UUID, VillagerLike<?>> playerData = new HashMap();
    public static final Set<UUID> playerDataRequests = new HashSet<UUID>();
    private static final DestinyManager destinyManager = new DestinyManager();
    public static VillagerEntityMCA fallbackVillager;

    public static DestinyManager getDestinyManager() {
        return destinyManager;
    }

    public static void onLogin() {
        playerDataRequests.clear();
        Network.sendToServer(new ConfigRequest());
    }

    public static Optional<VillagerLike<?>> getPlayerData(UUID uuid) {
        if (MCAClient.isPlayerRendererAllowed()) {
            if (!playerDataRequests.contains(uuid) && class_310.method_1551().method_1562() != null) {
                playerDataRequests.add(uuid);
                Network.sendToServer(new PlayerDataRequest(uuid));
            }
            if (playerData.containsKey(uuid)) {
                return Optional.of(playerData.get(uuid));
            }
        }
        return Optional.empty();
    }

    public static boolean useExpandedPersonalityTranslations() {
        boolean isTTSPackActive = class_310.method_1551().method_1478().method_29213().anyMatch(pack -> pack.method_14409().contains("MCAVoices"));
        return !isTTSPackActive && class_310.method_1551().field_1690.field_1883.equals("en_us") && !Config.getInstance().enableOnlineTTS;
    }

    public static boolean useGeneticsRenderer(UUID uuid) {
        return MCAClient.getPlayerData(uuid).filter(f -> f.getPlayerModel() != VillagerLike.PlayerModel.VANILLA).isPresent();
    }

    public static boolean useVillagerRenderer(UUID uuid) {
        return MCAClient.useGeneticsRenderer(uuid) && playerData.get(uuid).getPlayerModel() == VillagerLike.PlayerModel.VILLAGER;
    }

    public static boolean renderArms(UUID uuid, String key) {
        return MCAClient.useVillagerRenderer(uuid) && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("arms") || ((String)entry.getValue()).equals(key)).noneMatch(entry -> MCA.platformHelper.isModLoaded((String)entry.getKey()));
    }

    public static void tickClient(class_310 client) {
        destinyManager.tick(client);
        if (KeyBindings.SKIN_LIBRARY.method_1436()) {
            class_310.method_1551().method_1507((class_437)new SkinLibraryScreen());
        }
        SpeechManager.INSTANCE.tick(client);
    }

    public static void addPlayerData(UUID uuid, VillagerEntityMCA villager) {
        playerData.put(uuid, villager);
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_18382();
        }
    }

    public static boolean isPlayerRendererAllowed() {
        return Config.getInstance().enableVillagerPlayerModel && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("all") || ((String)entry.getValue()).equals("block_player")).noneMatch(entry -> MCA.platformHelper.isModLoaded((String)entry.getKey()));
    }

    public static boolean isVillagerRendererAllowed() {
        return !Config.getInstance().forceVillagerPlayerModel && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("all") || ((String)entry.getValue()).equals("block_villager")).noneMatch(entry -> MCA.platformHelper.isModLoaded((String)entry.getKey()));
    }

    public static boolean areShadersAllowed(String key) {
        return Config.getInstance().enablePlayerShaders && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("shaders") || ((String)entry.getValue()).equals(key)).noneMatch(entry -> MCA.platformHelper.isModLoaded((String)entry.getKey()));
    }

    public static boolean areShadersAllowed() {
        return MCAClient.areShadersAllowed("shaders");
    }
}

