/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.tts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.conczin.mca.MCA;
import net.conczin.mca.client.tts.sound.PCMAudioStream;

public class AudioCache {
    private static final int MIN_SIZE = 128;
    private static final String CACHE_DIR = "tts_cache/";
    private static final MessageDigest MESSAGEDIGEST;
    public static Map<String, PCMAudioStream> inMemory;

    private static void setInMemoryAudio(String identifier, ByteBuffer buffer) {
        if (inMemory.containsKey(identifier)) {
            inMemory.get(identifier).setBuffer(buffer);
        } else {
            inMemory.put(identifier, new PCMAudioStream(buffer));
        }
    }

    public static PCMAudioStream getPCMAudioStream(String identifier) {
        if (inMemory.containsKey(identifier)) {
            return inMemory.get(identifier);
        }
        return new PCMAudioStream(AudioCache.readFromDisk(identifier));
    }

    public static boolean get(String identifier, Consumer<OutputStream> retriever, boolean persistent) {
        if (persistent) {
            return AudioCache.cachedRetrieve(identifier, retriever);
        }
        ByteBuffer byteBuffer = AudioCache.retrieve(retriever);
        if (byteBuffer == null) {
            return false;
        }
        AudioCache.setInMemoryAudio(identifier, byteBuffer);
        return true;
    }

    private static ByteBuffer retrieve(Consumer<OutputStream> retriever) {
        ByteBuffer byteBuffer;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            retriever.accept(baos);
            byteBuffer = ByteBuffer.wrap(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        baos.close();
        return byteBuffer;
    }

    public static ByteBuffer readFromDisk(String identifier) {
        ByteBuffer byteBuffer;
        File cacheFile = new File(CACHE_DIR, identifier);
        if (!AudioCache.isSane(cacheFile)) {
            return null;
        }
        FileInputStream fis = new FileInputStream(cacheFile);
        try {
            byteBuffer = ByteBuffer.wrap(fis.readAllBytes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                MCA.LOGGER.error("Failed to retrieve cached audio file: {}", (Object)identifier, (Object)e);
                return null;
            }
        }
        fis.close();
        return byteBuffer;
    }

    public static boolean cachedRetrieve(String identifier, Consumer<OutputStream> retriever) {
        try {
            File cacheFile = new File(CACHE_DIR, identifier);
            if (AudioCache.isSane(cacheFile)) {
                return true;
            }
            cacheFile.getParentFile().mkdirs();
            try (FileOutputStream fos = new FileOutputStream(cacheFile);){
                retriever.accept(fos);
            }
            return AudioCache.isSane(cacheFile);
        }
        catch (IOException e) {
            MCA.LOGGER.error("Failed to cache audio file: {}", (Object)identifier, (Object)e);
            return false;
        }
    }

    private static boolean isSane(File cacheFile) {
        return cacheFile.exists() && cacheFile.length() > 128L;
    }

    public static String getHash(String text) {
        MESSAGEDIGEST.update(text.getBytes());
        return AudioCache.toHex(MESSAGEDIGEST.digest()).toLowerCase(Locale.ROOT);
    }

    public static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format(Locale.ROOT, "%0" + (bytes.length << 1) + "X", bi);
    }

    static {
        inMemory = new ConcurrentHashMap<String, PCMAudioStream>();
        try {
            MESSAGEDIGEST = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

