/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.ConversationManager;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class DeliverMessageTask
extends class_4097<VillagerEntityMCA> {
    private static final int TALKING_TIME_MIN = 100;
    private static final int TALKING_TIME_MAX = 500;
    private static final long MIN_TIME_BETWEEN_SOUND = 6000L;
    private ConversationManager.Message message = null;
    private class_1297 receiver = null;
    private int talked;
    private long lastInteraction = Long.MIN_VALUE;
    private class_243 lastInteractionPos;

    public DeliverMessageTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18458, (Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_18447, (Object)class_4141.field_18458), 600);
    }

    private static Optional<ConversationManager.Message> getMessage(VillagerEntityMCA villager) {
        return villager.conversationManager.getCurrentMessage();
    }

    private static boolean isWithinRange(VillagerEntityMCA villager, class_1297 player) {
        if (villager.method_18868().method_46873(MemoryModuleTypeMCA.STAYING).isPresent()) {
            return true;
        }
        return villager.method_24515().method_19771((class_2382)player.method_24515(), 3.0);
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, class_1297 player) {
        return villager.method_24515().method_19771((class_2382)player.method_24515(), 64.0);
    }

    protected boolean checkExtraStartConditions(class_3218 world, VillagerEntityMCA villager) {
        Optional<ConversationManager.Message> optionalMessage = DeliverMessageTask.getMessage(villager);
        optionalMessage.ifPresent(m -> {
            this.message = m;
            this.receiver = this.message.getReceiver();
        });
        return optionalMessage.isPresent() && DeliverMessageTask.isWithinSeeRange(villager, this.receiver);
    }

    protected void start(class_3218 world, VillagerEntityMCA villager, long time) {
        this.talked = 0;
    }

    protected boolean canStillUse(class_3218 world, VillagerEntityMCA villager, long time) {
        return this.message != null && this.talked < this.getMaxTalkingTime() && !villager.getVillagerBrain().isPanicking() && !villager.method_6113();
    }

    private int getMaxTalkingTime() {
        class_243 pos;
        if (this.lastInteractionPos != null && this.lastInteractionPos.method_24802((class_2374)(pos = this.receiver.method_19538()), 1.0)) {
            return 500;
        }
        return 100;
    }

    protected void tick(class_3218 world, VillagerEntityMCA villager, long time) {
        class_1297 class_12972 = this.receiver;
        if (class_12972 instanceof class_1309) {
            class_1309 e = (class_1309)class_12972;
            villager.method_18868().method_18878(class_4140.field_18447, (Object)e);
            class_4215.method_19554((class_1309)villager, (class_1309)e);
        }
        class_4215.method_24557((class_1309)villager, (class_1297)this.receiver, (float)0.5f, (int)2);
        if (this.message.getReceiver() != this.receiver) {
            return;
        }
        if (this.message.stillValid() && DeliverMessageTask.isWithinRange(villager, this.receiver)) {
            if (time - this.lastInteraction > 6000L) {
                villager.playWelcomeSound();
            }
            this.lastInteraction = time;
            this.lastInteractionPos = this.receiver.method_19538();
            this.message.deliver();
        } else if (!this.message.stillValid() && DeliverMessageTask.isWithinRange(villager, this.receiver)) {
            ++this.talked;
            Optional<ConversationManager.Message> optionalMessage = DeliverMessageTask.getMessage(villager);
            optionalMessage.ifPresent(m -> {
                this.message = m;
                if (m.getReceiver() == this.receiver) {
                    this.talked = 0;
                }
            });
        }
    }

    protected void stop(class_3218 world, VillagerEntityMCA villager, long time) {
        this.message = null;
        this.receiver = null;
        villager.method_18868().method_18875(class_4140.field_18447);
        villager.method_18868().method_18875(class_4140.field_18445);
        villager.method_18868().method_18875(class_4140.field_18446);
    }
}

