/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources;

import java.util.ArrayList;
import java.util.List;
import net.conczin.mca.resources.API;

public class WeightedPool<T> {
    protected final List<Entry<T>> entries = new ArrayList<Entry<T>>();
    private final T defaultValue;

    public WeightedPool(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T pickOne() {
        double totalChance = this.entries.stream().mapToDouble(a -> a.weight).sum() * API.getRng().method_43058();
        for (Entry<T> e : this.entries) {
            if (!((totalChance -= (double)e.weight) <= 0.0)) continue;
            return e.value;
        }
        return this.defaultValue;
    }

    public T pickNext(T current, int next) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get((int)i).value.equals(current)) continue;
            return this.entries.get((int)Math.floorMod((int)(i + next), (int)this.entries.size())).value;
        }
        return this.pickOne();
    }

    public List<Entry<T>> getEntries() {
        return this.entries;
    }

    public static class Entry<T> {
        private final T value;
        private final float weight;

        public Entry(T value, float weight) {
            this.value = value;
            this.weight = weight;
        }

        public T getValue() {
            return this.value;
        }

        public float getWeight() {
            return this.weight;
        }
    }

    public static class Mutable<T>
    extends WeightedPool<T> {
        public Mutable(T defaultValue) {
            super(defaultValue);
        }

        public void add(T value, float weight) {
            this.entries.add(new Entry<T>(value, weight));
        }
    }
}

