/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.conczin.mca.resources.data.SerializablePair;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class Analysis
implements Iterable<AnalysisElement> {
    public static final class_9139<class_2540, Analysis> STREAM_CODEC = class_9139.method_56434((class_9139)SerializablePair.streamCodec(class_9135.field_48554, class_9135.field_49675).method_56433(class_9135.method_56363()), Analysis::getSummands, Analysis::new);
    private final List<SerializablePair<String, Integer>> summands = new LinkedList<SerializablePair<String, Integer>>();

    public Analysis() {
    }

    public Analysis(List<SerializablePair<String, Integer>> summands) {
        this.summands.addAll(summands);
    }

    public void add(String key, Integer value) {
        this.summands.add(new SerializablePair<String, Integer>(key, value));
    }

    public List<SerializablePair<String, Integer>> getSummands() {
        return this.summands;
    }

    @Override
    @NotNull
    public Iterator<AnalysisElement> iterator() {
        return new Iterator<AnalysisElement>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Analysis.this.summands.size();
            }

            @Override
            public AnalysisElement next() {
                SerializablePair<String, Integer> pair = Analysis.this.summands.get(this.i++);
                return new AnalysisElement(Analysis.this.isPositive(pair.right()), Analysis.this.asString(pair.right()), pair.left());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isPositive(Integer v) {
        return v >= 0;
    }

    public String asString(Integer v) {
        return String.valueOf(v);
    }

    public Integer getTotal() {
        return this.getSummands().stream().mapToInt(SerializablePair::right).sum();
    }

    public String getTotalAsString() {
        float positive = this.getSummands().stream().mapToInt(SerializablePair::right).filter(v -> v > 0).sum();
        float negative = -this.getSummands().stream().mapToInt(SerializablePair::right).filter(v -> v < 0).sum();
        int chance = (int)(positive / (positive + negative) * 100.0f);
        return chance + "% chance";
    }

    public record AnalysisElement(boolean positive, String value, String key) {
    }
}

