/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server;

import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.conczin.mca.Config;
import net.conczin.mca.ducks.IVillagerEntity;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerFactory;
import net.conczin.mca.entity.ZombieVillagerEntityMCA;
import net.conczin.mca.entity.ZombieVillagerFactory;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.server.world.data.Nationality;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final ConcurrentLinkedQueue<class_1646> villagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<class_1641> zombieVillagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<class_1642> zombieSpawnList = new ConcurrentLinkedQueue();

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    public static boolean shouldGetConverted(class_1297 entity) {
        if (Config.getInstance().fractionOfVanillaVillages <= 0.0f) {
            return true;
        }
        int i = Nationality.get((class_3218)entity.method_37908()).getRegionId(entity.method_24515());
        return (double)Math.floorMod(i, 100) >= (double)Config.getInstance().fractionOfVanillaVillages * 100.0;
    }

    public void tick() {
        class_1642 ze;
        class_1641 zve;
        class_1646 ve = this.villagerSpawnQueue.poll();
        if (ve != null) {
            ve.method_31472();
            VillagerEntityMCA villager = VillagerFactory.newVillager(ve.method_37908()).withName(ve.method_16914() ? ve.method_5477().getString() : null).withGender(Gender.getRandom()).withAge(ve.method_5618()).withPosition((class_1297)ve).withType(ve.method_7231().method_16919()).withProfession(ve.method_7231().method_16924(), ve.method_7231().method_16925(), ve.method_8264()).spawn(((IVillagerEntity)ve).mca$getSpawnReason());
            this.copyPastaIntensifies((class_1314)villager, (class_1314)ve);
        }
        if ((zve = this.zombieVillagerSpawnQueue.poll()) != null) {
            zve.method_31472();
            ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(zve.method_37908()).withName(zve.method_16914() ? zve.method_5477().getString() : null).withGender(Gender.getRandom()).withPosition((class_1297)zve).withType(zve.method_7231().method_16919()).withProfession(zve.method_7231().method_16924(), zve.method_7231().method_16925()).spawn(((IVillagerEntity)zve).mca$getSpawnReason());
            this.copyPastaIntensifies((class_1314)villager, (class_1314)zve);
        }
        if ((ze = this.zombieSpawnList.poll()) != null) {
            ze.method_31472();
            ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(ze.method_37908()).withName(ze.method_16914() ? ze.method_5477().getString() : null).withGender(Gender.getRandom()).withPosition((class_1297)ze).withType(class_3854.method_16930((class_6880)ze.method_37908().method_23753(ze.method_24515()))).withProfession(class_7923.field_41195.method_10240(ze.method_59922()).map(class_6880::comp_349).orElse(class_3852.field_17051)).spawn(class_3730.field_16459);
            this.copyPastaIntensifies((class_1314)villager, (class_1314)ze);
        }
    }

    private void copyPastaIntensifies(class_1314 villager, class_1314 entity) {
        if (entity.method_5947()) {
            villager.method_5971();
        }
        if (entity.method_5655()) {
            villager.method_5684(true);
        }
        if (entity.method_5987()) {
            villager.method_5977(true);
        }
        for (String tag : entity.method_5752()) {
            villager.method_5780(tag);
        }
    }

    public boolean addVillager(class_1297 entity) {
        IVillagerEntity villagerEntity;
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason((villagerEntity = (IVillagerEntity)entity).mca$getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.method_5770().method_27983().method_29177().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(class_1646.class) || Config.getInstance().moddedVillagerWhitelist.contains(class_7923.field_41177.method_10221((Object)entity.method_5864()).toString()) && entity instanceof class_1646) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((class_1646)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(class_1641.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(class_7923.field_41177.method_10221((Object)entity.method_5864()).toString()) && entity instanceof class_1641) && Config.getInstance().fractionOfVanillaZombies < entity.method_59922().method_43057() && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((class_1641)entity);
        }
        if (Config.getInstance().overwriteAllZombiesWithZombieVillagers && entity.getClass().equals(class_1642.class) && !this.zombieSpawnList.contains(entity)) {
            return this.zombieSpawnList.add((class_1642)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(class_3730 reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase(Locale.ROOT));
    }

    public void convert(class_1646 villager) {
        this.villagerSpawnQueue.add(villager);
    }
}

