/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.relationship.EntityRelationship;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.RelationshipState;
import net.conczin.mca.entity.ai.relationship.RelationshipType;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.ShowToastRequest;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.DataComponentsMCA;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.resources.API;
import net.conczin.mca.resources.Rank;
import net.conczin.mca.resources.Tasks;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.server.world.data.VillageManager;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSaveData
extends class_18
implements EntityRelationship {
    private final class_3218 world;
    private final UUID uuid;
    private final List<Letter> inbox = new LinkedList<Letter>();
    private Optional<Integer> lastSeenVillage = Optional.empty();
    private boolean entityDataSet;
    private class_2487 entityData;

    PlayerSaveData(class_3218 world, UUID uuid) {
        this.world = world;
        this.uuid = uuid;
        this.resetEntityData();
    }

    PlayerSaveData(class_3218 world, UUID uuid, class_2487 nbt) {
        this.world = world;
        this.uuid = uuid;
        this.lastSeenVillage = nbt.method_10573("lastSeenVillage", 3) ? Optional.of(nbt.method_10550("lastSeenVillage")) : Optional.empty();
        boolean bl = this.entityDataSet = nbt.method_10545("entityDataSet") && nbt.method_10577("entityDataSet");
        if (nbt.method_10545("entityData")) {
            this.entityData = nbt.method_10562("entityData");
        } else {
            this.resetEntityData();
        }
        class_2499 inbox = nbt.method_10554("inbox", 10);
        NbtHelper.toList((class_2520)inbox, e -> new Letter((class_2487)e, (class_7225.class_7874)world.method_30349()));
    }

    public static PlayerSaveData get(class_3222 player) {
        return PlayerSaveData.get((class_3218)player.method_37908(), player.method_5667());
    }

    public static PlayerSaveData get(class_3218 world, UUID uuid) {
        return WorldUtils.loadData(world.method_8503().method_30002(), (nbt, provider) -> new PlayerSaveData(world, uuid, (class_2487)nbt), w -> new PlayerSaveData(world, uuid), "mca_player_" + String.valueOf(uuid));
    }

    public static Optional<PlayerSaveData> getIfPresent(class_3218 world, UUID uuid) {
        return Optional.ofNullable((PlayerSaveData)world.method_17983().method_20786(new class_18.class_8645(() -> null, (nbt, provider) -> new PlayerSaveData(world, uuid, (class_2487)nbt), null), "mca_player_" + String.valueOf(uuid)));
    }

    public static void showMailNotification(class_3222 player) {
        Network.sendToPlayer(new ShowToastRequest("server.mail.title", "server.mail.description"), player);
    }

    private void resetEntityData() {
        this.entityData = new class_2487();
        VillagerEntityMCA villager = (VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.method_5883((class_1937)this.world);
        assert (villager != null);
        villager.initializeSkin(true);
        villager.getGenetics().randomize();
        villager.getTraits().randomize();
        villager.getVillagerBrain().randomize();
        villager.method_5652(this.entityData);
    }

    public boolean isEntityDataSet() {
        return this.entityDataSet;
    }

    public void setEntityDataSet(boolean entityDataSet) {
        this.entityDataSet = entityDataSet;
    }

    public class_2487 getEntityData() {
        return this.entityData;
    }

    public void setEntityData(class_2487 entityData) {
        this.entityData = entityData;
    }

    @Override
    public void onTragedy(class_1282 cause, @Nullable class_2338 burialSite, RelationshipType type, class_1297 victim) {
        EntityRelationship.super.onTragedy(cause, burialSite, type, victim);
        if (victim instanceof VillagerEntityMCA) {
            VillagerEntityMCA victimVillager = (VillagerEntityMCA)victim;
            this.sendLetterOfCondolence(victimVillager.method_5477().getString(), victimVillager.getResidency().getHomeVillage().map(Village::getName).orElse(API.getVillagePool().pickVillageName("village")));
        }
    }

    public void updateLastSeenVillage(VillageManager manager, class_3222 self) {
        Optional<Village> prevVillage = this.getLastSeenVillage(manager);
        Optional<Village> nextVillage = prevVillage.filter(v -> v.isWithinBorder((class_1297)self)).or(() -> manager.findNearestVillage((class_1297)self));
        this.setLastSeenVillage(self, prevVillage.orElse(null), nextVillage.orElse(null));
        if (nextVillage.isPresent()) {
            Rank rank = Tasks.getRank(nextVillage.get(), self);
            CriterionMCA.RANK.trigger(self, rank);
        }
    }

    public void setLastSeenVillage(class_3222 self, Village oldVillage, @Nullable Village newVillage) {
        this.lastSeenVillage = Optional.ofNullable(newVillage).map(Village::getId);
        this.method_80();
        if (oldVillage != newVillage) {
            if (oldVillage != null) {
                this.onLeave((class_1657)self, oldVillage);
            }
            if (newVillage != null) {
                this.onEnter((class_1657)self, newVillage);
            }
        }
    }

    public Optional<Village> getLastSeenVillage(VillageManager manager) {
        return this.lastSeenVillage.flatMap(manager::getOrEmpty);
    }

    public Optional<Integer> getLastSeenVillageId() {
        return this.lastSeenVillage;
    }

    protected void onLeave(class_1657 self, Village village) {
        if (Config.getInstance().enterVillageNotification && village.isVillage()) {
            self.method_7353((class_2561)class_2561.method_43469((String)"gui.village.left", (Object[])new Object[]{village.getName()}).method_27692(class_124.field_1065), true);
        }
    }

    protected void onEnter(class_1657 self, Village village) {
        if (Config.getInstance().enterVillageNotification && village.isVillage()) {
            self.method_7353((class_2561)class_2561.method_43469((String)"gui.village.welcome", (Object[])new Object[]{village.getName()}).method_27692(class_124.field_1065), true);
        }
        village.onEnter(this.world);
    }

    @Override
    public void marry(class_1297 spouse) {
        EntityRelationship.super.marry(spouse);
        this.method_80();
    }

    @Override
    public void endRelationShip(RelationshipState newState) {
        EntityRelationship.super.endRelationShip(newState);
        this.method_80();
    }

    @Override
    public class_3218 getWorld() {
        return this.world;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Gender getGender() {
        return Gender.byId(this.getEntityData().method_10550("gender"));
    }

    @Override
    @NotNull
    public FamilyTreeNode getFamilyEntry() {
        return this.getFamilyTree().getOrEmpty(this.uuid).orElseGet(() -> {
            String name = Optional.ofNullable(this.world.method_18470(this.uuid)).map(p -> p.method_5477().getString()).orElse("Unnamed Adventurer");
            return this.getFamilyTree().getOrCreate(this.uuid, name, this.getGender(), true);
        });
    }

    public void reset() {
        this.endRelationShip(RelationshipState.SINGLE);
        this.method_80();
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 provider) {
        this.lastSeenVillage.ifPresent(id -> nbt.method_10569("lastSeenVillage", id.intValue()));
        nbt.method_10566("entityData", (class_2520)this.entityData);
        nbt.method_10556("entityDataSet", this.entityDataSet);
        nbt.method_10566("inbox", (class_2520)NbtHelper.fromList(this.inbox, v -> v.toTag(provider)));
        return nbt;
    }

    public void sendMail(Letter pages) {
        if (Config.getInstance().enableVillagerMailingPlayers) {
            this.inbox.add(pages);
        }
        this.method_80();
    }

    public boolean hasMail() {
        return !this.inbox.isEmpty();
    }

    public class_1799 getMail() {
        if (this.hasMail()) {
            Letter letter = this.inbox.removeFirst();
            class_1799 stack = new class_1799((class_1935)ItemsMCA.LETTER, 1);
            stack.method_57379(DataComponentsMCA.BOOK_PAGES, letter.pages());
            return stack;
        }
        return null;
    }

    public void sendLetterOfCondolence(String name, String village) {
        this.sendLetter(new class_2561[]{class_2561.method_43469((String)"mca.letter.condolence", (Object[])new Object[]{this.getFamilyEntry().getName(), name, village})});
    }

    public void sendLetter(class_2561 ... lines) {
        this.sendMail(new Letter("", Arrays.asList(lines)));
        Optional.ofNullable(this.world.method_18470(this.uuid)).ifPresent(p -> PlayerSaveData.showMailNotification((class_3222)p));
    }

    public record Letter(String title, List<class_2561> pages) {
        private static final Codec<List<class_2561>> PAGES_CODEC = class_8824.field_46598.listOf();

        public Letter(class_2487 nbt, class_7225.class_7874 registries) {
            this(nbt.method_10558("title"), PAGES_CODEC.parse((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562("pages")).resultOrPartial(arg_0 -> ((Logger)MCA.LOGGER).error(arg_0)).orElse(List.of()));
        }

        class_2487 toTag(class_7225.class_7874 registries) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("title", this.title);
            class_6903 dynamicOps = registries.method_57093((DynamicOps)class_2509.field_11560);
            class_8824.field_46598.listOf().encodeStart((DynamicOps)dynamicOps, this.pages).resultOrPartial(arg_0 -> ((Logger)MCA.LOGGER).error(arg_0)).ifPresent(tag -> nbt.method_10566("pages", tag));
            return nbt;
        }
    }
}

