/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data.villageComponents;

import java.util.LinkedList;
import java.util.List;
import net.conczin.mca.Config;
import net.conczin.mca.entity.EquipmentSet;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.registry.ProfessionsMCA;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.class_1268;
import net.minecraft.class_3218;
import net.minecraft.class_3852;

public class VillageGuardsManager {
    private final Village village;

    public VillageGuardsManager(Village village) {
        this.village = village;
    }

    public static EquipmentSet getEquipmentFor(class_1268 dominantHand, EquipmentSet rightSet, EquipmentSet leftSet) {
        return dominantHand == class_1268.field_5810 && leftSet != null ? leftSet : rightSet;
    }

    public void spawnGuards(class_3218 world) {
        int guardCapacity = (int)Math.ceil((float)this.village.getPopulation() * Config.getInstance().guardSpawnFraction);
        int guards = 0;
        int citizen = 0;
        List<VillagerEntityMCA> villagers = this.village.getResidents(world);
        LinkedList<VillagerEntityMCA> nonGuards = new LinkedList<VillagerEntityMCA>();
        for (VillagerEntityMCA villager : villagers) {
            if (villager.isGuard()) {
                ++guards;
                continue;
            }
            if (!villager.method_6109() && !villager.isProfessionImportant() && villager.method_19269() == 0 && villager.method_7231().method_16925() <= 1) {
                nonGuards.add(villager);
            }
            ++citizen;
        }
        guards += (int)Math.ceil((float)(this.village.getPopulation() - guards - citizen) * Config.getInstance().guardSpawnFraction);
        if (!nonGuards.isEmpty() && guards < guardCapacity) {
            VillagerEntityMCA villager = (VillagerEntityMCA)nonGuards.get(world.field_9229.method_43048(nonGuards.size()));
            villager.setProfession(guards % 2 == 0 ? ProfessionsMCA.GUARD : ProfessionsMCA.ARCHER);
        }
    }

    public EquipmentSet getGuardEquipment(class_3852 profession, class_1268 dominantHand) {
        if (profession == ProfessionsMCA.ARCHER) {
            if (this.village.hasBuilding("armory")) {
                if (this.village.hasBuilding("blacksmith")) {
                    return VillageGuardsManager.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_2, EquipmentSet.ARCHER_2_LEFT);
                }
                return VillageGuardsManager.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_1, EquipmentSet.ARCHER_1_LEFT);
            }
            return VillageGuardsManager.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_0, EquipmentSet.ARCHER_0_LEFT);
        }
        if (this.village.hasBuilding("armory")) {
            if (this.village.hasBuilding("blacksmith")) {
                return EquipmentSet.GUARD_2;
            }
            return EquipmentSet.GUARD_1;
        }
        return VillageGuardsManager.getEquipmentFor(dominantHand, EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT);
    }
}

