/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import net.conczin.mca.client.book.Book;
import net.conczin.mca.client.book.pages.Page;
import net.conczin.mca.client.gui.widget.ExtendedPageTurnWidget;
import net.conczin.mca.util.compat.ButtonWidget;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public class ExtendedBookScreen
extends Screen {
    private final Book book;
    private int pageIndex;
    private PageButton nextPageButton;
    private PageButton previousPageButton;

    public ExtendedBookScreen(Book book) {
        super(GameNarrator.NO_TITLE);
        this.book = book;
        book.open();
        book.setPage(0, false);
    }

    public boolean setPage(int index) {
        int i = Mth.clamp((int)index, (int)0, (int)(this.book.getPageCount() - 1));
        if (i != this.pageIndex) {
            this.book.setPage(i, false);
            this.pageIndex = i;
            this.updatePageButtons();
            return true;
        }
        return false;
    }

    protected boolean jumpToPage(int page) {
        return this.setPage(page);
    }

    protected void init() {
        this.addCloseButton();
        this.addPageButtons();
    }

    protected void addCloseButton() {
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 100, 196, 200, 20, CommonComponents.GUI_DONE, buttonWidget -> this.minecraft.setScreen(null)));
    }

    protected void addPageButtons() {
        int i = (this.width - 192) / 2;
        this.nextPageButton = (PageButton)this.addRenderableWidget((GuiEventListener)new ExtendedPageTurnWidget(i + 116, 159, true, buttonWidget -> this.goToNextPage(), this.book.hasPageTurnSound(), this.book.getBackground()));
        this.previousPageButton = (PageButton)this.addRenderableWidget((GuiEventListener)new ExtendedPageTurnWidget(i + 43, 159, false, buttonWidget -> this.goToPreviousPage(), this.book.hasPageTurnSound(), this.book.getBackground()));
        this.updatePageButtons();
    }

    protected void goToPreviousPage() {
        if (this.book.getPage(this.pageIndex).previousPage()) {
            if (this.pageIndex > 0) {
                --this.pageIndex;
                this.book.setPage(this.pageIndex, true);
            }
            this.updatePageButtons();
        }
    }

    protected void goToNextPage() {
        if (this.book.getPage(this.pageIndex).nextPage()) {
            if (this.pageIndex < this.book.getPageCount() - 1) {
                ++this.pageIndex;
                this.book.setPage(this.pageIndex, false);
            }
            this.updatePageButtons();
        }
    }

    private void updatePageButtons() {
        this.nextPageButton.visible = this.pageIndex < this.book.getPageCount() - 1;
        this.previousPageButton.visible = this.pageIndex > 0;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return switch (keyCode) {
            case 266 -> {
                this.previousPageButton.onPress();
                yield true;
            }
            case 267 -> {
                this.nextPageButton.onPress();
                yield true;
            }
            default -> false;
        };
    }

    public Font getTextRenderer() {
        return this.font;
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(context, mouseX, mouseY, partialTick);
        int i = (this.width - 192) / 2;
        context.blit(this.book.getBackground(), i, 2, 0, 0, 192, 192);
        if (this.book.showPageCount()) {
            MutableComponent pageIndexText = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.pageIndex + 1, Math.max(this.book.getPageCount(), 1)}).withStyle(this.book.getTextFormatting());
            int k = this.font.width((FormattedText)pageIndexText);
            context.drawString(this.font, (Component)pageIndexText, i - k + 192 - 44, 18, 0, this.getBook().hasTextShadow());
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        Page page = this.book.getPage(this.pageIndex);
        if (page != null) {
            page.render(this, context, mouseX, mouseY, delta);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean handleComponentClicked(Style style) {
        ClickEvent clickEvent;
        ClickEvent clickEvent2 = clickEvent = style != null ? style.getClickEvent() : null;
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            try {
                return this.jumpToPage(Integer.parseInt(clickEvent.getValue()) - 1);
            }
            catch (Exception var5) {
                return false;
            }
        }
        boolean handled = super.handleComponentClicked(style);
        if (handled && clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.minecraft.setScreen(null);
        }
        return handled;
    }

    public Book getBook() {
        return this.book;
    }
}

