/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.conczin.mca.MCA;
import net.conczin.mca.client.gui.AbstractDynamicScreen;
import net.conczin.mca.client.gui.FamilyTreeScreen;
import net.conczin.mca.client.gui.MCAButton;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.entity.ai.Traits;
import net.conczin.mca.entity.ai.brain.VillagerBrain;
import net.conczin.mca.entity.ai.relationship.CompassionateEntity;
import net.conczin.mca.entity.ai.relationship.RelationshipState;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.GetInteractDataRequest;
import net.conczin.mca.network.c2s.InteractionCloseRequest;
import net.conczin.mca.network.c2s.InteractionDialogueInitMessage;
import net.conczin.mca.network.c2s.InteractionDialogueMessage;
import net.conczin.mca.network.c2s.InteractionVillagerMessage;
import net.conczin.mca.resources.data.Analysis;
import net.conczin.mca.resources.data.dialogue.Question;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class InteractScreen
extends AbstractDynamicScreen {
    public static final ResourceLocation ICON_TEXTURES = MCA.locate("textures/gui.png");
    private static Analysis analysis;
    private final VillagerLike<?> villager;
    private final Player player;
    private boolean inGiftMode;
    private int timeSinceLastClick;
    private String father;
    private String mother;
    private RelationshipState marriageState;
    private Component spouse;
    private List<String> dialogAnswers;
    private String dialogAnswerHover;
    private List<FormattedCharSequence> dialogQuestionText;
    private String dialogQuestionId;

    public InteractScreen(VillagerLike<?> villager) {
        super((Component)Component.literal((String)"Interact"));
        this.player = (Player)Objects.requireNonNull(Minecraft.getInstance().player);
        this.villager = villager;
    }

    public static void setAnalysis(Analysis analysis) {
        InteractScreen.analysis = analysis;
    }

    public void setParents(String father, String mother) {
        this.father = father;
        this.mother = mother;
    }

    public void setSpouse(RelationshipState marriageState, String spouse) {
        this.marriageState = marriageState;
        this.spouse = spouse == null ? Component.translatable((String)"gui.interact.label.parentUnknown") : Component.literal((String)spouse);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        Objects.requireNonNull(this.minecraft).setScreen(null);
        Network.sendToServer(new InteractionCloseRequest(this.villager.asEntity().getUUID()));
    }

    public void init() {
        Network.sendToServer(new GetInteractDataRequest(this.villager.asEntity().getId()));
    }

    public void tick() {
        ++this.timeSinceLastClick;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float tickDelta) {
        super.render(context, mouseX, mouseY, tickDelta);
        this.drawIcons(context);
        this.drawTextPopups(context);
    }

    public boolean mouseScrolled(double x, double y, double dx, double dy) {
        if (dy < 0.0) {
            this.player.getInventory().selected = this.player.getInventory().selected == 8 ? 0 : this.player.getInventory().selected + 1;
        } else if (dy > 0.0) {
            this.player.getInventory().selected = this.player.getInventory().selected == 0 ? 8 : this.player.getInventory().selected - 1;
        }
        return super.mouseScrolled(x, y, dx, dy);
    }

    public boolean mouseClicked(double posX, double posY, int button) {
        super.mouseClicked(posX, posY, button);
        if (button == 0 && this.dialogAnswerHover != null && this.dialogQuestionText != null) {
            Network.sendToServer(new InteractionDialogueMessage(this.villager.asEntity().getUUID(), this.dialogQuestionId, this.dialogAnswerHover));
        }
        if (this.inGiftMode && button == 1) {
            Network.sendToServer(new InteractionVillagerMessage("gift", this.villager.asEntity().getUUID()));
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyChar, int keyCode, int unknown) {
        if (keyChar == 256) {
            if (this.inGiftMode) {
                this.inGiftMode = false;
                this.setLayout("interact");
            } else {
                this.onClose();
            }
            return true;
        }
        return false;
    }

    private void drawIcons(GuiGraphics context) {
        PoseStack matrices = context.pose();
        Memories memory = this.villager.getVillagerBrain().getMemoriesForPlayer(this.player);
        matrices.pushPose();
        matrices.scale(1.5f, 1.5f, 1.5f);
        if (this.marriageState != null) {
            this.drawIcon(context, ICON_TEXTURES, this.marriageState.getIcon());
        }
        this.drawIcon(context, ICON_TEXTURES, memory.getHearts() < 0 ? "blackHeart" : (memory.getHearts() >= 100 ? "goldHeart" : "redHeart"));
        this.drawIcon(context, ICON_TEXTURES, "genes");
        if (this.canDrawParentsIcon()) {
            this.drawIcon(context, ICON_TEXTURES, "parents");
        }
        if (this.canDrawGiftIcon()) {
            this.drawIcon(context, ICON_TEXTURES, "gift");
        }
        if (analysis != null) {
            this.drawIcon(context, ICON_TEXTURES, "analysis");
        }
        matrices.popPose();
    }

    private void drawTextPopups(GuiGraphics context) {
        int h = 17;
        if (this.inGiftMode) {
            context.renderTooltip(this.font, (Component)Component.translatable((String)"gui.interact.label.giveGift"), 10, 28);
        } else {
            context.renderTooltip(this.font, this.villager.asEntity().getName(), 10, 28);
        }
        context.renderTooltip(this.font, (Component)(this.villager.asEntity().isBaby() ? this.villager.getAgeState().getName() : this.villager.getProfessionText()), 10, 30 + h);
        VillagerBrain<?> brain = this.villager.getVillagerBrain();
        context.renderTooltip(this.font, (Component)Component.translatable((String)"gui.interact.label.mood", (Object[])new Object[]{brain.getMood().getText()}).withStyle(brain.getMood().getColor()), 10, 30 + h * 2);
        if (this.hoveringOverText(10, 30 + h * 3, 128)) {
            context.renderTooltip(this.font, brain.getPersonality().getDescription(), 10, 30 + h * 3);
        } else {
            context.renderTooltip(this.font, (Component)Component.translatable((String)"gui.interact.label.personality", (Object[])new Object[]{brain.getPersonality().getName()}).withStyle(ChatFormatting.WHITE), 10, 30 + h * 3);
        }
        Set<Traits.Trait> traits = this.villager.getTraits().getTraits();
        if (!traits.isEmpty()) {
            if (this.hoveringOverText(10, 30 + h * 4, 128)) {
                traitText = traits.stream().map(Traits.Trait::getDescription).collect(Collectors.toList());
                traitText.addFirst(Component.translatable((String)"traits.title"));
                context.renderComponentTooltip(this.font, (List)traitText, 10, 30 + h * 4);
            } else {
                traitText = Component.translatable((String)"traits.title");
                traits.stream().map(Traits.Trait::getName).forEach(arg_0 -> InteractScreen.lambda$drawTextPopups$0((MutableComponent)traitText, arg_0));
                context.renderTooltip(this.font, (Component)traitText, 10, 30 + h * 4);
            }
        }
        if (this.hoveringOverIcon("redHeart")) {
            int hearts = brain.getMemoriesForPlayer(this.player).getHearts();
            this.drawHoveringIconText(context, (Component)Component.literal((String)(hearts + " hearts")), "redHeart");
        }
        if (this.marriageState != null && this.hoveringOverIcon("married") && this.villager instanceof CompassionateEntity) {
            String ms = this.marriageState.base().getIcon().toLowerCase(Locale.ENGLISH);
            this.drawHoveringIconText(context, (Component)Component.translatable((String)("gui.interact.label." + ms), (Object[])new Object[]{this.spouse}), "married");
        }
        if (this.canDrawParentsIcon() && this.hoveringOverIcon("parents")) {
            this.drawHoveringIconText(context, (Component)Component.translatable((String)"gui.interact.label.parents", (Object[])new Object[]{this.father == null ? Component.translatable((String)"gui.interact.label.parentUnknown") : this.father, this.mother == null ? Component.translatable((String)"gui.interact.label.parentUnknown") : this.mother}), "parents");
        }
        if (this.canDrawGiftIcon() && this.hoveringOverIcon("gift")) {
            this.drawHoveringIconText(context, (Component)Component.translatable((String)"gui.interact.label.gift"), "gift");
        }
        if (this.hoveringOverIcon("genes")) {
            LinkedList<Component> lines = new LinkedList<Component>();
            lines.add((Component)Component.literal((String)"Genes"));
            for (Genetics.Gene gene : this.villager.getGenetics()) {
                String key = gene.getType().getTranslationKey();
                int value = (int)(gene.get() * 100.0f);
                lines.add((Component)Component.translatable((String)"gene.tooltip", (Object[])new Object[]{Component.translatable((String)key), value}));
            }
            this.drawHoveringIconText(context, lines, "genes");
        }
        if (this.hoveringOverIcon("analysis") && analysis != null) {
            LinkedList<Component> lines = new LinkedList<Component>();
            lines.add((Component)Component.translatable((String)"analysis.title").withStyle(ChatFormatting.GRAY));
            for (Analysis.AnalysisElement d : analysis) {
                lines.add((Component)Component.translatable((String)("analysis." + d.key())).append((Component)Component.literal((String)(": " + (d.positive() ? "+" : "") + d.value()))).withStyle(d.positive() ? ChatFormatting.GREEN : ChatFormatting.RED));
            }
            String chance = analysis.getTotalAsString();
            lines.add((Component)Component.translatable((String)"analysis.total").append(": " + (String)chance));
            this.drawHoveringIconText(context, lines, "analysis");
        }
        if (this.dialogQuestionText != null) {
            context.fill(this.width / 2 - 85, this.height / 2 - 50 - 10 * this.dialogQuestionText.size(), this.width / 2 + 85, this.height / 2 - 30 + 10 * this.dialogAnswers.size(), 0x77000000);
            int i = -this.dialogQuestionText.size();
            for (FormattedCharSequence t : this.dialogQuestionText) {
                context.drawString(this.font, t, this.width / 2 - this.font.width(t) / 2, this.height / 2 - 50 + ++i * 10, -1);
            }
            this.dialogAnswerHover = null;
            context.hLine(this.width / 2 - 75, this.width / 2 + 75, this.height / 2 - 40, -1426063361);
            int y = this.height / 2 - 35;
            for (String a : this.dialogAnswers) {
                boolean hover = this.hoveringOver(this.width / 2 - 100, y - 3, 200, 10);
                context.drawCenteredString(this.font, (Component)Component.translatable((String)Question.getTranslationKey(this.dialogQuestionId, a)), this.width / 2, y, hover ? -2631804 : -1426063361);
                if (hover) {
                    this.dialogAnswerHover = a;
                }
                y += 10;
            }
        }
    }

    private boolean hoveringOverText(int x, int y, int w) {
        return this.hoveringOver(x + 8, y - 16, w, 16);
    }

    private boolean canDrawParentsIcon() {
        return this.father != null || this.mother != null;
    }

    private boolean canDrawGiftIcon() {
        return false;
    }

    public void setDialogue(String dialogue, List<String> answers) {
        this.dialogQuestionId = dialogue;
        this.dialogAnswers = answers;
    }

    public void setLastPhrase(Component questionText, boolean silent) {
        Component text = !silent ? this.villager.sendChatMessage(questionText, (Entity)this.player) : this.villager.transformMessage(questionText);
        this.dialogQuestionText = this.font.split((FormattedText)text, 160);
    }

    @Override
    protected void buttonPressed(MCAButton button) {
        String id = button.identifier();
        if (this.timeSinceLastClick <= 2) {
            return;
        }
        this.timeSinceLastClick = 0;
        if (id.equals("gui.button.interact")) {
            this.setLayout("interact");
        } else if (id.equals("gui.button.command")) {
            this.setLayout("command");
            this.disableButton("gui.button." + this.villager.getVillagerBrain().getMoveState().name().toLowerCase(Locale.ENGLISH));
        } else if (id.equals("gui.button.clothing")) {
            this.setLayout("clothing");
        } else if (id.equals("gui.button.familyTree")) {
            Minecraft.getInstance().setScreen((Screen)new FamilyTreeScreen(this.villager.asEntity().getUUID()));
        } else if (id.equals("gui.button.talk")) {
            this.clearWidgets();
            Network.sendToServer(new InteractionDialogueInitMessage(this.villager.asEntity().getUUID()));
        } else if (id.equals("gui.button.work")) {
            this.setLayout("work");
            this.disableButton("gui.button." + this.villager.getVillagerBrain().getCurrentJob().name().toLowerCase(Locale.ENGLISH));
        } else if (id.equals("gui.button.professions")) {
            this.setLayout("professions");
        } else if (id.equals("gui.button.backarrow")) {
            if (this.inGiftMode) {
                this.inGiftMode = false;
                this.setLayout("interact");
            } else if (this.getActiveScreen().equals("locations")) {
                this.setLayout("interact");
            } else {
                this.setLayout("main");
            }
        } else if (id.equals("gui.button.locations")) {
            this.setLayout("locations");
        } else if (button.notifyServer()) {
            if (!button.targetServer()) {
                Network.sendToServer(new InteractionVillagerMessage(id.replace("gui.button.", ""), this.villager.asEntity().getUUID()));
            }
        } else if (id.equals("gui.button.gift")) {
            this.inGiftMode = true;
            this.disableAllButtons();
        }
    }

    private static /* synthetic */ void lambda$drawTextPopups$0(MutableComponent traitText, Component t) {
        if (!traitText.getSiblings().isEmpty()) {
            traitText.append((Component)Component.literal((String)", "));
        }
        traitText.append(t);
    }
}

